/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.geometry.support.JunPointsOnPlane;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class Jun3dTriangleTestExamples
extends JunTestExamples {
    public static boolean Example1() {
        Jun3dTriangle jun3dTriangle = Jun3dTriangle.On_on_on_(new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        System.out.println(jun3dTriangle.printString());
        System.out.println(jun3dTriangle.storeString());
        System.out.println("area:" + jun3dTriangle.area());
        System.out.println("volume:" + jun3dTriangle.volume());
        jun3dTriangle.asJunOpenGL3dObject().showWithUnitAxes();
        return true;
    }

    public static boolean Example2() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, 1.0, 1.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean Example3() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.0, 0.5, 0.5), new Jun3dPoint(0.0, 1.0, 1.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean Example4() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean Example5() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(0.2, -0.2, 0.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean Example6() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(0.5, -0.5, 0.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean Example7() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(-0.5, 0.5, 0.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean Example8() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(0.75, -0.75, 0.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean Example9() {
        Jun3dTriangle jun3dTriangle = new Jun3dPoint(1.0, 0.0, 0.0).triangle_and_(new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(-0.75, 0.75, 0.0));
        Map map = jun3dTriangle.tableDividedBy_(junPlane);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
        junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        junOpenGL3dCompoundObject.showProjectionTable_(Jun3dTriangleTestExamples.PrivateProjectionTable());
        return true;
    }

    public static boolean ExampleA() {
        final Jun3dTriangle jun3dTriangle = new Jun3dTriangle(new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Map map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"presentation"), Jun3dTriangleTestExamples.$((String)"hiddenlinePresentation"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 227, 408, 426));
        for (int i = -55; i <= 55; ++i) {
            final Double d = new Double((double)i / 100.0);
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    double d2 = d;
                    JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(d2, -d2, 0.0));
                    Map map = jun3dTriangle.tableDividedBy_(junPlane);
                    JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                    junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
                    junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
                    junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
                    junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel.changed_(1.$((String)"object"));
                    return null;
                }
            }, 100);
        }
        return true;
    }

    public static boolean ExampleB() {
        final Jun3dTriangle jun3dTriangle = new Jun3dTriangle(new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Map map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"presentation"), Jun3dTriangleTestExamples.$((String)"hiddenlinePresentation"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 227, 408, 426));
        int n = 0;
        while ((double)n <= 144.0) {
            final Double d = new Double((double)n * 2.5);
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(d), new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 1.0, 1.0))));
                    Map map = jun3dTriangle.tableDividedBy_(junPlane);
                    JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                    junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
                    junOpenGL3dCompoundObject.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
                    junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
                    junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel.changed_(2.$((String)"object"));
                    return null;
                }
            }, 100);
            ++n;
        }
        return true;
    }

    public static boolean ExampleC() {
        int n;
        Jun3dBoundingBox jun3dBoundingBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5)).translatedBy_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333));
        final Jun3dTriangle[] jun3dTriangleArray = jun3dBoundingBox.asArrayOf3dTriangles();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Map map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        final JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 227, 408, 426));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"eyePoint"), ((Jun3dPoint)((Object)map.get(Jun3dTriangleTestExamples.$((String)"eyePoint")))).negated());
        final JunOpenGLDisplayModel junOpenGLDisplayModel2 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(516, 227, 408, 426));
        StApplicationModel[] stApplicationModelArray = new JunApplicationModel[]{junOpenGLDisplayModel, junOpenGLDisplayModel2};
        for (n = 0; n < stApplicationModelArray.length; ++n) {
            stApplicationModelArray[n].closeTogether_(stApplicationModelArray);
        }
        for (n = -55; n <= 55; ++n) {
            final Double d = new Double((double)n / 100.0);
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    double d2 = d;
                    JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(d2, -d2, 0.0));
                    JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                    for (int i = 0; i < jun3dTriangleArray.length; ++i) {
                        Map map = jun3dTriangleArray[i].tableDividedBy_(junPlane);
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
                        junOpenGL3dCompoundObject2.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
                        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
                    }
                    junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel2.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel.changed_(3.$((String)"object"));
                    junOpenGLDisplayModel2.changed_(3.$((String)"object"));
                    return null;
                }
            }, 100);
        }
        return true;
    }

    public static boolean ExampleD() {
        int n;
        Jun3dBoundingBox jun3dBoundingBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5)).translatedBy_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333));
        final Jun3dTriangle[] jun3dTriangleArray = jun3dBoundingBox.asArrayOf3dTriangles();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Map map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        final JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 227, 408, 426));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"eyePoint"), ((Jun3dPoint)((Object)map.get(Jun3dTriangleTestExamples.$((String)"eyePoint")))).negated());
        final JunOpenGLDisplayModel junOpenGLDisplayModel2 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(516, 227, 408, 426));
        StApplicationModel[] stApplicationModelArray = new JunApplicationModel[]{junOpenGLDisplayModel, junOpenGLDisplayModel2};
        for (n = 0; n < stApplicationModelArray.length; ++n) {
            stApplicationModelArray[n].closeTogether_(stApplicationModelArray);
        }
        n = 0;
        while ((double)n <= 144.0) {
            final Double d = new Double((double)n * 2.5);
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(d), new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 1.0, 1.0))));
                    JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                    for (int i = 0; i < jun3dTriangleArray.length; ++i) {
                        Map map = jun3dTriangleArray[i].tableDividedBy_(junPlane);
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
                        junOpenGL3dCompoundObject2.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
                        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
                    }
                    junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel2.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel.changed_(4.$((String)"object"));
                    junOpenGLDisplayModel2.changed_(4.$((String)"object"));
                    return null;
                }
            }, 100);
            ++n;
        }
        return true;
    }

    public static boolean ExampleE() {
        int n;
        Jun3dBoundingBox jun3dBoundingBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5)).translatedBy_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333));
        final Jun3dTriangle[] jun3dTriangleArray = jun3dBoundingBox.asArrayOf3dTriangles();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Map map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"presentation"), Jun3dTriangleTestExamples.$((String)"hiddenlinePresentation"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 227, 408, 426));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"eyePoint"), ((Jun3dPoint)((Object)map.get(Jun3dTriangleTestExamples.$((String)"eyePoint")))).negated());
        map.put(Jun3dTriangleTestExamples.$((String)"presentation"), Jun3dTriangleTestExamples.$((String)"hiddenlinePresentation"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel2 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(516, 227, 408, 426));
        StApplicationModel[] stApplicationModelArray = new JunApplicationModel[]{junOpenGLDisplayModel, junOpenGLDisplayModel2};
        for (n = 0; n < stApplicationModelArray.length; ++n) {
            stApplicationModelArray[n].closeTogether_(stApplicationModelArray);
        }
        n = 0;
        while ((double)n <= 144.0) {
            final Double d = new Double((double)n * 2.5);
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.3333333333333333, 0.3333333333333333, 0.3333333333333333), new Jun3dPoint(1.0, -1.0, 0.0)).transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(d), new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 1.0, 1.0))));
                    JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                    for (int i = 0; i < jun3dTriangleArray.length; ++i) {
                        Map map = jun3dTriangleArray[i].tableDividedBy_(junPlane);
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivateTableBody(map));
                        junOpenGL3dCompoundObject2.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
                        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
                    }
                    junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel2.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel.changed_(5.$((String)"object"));
                    junOpenGLDisplayModel2.changed_(5.$((String)"object"));
                    return null;
                }
            }, 100);
            ++n;
        }
        return true;
    }

    public static boolean ExampleF() {
        int n;
        Jun3dBoundingBox jun3dBoundingBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 1.0, 1.0));
        final Jun3dTriangle[] jun3dTriangleArray = jun3dBoundingBox.asArrayOf3dTriangles();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Map map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 227, 308, 326));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"eyePoint"), ((Jun3dPoint)((Object)map.get(Jun3dTriangleTestExamples.$((String)"eyePoint")))).negated());
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel2 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(416, 227, 308, 326));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel3 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 567, 308, 326));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel4 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(416, 567, 308, 326));
        junOpenGLDisplayModel.displayLightsAllOff();
        junOpenGLDisplayModel2.displayLightsAllOff();
        junOpenGLDisplayModel3.displayLightsAllOff();
        junOpenGLDisplayModel4.displayLightsAllOff();
        ((Frame)junOpenGLDisplayModel.getWindow()).setTitle("Fore");
        ((Frame)junOpenGLDisplayModel2.getWindow()).setTitle("Back");
        ((Frame)junOpenGLDisplayModel3.getWindow()).setTitle("Line");
        ((Frame)junOpenGLDisplayModel4.getWindow()).setTitle("Sect");
        StApplicationModel[] stApplicationModelArray = new JunApplicationModel[]{junOpenGLDisplayModel, junOpenGLDisplayModel2, junOpenGLDisplayModel3, junOpenGLDisplayModel4};
        for (n = 0; n < stApplicationModelArray.length; ++n) {
            stApplicationModelArray[n].closeTogether_(stApplicationModelArray);
        }
        for (n = 0; n <= 180; n += 2) {
            final Double d = new Double(n);
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    ArrayList arrayList = new ArrayList();
                    JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.5, 0.5, 0.5), new Jun3dPoint(1.0, -1.0, 0.0)).transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(d), new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 1.0, 1.0))));
                    JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                    for (int i = 0; i < jun3dTriangleArray.length; ++i) {
                        Map map = jun3dTriangleArray[i].tableDividedBy_(junPlane);
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivateColorBody(map));
                        junOpenGL3dCompoundObject2.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
                        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
                        arrayList.addAll((Collection)map.get(6.$((String)"points")));
                    }
                    junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel2.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel3.displayObject_(Jun3dTriangleTestExamples.PrivateLineBody(arrayList));
                    junOpenGLDisplayModel4.displayObject_(Jun3dTriangleTestExamples.PrivateSectBody(arrayList));
                    junOpenGLDisplayModel.changed_(6.$((String)"object"));
                    junOpenGLDisplayModel2.changed_(6.$((String)"object"));
                    junOpenGLDisplayModel3.changed_(6.$((String)"object"));
                    junOpenGLDisplayModel4.changed_(6.$((String)"object"));
                    return null;
                }
            }, 100);
        }
        return true;
    }

    public static boolean ExampleG() {
        int n;
        Jun3dBoundingBox jun3dBoundingBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 1.0, 1.0));
        final Jun3dTriangle[] jun3dTriangleArray = jun3dBoundingBox.asArrayOf3dTriangles();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Map map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 227, 308, 326));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"eyePoint"), ((Jun3dPoint)((Object)map.get(Jun3dTriangleTestExamples.$((String)"eyePoint")))).negated());
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel2 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(416, 227, 308, 326));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        final JunOpenGLDisplayModel junOpenGLDisplayModel3 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(96, 567, 308, 326));
        map = Jun3dTriangleTestExamples.PrivateProjectionTable();
        map.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        map.put(Jun3dTriangleTestExamples.$((String)"sightPoint"), new Jun3dPoint(0.3, 0.3, 0.3));
        map.put(Jun3dTriangleTestExamples.$((String)"eyePoint"), new Jun3dPoint(100.0, -100.0, 30.0));
        map.put(Jun3dTriangleTestExamples.$((String)"upVector"), new Jun3dPoint(0.0, 0.0, 1.0));
        final JunOpenGLDisplayModel junOpenGLDisplayModel4 = junOpenGL3dCompoundObject.showProjectionTable_in_(map, new Rectangle(416, 567, 308, 326));
        junOpenGLDisplayModel.displayLightsAllOff();
        junOpenGLDisplayModel2.displayLightsAllOff();
        junOpenGLDisplayModel3.displayLightsAllOff();
        junOpenGLDisplayModel4.displayLightsAllOff();
        ((Frame)junOpenGLDisplayModel.getWindow()).setTitle("Fore");
        ((Frame)junOpenGLDisplayModel2.getWindow()).setTitle("Back");
        ((Frame)junOpenGLDisplayModel3.getWindow()).setTitle("Line");
        ((Frame)junOpenGLDisplayModel4.getWindow()).setTitle("Sect");
        StApplicationModel[] stApplicationModelArray = new JunApplicationModel[]{junOpenGLDisplayModel, junOpenGLDisplayModel2, junOpenGLDisplayModel3, junOpenGLDisplayModel4};
        for (n = 0; n < stApplicationModelArray.length; ++n) {
            stApplicationModelArray[n].closeTogether_(stApplicationModelArray);
        }
        for (n = -55; n <= 55; ++n) {
            final Double d = new Double((double)n / 100.0);
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    ArrayList arrayList = new ArrayList();
                    double d2 = d;
                    JunPlane junPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.5, 0.5, 0.5), new Jun3dPoint(1.0, -1.0, 0.0)).translatedBy_(new Jun3dPoint(d2, -d2, 0.0));
                    JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                    for (int i = 0; i < jun3dTriangleArray.length; ++i) {
                        Map map = jun3dTriangleArray[i].tableDividedBy_(junPlane);
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivatePlaneBody(junPlane));
                        junOpenGL3dCompoundObject2.add_(Jun3dTriangleTestExamples.PrivateColorBody(map));
                        junOpenGL3dCompoundObject2.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
                        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
                        arrayList.addAll((Collection)map.get(7.$((String)"points")));
                    }
                    junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel2.displayObject_(junOpenGL3dCompoundObject);
                    junOpenGLDisplayModel3.displayObject_(Jun3dTriangleTestExamples.PrivateLineBody(arrayList));
                    junOpenGLDisplayModel4.displayObject_(Jun3dTriangleTestExamples.PrivateSectBody(arrayList));
                    junOpenGLDisplayModel.changed_(7.$((String)"object"));
                    junOpenGLDisplayModel2.changed_(7.$((String)"object"));
                    junOpenGLDisplayModel3.changed_(7.$((String)"object"));
                    junOpenGLDisplayModel4.changed_(7.$((String)"object"));
                    return null;
                }
            }, 100);
        }
        return true;
    }

    public static boolean ExampleH() {
        Jun3dTriangle jun3dTriangle = Jun3dTriangle.On_on_on_(new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0));
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(jun3dTriangle.asJunOpenGL3dObject());
        JunPlane[] junPlaneArray = jun3dTriangle.threePlanes();
        for (int i = 0; i < junPlaneArray.length; ++i) {
            junOpenGL3dCompoundObject.add_(junPlaneArray[i].asJunOpenGL3dObject());
        }
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.2));
        junOpenGL3dCompoundObject.show();
        return true;
    }

    private static JunOpenGL3dObject PrivatePlaneBody(JunPlane junPlane) {
        Jun3dCircle jun3dCircle = new Jun3dCircle(junPlane.p1(), 1.0, junPlane.normalVector());
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dCircle.trackPoints());
        junOpenGL3dPolygon.paint_(Color.magenta);
        junOpenGL3dPolygon.halftone_(0.5);
        return junOpenGL3dPolygon;
    }

    private static JunOpenGL3dObject PrivateTableBody(Map map) {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Iterator iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"positives"))).iterator();
        while (iterator.hasNext()) {
            junOpenGL3dCompoundObject.add_(((JunGeometry)((Object)iterator.next())).asJunOpenGL3dObjectColor_(Color.cyan));
        }
        iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"zeros"))).iterator();
        while (iterator.hasNext()) {
            junOpenGL3dCompoundObject.add_(((JunGeometry)((Object)iterator.next())).asJunOpenGL3dObjectColor_(Color.gray));
        }
        iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"negatives"))).iterator();
        while (iterator.hasNext()) {
            junOpenGL3dCompoundObject.add_(((JunGeometry)((Object)iterator.next())).asJunOpenGL3dObjectColor_(Color.yellow));
        }
        iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"points"))).iterator();
        while (iterator.hasNext()) {
            junOpenGL3dCompoundObject.add_(((JunGeometry)((Object)iterator.next())).asJunOpenGL3dObjectColor_(Color.black));
        }
        return junOpenGL3dCompoundObject;
    }

    private static JunOpenGL3dObject PrivateColorBody(Map map) {
        JunOpenGL3dPolygon junOpenGL3dPolygon;
        Color[] colorArray;
        Jun3dPoint[] jun3dPointArray;
        Jun3dTriangle jun3dTriangle;
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Iterator iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"positives"))).iterator();
        while (iterator.hasNext()) {
            jun3dTriangle = (Jun3dTriangle)((Object)iterator.next());
            jun3dPointArray = new Jun3dPoint[]{jun3dTriangle.first(), jun3dTriangle.second(), jun3dTriangle.third()};
            colorArray = new Color[jun3dPointArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                colorArray[i] = new Color((float)jun3dPointArray[i].x(), (float)jun3dPointArray[i].y(), (float)jun3dPointArray[i].z());
            }
            junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray, colorArray);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon);
        }
        iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"zeros"))).iterator();
        while (iterator.hasNext()) {
            junOpenGL3dCompoundObject.add_(((JunGeometry)((Object)iterator.next())).asJunOpenGL3dObjectColor_(Color.gray));
        }
        iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"negatives"))).iterator();
        while (iterator.hasNext()) {
            jun3dTriangle = (Jun3dTriangle)((Object)iterator.next());
            jun3dPointArray = new Jun3dPoint[]{jun3dTriangle.first(), jun3dTriangle.second(), jun3dTriangle.third()};
            colorArray = new Color[jun3dPointArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                colorArray[i] = new Color((float)jun3dPointArray[i].x(), (float)jun3dPointArray[i].y(), (float)jun3dPointArray[i].z());
            }
            junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray, colorArray);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon);
        }
        iterator = ((List)map.get(Jun3dTriangleTestExamples.$((String)"points"))).iterator();
        while (iterator.hasNext()) {
            junOpenGL3dCompoundObject.add_(((JunGeometry)((Object)iterator.next())).asJunOpenGL3dObjectColor_(Color.black));
        }
        return junOpenGL3dCompoundObject;
    }

    private static JunOpenGL3dObject PrivateLineBody(Collection collection) {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        if (!collection.isEmpty()) {
            JunPointsOnPlane junPointsOnPlane = new JunPointsOnPlane(collection);
            Jun3dPoint[] jun3dPointArray = junPointsOnPlane.sortedPoints();
            junOpenGL3dCompoundObject.add_(new Jun3dPolyline(jun3dPointArray).asJunOpenGL3dObjectColor_(Color.black));
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                Color color = Color.getHSBColor((float)i / (float)jun3dPointArray.length, 1.0f, 1.0f);
                junOpenGL3dCompoundObject.add_(jun3dPointArray[i].asJunOpenGL3dObjectColor_(color));
            }
        }
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        return junOpenGL3dCompoundObject;
    }

    private static JunOpenGL3dObject PrivateSectBody(Collection collection) {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        if (!collection.isEmpty()) {
            JunPointsOnPlane junPointsOnPlane = new JunPointsOnPlane(collection);
            Jun3dPoint[] jun3dPointArray = junPointsOnPlane.sortedPoints();
            Color[] colorArray = new Color[jun3dPointArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                colorArray[i] = new Color((float)jun3dPointArray[i].x(), (float)jun3dPointArray[i].y(), (float)jun3dPointArray[i].z());
            }
            if (jun3dPointArray.length > 2) {
                JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray, colorArray);
                junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon);
            } else {
                JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray, colorArray);
                junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
            }
        }
        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
        return junOpenGL3dCompoundObject;
    }

    private static Map PrivateProjectionTable() {
        HashMap<StSymbol, Object> hashMap = new HashMap<StSymbol, Object>();
        hashMap.put(Jun3dTriangleTestExamples.$((String)"viewFactor"), new Double(10.0));
        hashMap.put(Jun3dTriangleTestExamples.$((String)"presentation"), Jun3dTriangleTestExamples.$((String)"soldPresentation"));
        hashMap.put(Jun3dTriangleTestExamples.$((String)"eyePoint"), (Object)new Jun3dPoint(14.477702891463, 9.1335346899163, 5.5654885728598));
        hashMap.put(Jun3dTriangleTestExamples.$((String)"upVector"), (Object)new Jun3dPoint(-0.26322225132661, -0.1622475126126, 0.95099410674177));
        hashMap.put(Jun3dTriangleTestExamples.$((String)"sightPoint"), (Object)new Jun3dPoint(0.0, 0.0, 0.0));
        hashMap.put(Jun3dTriangleTestExamples.$((String)"shading"), Jun3dTriangleTestExamples.$((String)"smoothShading"));
        hashMap.put(Jun3dTriangleTestExamples.$((String)"zoomHeight"), new Double(3.5));
        return hashMap;
    }

    public static void main(String[] stringArray) {
        new Jun3dTriangleTestExamples();
    }
}

