/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.support;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.system.framework.JunAbstractObject;

public class JunPointsOnPlane
extends JunAbstractObject {
    public static final double ACCURACY = 1.0E-12 * Math.pow(10.0, Math.max(0L, Math.round(Math.log(1.0E12) / Math.log(10.0) / 2.0)));
    protected ArrayList sourcePoints;
    protected Jun3dPoint averagePoint;
    protected Jun3dPoint positivePoint;
    protected Jun3dPoint negativePoint;
    protected Jun3dLine horizontalLine;
    protected Jun3dLine verticalLine;
    protected Jun3dLine normalLine;
    protected Jun3dPoint[] sortedPoints;

    public JunPointsOnPlane(Jun3dPoint[] jun3dPointArray) {
        this.addAll_(jun3dPointArray);
    }

    public JunPointsOnPlane(Collection collection) {
        this.addAll_(collection);
    }

    protected void initialize() {
        super.initialize();
        this.sourcePoints = null;
        this.flushAll();
    }

    public int numberOfPoints() {
        return this._sourcePoints().size();
    }

    public double radiusValue() {
        return this.averagePoint().distance_(this.positivePoint());
    }

    public double diameterValue() {
        return this.radiusValue() * 2.0;
    }

    public Jun3dPoint[] sourcePoints() {
        return this._sourcePoints().toArray(new Jun3dPoint[this._sourcePoints().size()]);
    }

    protected ArrayList _sourcePoints() {
        if (this.sourcePoints == null) {
            this.sourcePoints = new ArrayList();
        }
        return this.sourcePoints;
    }

    public Jun3dPoint averagePoint() {
        if (this.averagePoint == null) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            Jun3dPoint[] jun3dPointArray = this.sourcePoints();
            if (jun3dPointArray.length > 0) {
                for (int i = 0; i < jun3dPointArray.length; ++i) {
                    d += jun3dPointArray[i].x();
                    d2 += jun3dPointArray[i].y();
                    d3 += jun3dPointArray[i].z();
                }
                d /= (double)jun3dPointArray.length;
                d2 /= (double)jun3dPointArray.length;
                d3 /= (double)jun3dPointArray.length;
            }
            this.averagePoint = new Jun3dPoint(d, d2, d3);
        }
        return this.averagePoint;
    }

    public Jun3dPoint centerPoint() {
        return this.averagePoint();
    }

    public Jun3dPoint positivePoint() {
        if (this.positivePoint == null) {
            Jun3dPoint[] jun3dPointArray = this.sourcePoints();
            if (jun3dPointArray.length > 0) {
                Jun3dPoint jun3dPoint = this.averagePoint();
                Jun3dPoint jun3dPoint2 = null;
                double d = Double.MIN_VALUE;
                for (int i = 0; i < jun3dPointArray.length; ++i) {
                    double d2 = jun3dPoint.distance_(jun3dPointArray[i]);
                    if (!(d2 >= d)) continue;
                    d = d2;
                    jun3dPoint2 = jun3dPointArray[i];
                }
                if (jun3dPoint2 != null) {
                    if (jun3dPoint2.distance_(jun3dPoint) < this.accuracy()) {
                        jun3dPoint2 = jun3dPoint.plus_(new Jun3dPoint(1.0, 0.0, 0.0));
                    }
                    this.positivePoint = jun3dPoint2;
                }
            }
            if (this.positivePoint == null) {
                this.positivePoint = new Jun3dPoint(1.0, 0.0, 0.0);
            }
        }
        return this.positivePoint;
    }

    public Jun3dPoint negativePoint() {
        if (this.negativePoint == null) {
            Jun3dPoint[] jun3dPointArray = this.sourcePoints();
            if (jun3dPointArray.length > 0) {
                JunPlane junPlane = this.yzPlane();
                Jun3dPoint jun3dPoint = null;
                double d = Double.MIN_VALUE;
                for (int i = 0; i < jun3dPointArray.length; ++i) {
                    double d2;
                    if (jun3dPointArray[i].whichSideOf_(junPlane) >= 0 || !((d2 = this.positivePoint().distance_(jun3dPointArray[i])) >= d)) continue;
                    d = d2;
                    jun3dPoint = jun3dPointArray[i];
                }
                if (jun3dPoint != null) {
                    if (jun3dPoint.distance_(this.positivePoint()) < this.accuracy()) {
                        jun3dPoint = this.positivePoint().plus_(new Jun3dPoint(-1.0, 0.0, 0.0));
                    }
                    this.negativePoint = jun3dPoint;
                }
            }
            if (this.negativePoint == null) {
                this.negativePoint = new Jun3dPoint(-1.0, 0.0, 0.0);
            }
        }
        return this.negativePoint;
    }

    public Jun3dPoint[] sortedPoints() {
        if (this.sortedPoints == null) {
            this.sortedPoints = this.computeSortedPoints();
        }
        return this.sortedPoints;
    }

    public Jun3dLine horizontalLine() {
        if (this.horizontalLine == null) {
            this.horizontalLine = this.averagePoint().to_(this.positivePoint()).normalizedLine();
        }
        return this.horizontalLine;
    }

    public Jun3dLine verticalLine() {
        if (this.verticalLine == null) {
            Jun3dPoint[] jun3dPointArray = this.sourcePoints();
            if (jun3dPointArray.length > 0) {
                Jun3dLine jun3dLine = null;
                double d = Double.MIN_VALUE;
                for (int i = 0; i < jun3dPointArray.length; ++i) {
                    Jun3dPoint jun3dPoint = this.horizontalLine().nearestPointFromPoint_(jun3dPointArray[i]);
                    double d2 = jun3dPointArray[i].distance_(jun3dPoint);
                    if (!(d2 >= d)) continue;
                    d = d2;
                    jun3dLine = jun3dPoint.to_(jun3dPointArray[i]);
                }
                if (jun3dLine.from().distance_(jun3dLine.to()) >= this.accuracy()) {
                    this.verticalLine = this.averagePoint().to_(this.averagePoint().plus_(jun3dLine.normalUnitVector()));
                }
            }
            if (this.verticalLine == null) {
                this.verticalLine = this.averagePoint().to_(this.averagePoint().plus_(new Jun3dPoint(0.0, 1.0, 0.0)));
            }
        }
        return this.verticalLine;
    }

    public Jun3dLine normalLine() {
        if (this.normalLine == null) {
            this.normalLine = this.averagePoint().to_(this.averagePoint().plus_(this.xyPlane().normalUnitVector()));
        }
        return this.normalLine;
    }

    public Jun3dLine xLine() {
        return this.horizontalLine();
    }

    public Jun3dLine yLine() {
        return this.verticalLine();
    }

    public Jun3dLine zLine() {
        return this.normalLine();
    }

    public JunPlane xyPlane() {
        return new JunPlane(this.averagePoint(), this.xLine().to(), this.yLine().to());
    }

    public JunPlane yzPlane() {
        return new JunPlane(this.averagePoint(), this.yLine().to(), this.zLine().to());
    }

    public JunPlane zxPlane() {
        return new JunPlane(this.averagePoint(), this.zLine().to(), this.xLine().to());
    }

    public Jun3dPoint horizontalVector() {
        return this.horizontalLine().to().minus_(this.horizontalLine().from());
    }

    public Jun3dPoint verticalVector() {
        return this.verticalLine().to().minus_(this.verticalLine().from());
    }

    public Jun3dPoint normalVector() {
        return this.normalLine().to().minus_(this.normalLine().from());
    }

    public void add_(Jun3dPoint jun3dPoint) {
        for (int i = 0; i < this._sourcePoints().size(); ++i) {
            Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)this._sourcePoints().get(i));
            if (!(jun3dPoint2.distance_(jun3dPoint) < this.accuracy())) continue;
            return;
        }
        this._sourcePoints().add(jun3dPoint);
        this.flushAll();
    }

    public void addAll_(Jun3dPoint[] jun3dPointArray) {
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            this.add_(jun3dPointArray[i]);
        }
    }

    public void addAll_(Collection collection) {
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Jun3dPoint)) continue;
            this.add_((Jun3dPoint)((Object)objectArray[i]));
        }
    }

    public Jun3dCircle asCircle() {
        return new Jun3dCircle(this.centerPoint(), this.radiusValue(), this.normalVector());
    }

    protected void flushAll() {
        this.averagePoint = null;
        this.positivePoint = null;
        this.negativePoint = null;
        this.horizontalLine = null;
        this.verticalLine = null;
        this.normalLine = null;
        this.sortedPoints = null;
    }

    public JunOpenGLDisplayModel show() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(this.sourcePoints());
        junOpenGL3dPolyline.lineWidth_(1.0f);
        junOpenGL3dPolyline.paint_(Color.gray);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        JunOpenGL3dVertex junOpenGL3dVertex = new JunOpenGL3dVertex(this.averagePoint());
        junOpenGL3dVertex.size_(5.0f);
        junOpenGL3dVertex.paint_(Color.gray);
        junOpenGL3dCompoundObject.add_(junOpenGL3dVertex);
        junOpenGL3dPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[]{this.positivePoint(), this.negativePoint()});
        junOpenGL3dPolyline.lineWidth_(3.0f);
        junOpenGL3dPolyline.paint_(Color.cyan);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        junOpenGL3dPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[]{this.horizontalLine().from(), this.horizontalLine().to()});
        junOpenGL3dPolyline.paint_(Color.red);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        junOpenGL3dPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[]{this.verticalLine().from(), this.verticalLine().to()});
        junOpenGL3dPolyline.paint_(Color.green);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        junOpenGL3dPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[]{this.normalLine().from(), this.normalLine().to()});
        junOpenGL3dPolyline.paint_(Color.blue);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        junOpenGL3dPolyline = new JunOpenGL3dPolyline(this.sortedPoints());
        junOpenGL3dPolyline.lineWidth_(3.0f);
        junOpenGL3dPolyline.paint_(Color.black);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        Jun3dPoint[] jun3dPointArray = this.sortedPoints();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            junOpenGL3dVertex = new JunOpenGL3dVertex(jun3dPointArray[i]);
            junOpenGL3dVertex.size_(5.0f);
            junOpenGL3dVertex.paint_(Color.getHSBColor((float)i / (float)jun3dPointArray.length * 2.0f / 3.0f, 1.0f, 1.0f));
            junOpenGL3dCompoundObject.add_(junOpenGL3dVertex);
        }
        JunOpenGL3dObject junOpenGL3dObject = this.asCircle().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.15f);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel(junOpenGL3dCompoundObject);
        junOpenGLDisplayModel.displayLightsAllOff();
        junOpenGLDisplayModel.defaultEyePoint_(this.zLine().atT_(100.0));
        junOpenGLDisplayModel.defaultSightPoint_(this.averagePoint());
        junOpenGLDisplayModel.defaultUpVector_(this.yLine().atT_(1.0).minus_(this.averagePoint()));
        junOpenGLDisplayModel.defaultZoomHeight_(this.diameterValue() * 1.2);
        junOpenGLDisplayModel.open();
        return junOpenGLDisplayModel;
    }

    protected double accuracy() {
        return ACCURACY;
    }

    protected Jun3dPoint[] computeSortedPoints() {
        Jun3dPoint[] jun3dPointArray = this.sourcePoints();
        if (jun3dPointArray.length <= 3) {
            return jun3dPointArray;
        }
        Jun3dPoint jun3dPoint = this.positivePoint();
        JunPlane junPlane = new JunPlane(jun3dPoint, this.negativePoint(), this.normalLine().to());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            if (jun3dPointArray[i].whichSideOf_(junPlane) > 0 || jun3dPointArray[i].equal_((Object)jun3dPoint)) {
                arrayList.add(jun3dPointArray[i]);
                continue;
            }
            arrayList2.add(jun3dPointArray[i]);
        }
        arrayList = this.computeNearOrder_fromPoint_(arrayList, jun3dPoint);
        arrayList2 = this.computeFarOrder_fromPoint_(arrayList2, jun3dPoint);
        ArrayList arrayList3 = new ArrayList();
        arrayList3.addAll(arrayList);
        arrayList3.addAll(arrayList2);
        return arrayList3.toArray(new Jun3dPoint[arrayList3.size()]);
    }

    protected ArrayList computeNearOrder_fromPoint_(ArrayList arrayList, Jun3dPoint jun3dPoint) {
        Jun3dLine jun3dLine = this.positivePoint().to_(this.negativePoint());
        TreeMap<Double, Jun3dPoint> treeMap = new TreeMap<Double, Jun3dPoint>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)arrayList.get(i));
            Jun3dPoint jun3dPoint3 = jun3dLine.nearestPointFromPoint_(jun3dPoint2);
            double d = jun3dPoint.distance_(jun3dPoint3);
            treeMap.put(new Double(d), jun3dPoint2);
        }
        return new ArrayList(treeMap.values());
    }

    protected ArrayList computeFarOrder_fromPoint_(ArrayList arrayList, Jun3dPoint jun3dPoint) {
        arrayList = this.computeNearOrder_fromPoint_(arrayList, jun3dPoint);
        Collections.reverse(arrayList);
        return arrayList;
    }
}

