/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.solid;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import jp.co.sra.jun.geometry.abstracts.JunSolid;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.geometry.solid.JunSphere;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

public class JunTetrahedron
extends JunSolid {
    protected Jun3dPoint p1;
    protected Jun3dPoint p2;
    protected Jun3dPoint p3;
    protected Jun3dPoint p4;

    protected JunTetrahedron() {
    }

    public JunTetrahedron(JunPoint junPoint, JunPoint junPoint2, JunPoint junPoint3, JunPoint junPoint4) {
        this.setP1_(junPoint);
        this.setP2_(junPoint2);
        this.setP3_(junPoint3);
        this.setP4_(junPoint4);
    }

    public double area() {
        double d = 0.0;
        Jun3dTriangle[] jun3dTriangleArray = this.triangles();
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            d += jun3dTriangleArray[i].area();
        }
        return d;
    }

    public double areaWithSign() {
        double d = 0.0;
        Jun3dTriangle[] jun3dTriangleArray = this.triangles();
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            d += jun3dTriangleArray[i].areaWithSign();
        }
        return d;
    }

    public Jun3dPoint p1() {
        return this.p1;
    }

    public Jun3dPoint p2() {
        return this.p2;
    }

    public Jun3dPoint p3() {
        return this.p3;
    }

    public Jun3dPoint p4() {
        return this.p4;
    }

    public Jun3dTriangle[] triangles() {
        return new Jun3dTriangle[]{this.p1.triangle_and_(this.p2, this.p3), this.p1.triangle_and_(this.p3, this.p4), this.p1.triangle_and_(this.p4, this.p2), this.p2.triangle_and_(this.p4, this.p3)};
    }

    public double volume() {
        return Math.abs(this.volumeWithSign());
    }

    public double volumeWithSign() {
        double d = this.p2().x() - this.p1().x();
        double d2 = this.p2().y() - this.p1().y();
        double d3 = this.p2().z() - this.p1().z();
        double d4 = this.p3().x() - this.p1().x();
        double d5 = this.p3().y() - this.p1().y();
        double d6 = this.p3().z() - this.p1().z();
        double d7 = this.p4().x() - this.p1().x();
        double d8 = this.p4().y() - this.p1().y();
        double d9 = this.p4().z() - this.p1().z();
        double d10 = d5 * d9 - d6 * d8;
        double d11 = d2 * d9 - d3 * d8;
        double d12 = d2 * d6 - d3 * d5;
        double d13 = (d * d10 - d4 * d11 + d7 * d12) / 6.0;
        return d13;
    }

    public boolean equal_(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        JunTetrahedron junTetrahedron = (JunTetrahedron)((Object)object);
        return this.p1().equal_((Object)junTetrahedron.p1()) && this.p2().equal_((Object)junTetrahedron.p2()) && this.p3().equal_((Object)junTetrahedron.p3()) && this.p4().equal_((Object)junTetrahedron.p4());
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        JunTetrahedron junTetrahedron = (JunTetrahedron)((Object)object);
        return this.p1().equals((Object)junTetrahedron.p1()) && this.p2().equals((Object)junTetrahedron.p2()) && this.p3().equals((Object)junTetrahedron.p3()) && this.p4().equals((Object)junTetrahedron.p4());
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun3dTriangle[] jun3dTriangleArray = this.triangles();
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            junOpenGL3dCompoundObject.add_(jun3dTriangleArray[i].asJunOpenGL3dObject());
        }
        return junOpenGL3dCompoundObject;
    }

    public Jun3dPoint barycenter() {
        return this.centerOfGravity();
    }

    public Jun3dPoint centerOfCircumcircle() {
        return this.circumsphere().center();
    }

    public Jun3dPoint centerOfGravity() {
        return new Jun3dPoint((this.p1().x() + this.p2().x() + this.p3().x() + this.p4().x()) / 4.0, (this.p1().y() + this.p2().y() + this.p3().y() + this.p4().y()) / 4.0, (this.p1().z() + this.p2().z() + this.p3().z() + this.p4().z()) / 4.0);
    }

    public Jun3dBoundingBall circumball() {
        JunSphere junSphere = this.circumsphere();
        return new Jun3dBoundingBall(junSphere.center(), junSphere.radius());
    }

    public Jun3dPoint circumcenter() {
        return this.centerOfCircumcircle();
    }

    public JunSphere circumsphere() {
        JunPlane junPlane = this.p1().bisector_(this.p2());
        JunPlane junPlane2 = this.p2().bisector_(this.p3());
        JunPlane junPlane3 = this.p3().bisector_(this.p4());
        Jun3dPoint jun3dPoint = junPlane.intersectingPointWithPlane_wihtPlane_(junPlane2, junPlane3);
        double d = jun3dPoint.distance_(this.p1);
        return new JunSphere(jun3dPoint, d);
    }

    public Jun3dPoint[] normalUnitVectors() {
        Jun3dTriangle[] jun3dTriangleArray = this.triangles();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun3dTriangleArray.length];
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            jun3dPointArray[i] = jun3dTriangleArray[i].normalUnitVector();
        }
        return jun3dPointArray;
    }

    public Jun3dPoint[] normalVectors() {
        Jun3dTriangle[] jun3dTriangleArray = this.triangles();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun3dTriangleArray.length];
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            jun3dPointArray[i] = jun3dTriangleArray[i].normalVector();
        }
        return jun3dPointArray;
    }

    public double radiusOfCircumcircle() {
        return this.circumsphere().radius();
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(40);
        this.p1().printOn_(writer);
        writer.write(" tetrahedron: ");
        this.p2().printOn_(writer);
        writer.write(" and: ");
        this.p3().printOn_(writer);
        writer.write(" and: ");
        this.p4().printOn_(writer);
        writer.write(41);
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" on: ");
        this.p1().printOn_(writer);
        writer.write(" on: ");
        this.p2().printOn_(writer);
        writer.write(" on: ");
        this.p3().printOn_(writer);
        writer.write(" on: ");
        this.p4().printOn_(writer);
        writer.write(41);
    }

    public boolean isTetrahedron() {
        return true;
    }

    public int whichSideOf_(JunPlane junPlane) {
        boolean bl;
        boolean bl2;
        int n;
        Jun3dTriangle[] jun3dTriangleArray = this.triangles();
        int[] nArray = new int[jun3dTriangleArray.length];
        for (n = 0; n < jun3dTriangleArray.length; ++n) {
            nArray[n] = jun3dTriangleArray[n].whichSideOf_(junPlane);
        }
        n = Arrays.binarySearch(nArray, 1) != -1 ? 1 : 0;
        boolean bl3 = bl2 = Arrays.binarySearch(nArray, -1) != -1;
        if (n != 0 && bl2) {
            return 0;
        }
        boolean bl4 = bl = Arrays.binarySearch(nArray, 0) != -1;
        if (bl) {
            return 0;
        }
        if (bl2 && n == 0) {
            return -1;
        }
        return 1;
    }

    protected void setP1_(JunPoint junPoint) {
        this.p1 = Jun3dPoint.Coerce_(junPoint);
    }

    protected void setP2_(JunPoint junPoint) {
        this.p2 = Jun3dPoint.Coerce_(junPoint);
    }

    protected void setP3_(JunPoint junPoint) {
        this.p3 = Jun3dPoint.Coerce_(junPoint);
    }

    protected void setP4_(JunPoint junPoint) {
        this.p4 = Jun3dPoint.Coerce_(junPoint);
    }
}

