/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.pluralities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingObject;
import jp.co.sra.jun.geometry.pluralities.JunBoundingBoxes;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

public class Jun2dBoundingBoxes
extends JunBoundingBoxes {
    public static Jun2dBoundingBoxes FromPolyline_(Jun2dPoint[] jun2dPointArray) {
        return Jun2dBoundingBoxes.FromPolyline_bitSize_(jun2dPointArray, new Dimension(16, 16));
    }

    public static Jun2dBoundingBoxes FromPolyline_(Point[] pointArray) {
        return Jun2dBoundingBoxes.FromPolyline_bitSize_(pointArray, new Dimension(16, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Jun2dBoundingBoxes FromPolyline_bitSize_(Jun2dPoint[] jun2dPointArray, Dimension dimension) {
        Polygon polygon;
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        if (jun2dPointArray == null || jun2dPointArray.length == 0) {
            return jun2dBoundingBoxes;
        }
        Point[] pointArray = new Point[jun2dPointArray.length];
        int[] nArray = new int[jun2dPointArray.length];
        int[] nArray2 = new int[jun2dPointArray.length];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            pointArray[i] = jun2dPointArray[i]._toPoint();
            nArray[i] = pointArray[i].x;
            nArray2[i] = pointArray[i].y;
        }
        Dimension dimension2 = new Dimension(Math.max(dimension.width, 0), Math.max(dimension.height, 0));
        if (dimension2.width * dimension2.height <= 0) {
            return jun2dBoundingBoxes;
        }
        Rectangle rectangle = new Rectangle(pointArray[0].x, pointArray[0].y, 1, 1);
        for (int i = 1; i < pointArray.length; ++i) {
            rectangle.add(new Rectangle(pointArray[i].x, pointArray[i].y, 1, 1));
        }
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Dimension dimension3 = new Dimension((int)Math.floor(Math.round((double)rectangle.width / (double)dimension2.width)), (int)Math.floor(Math.round((double)rectangle.height / (double)dimension2.height)));
        dimension3 = new Dimension(Math.max(dimension3.width, 0), Math.max(dimension3.height, 0));
        if (dimension3.width * dimension3.height <= 0) {
            return jun2dBoundingBoxes;
        }
        StImage stImage = new StImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = (Graphics2D)stImage.image().getGraphics();
        try {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, dimension3.width, dimension3.height);
            graphics2D.setColor(Color.black);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            polygon = new Polygon(nArray, nArray2, nArray.length);
            graphics2D.fill(polygon);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
        polygon = JunImageAdjuster.Adjust_extent_(stImage, dimension3);
        polygon = polygon.convertToPalette_(JunImageProcessor._WhiteBlackPalette());
        jun2dBoundingBoxes.add_(new Jun2dBoundingBox(StRectangle.Origin_corner_((Point)point, (Point)point2).toRectangle()));
        for (int i = 0; i < polygon.height(); ++i) {
            for (int j = 0; j < polygon.width(); ++j) {
                if (polygon.getPixel(j, i) != Color.black.getRGB()) continue;
                jun2dBoundingBoxes.add_(Jun2dBoundingBox.Origin_extent_(new Jun2dPoint(point.x + j * dimension2.width, point.y + i * dimension2.height), new Jun2dPoint(dimension2.width, dimension2.height)));
            }
        }
        final Jun2dBoundingBoxes jun2dBoundingBoxes2 = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes2.add_(Jun2dBoundingBox.Origin_extent_(new Jun2dPoint(rectangle.getLocation()), new Jun2dPoint(rectangle.width, rectangle.height)));
        jun2dBoundingBoxes.differenceBoxes().do_(new StBlockClosure(){

            public Object value_(Object object) {
                jun2dBoundingBoxes2.add_((Jun2dBoundingBox)((Object)object));
                return null;
            }
        });
        return jun2dBoundingBoxes2.differenceBoxes();
    }

    public static Jun2dBoundingBoxes FromPolyline_bitSize_(Point[] pointArray, Dimension dimension) {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            jun2dPointArray[i] = new Jun2dPoint(pointArray[i].x, pointArray[i].y);
        }
        return Jun2dBoundingBoxes.FromPolyline_bitSize_(jun2dPointArray, dimension);
    }

    public double area() {
        double d = 0.0;
        JunBoundingObject[] junBoundingObjectArray = this.boundingObjects();
        for (int i = 0; i < junBoundingObjectArray.length; ++i) {
            JunBoundingBox junBoundingBox = (JunBoundingBox)junBoundingObjectArray[i];
            d += junBoundingBox.area();
        }
        return d;
    }

    public Jun2dBoundingBall boundingBall() {
        if (this.isEmpty()) {
            return new Jun2dBoundingBall(null);
        }
        Jun2dBoundingBall jun2dBoundingBall = null;
        JunBoundingObject[] junBoundingObjectArray = this.boundingObjects();
        for (int i = 0; i < junBoundingObjectArray.length; ++i) {
            Jun2dBoundingBox jun2dBoundingBox = (Jun2dBoundingBox)junBoundingObjectArray[i];
            jun2dBoundingBall = jun2dBoundingBall == null ? jun2dBoundingBox.boundingBall() : jun2dBoundingBox.boundingBall().merge_(jun2dBoundingBall);
        }
        return jun2dBoundingBall;
    }

    public Jun2dBoundingBox boundingBox() {
        if (this.isEmpty()) {
            return new Jun2dBoundingBox();
        }
        Jun2dBoundingBox jun2dBoundingBox = null;
        JunBoundingObject[] junBoundingObjectArray = this.boundingObjects();
        for (int i = 0; i < junBoundingObjectArray.length; ++i) {
            Jun2dBoundingBox jun2dBoundingBox2 = (Jun2dBoundingBox)junBoundingObjectArray[i];
            jun2dBoundingBox = jun2dBoundingBox == null ? jun2dBoundingBox2 : jun2dBoundingBox2.merge_(jun2dBoundingBox);
        }
        return jun2dBoundingBox;
    }

    public Jun2dBoundingBox[] boundingBoxes() {
        return this._boundingObjects().toArray(new Jun2dBoundingBox[this._boundingObjects().size()]);
    }

    public Jun2dBoundingBall asBoundingBall() {
        return this.boundingBall();
    }

    public Jun2dBoundingBox asBoundingBox() {
        return this.boundingBox();
    }

    public Rectangle asRectangle() {
        return this.asBoundingBox().asRectangle();
    }

    public Rectangle[] asRectangles() {
        final ArrayList arrayList = new ArrayList();
        this.do_(new StBlockClosure(){

            public Object value_(Object object) {
                JunBoundingBox junBoundingBox = (JunBoundingBox)((Object)object);
                arrayList.add(junBoundingBox.asRectangle());
                return null;
            }
        });
        return arrayList.toArray(new Rectangle[arrayList.size()]);
    }

    public Jun2dBoundingBoxes complementBoxes() {
        Jun2dBoundingBoxes jun2dBoundingBoxes = this.unionBoxes();
        Jun2dBoundingBox jun2dBoundingBox = this.intersectionBox();
        if (jun2dBoundingBox == null) {
            return jun2dBoundingBoxes;
        }
        Jun2dBoundingBox[] jun2dBoundingBoxArray = jun2dBoundingBoxes.boundingBoxes();
        for (int i = 0; i < jun2dBoundingBoxArray.length; ++i) {
            if (!jun2dBoundingBoxArray[i].equals((Object)jun2dBoundingBox)) continue;
            jun2dBoundingBoxes._boundingObjects().remove((Object)jun2dBoundingBoxArray[i]);
        }
        jun2dBoundingBoxes = (Jun2dBoundingBoxes)jun2dBoundingBoxes.reject_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(((Jun2dBoundingBox)((Object)object)).isEmpty());
            }
        });
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes differenceBoxes() {
        if (this.isEmpty()) {
            return (Jun2dBoundingBoxes)this.copy();
        }
        Jun2dBoundingBox[] jun2dBoundingBoxArray = this.boundingBoxes();
        Jun2dBoundingBox jun2dBoundingBox = jun2dBoundingBoxArray[0];
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes.add_(jun2dBoundingBox);
        for (int i = 1; i < jun2dBoundingBoxArray.length; ++i) {
            Jun2dBoundingBox jun2dBoundingBox2 = jun2dBoundingBoxArray[i];
            Jun2dBoundingBoxes jun2dBoundingBoxes2 = new Jun2dBoundingBoxes();
            JunBoundingObject[] junBoundingObjectArray = jun2dBoundingBoxes.boundingObjects();
            for (int j = 0; j < junBoundingObjectArray.length; ++j) {
                Jun2dBoundingBox jun2dBoundingBox3 = (Jun2dBoundingBox)junBoundingObjectArray[j];
                if (jun2dBoundingBox3.intersects_(jun2dBoundingBox)) {
                    jun2dBoundingBoxes2.addAll_(jun2dBoundingBox3.boxesOutside_(jun2dBoundingBox2));
                    continue;
                }
                jun2dBoundingBoxes2.add_(jun2dBoundingBox3);
            }
            jun2dBoundingBoxes = jun2dBoundingBoxes2;
        }
        jun2dBoundingBoxes = (Jun2dBoundingBoxes)jun2dBoundingBoxes.reject_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(((Jun2dBoundingBox)((Object)object)).isEmpty());
            }
        });
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBox intersectionBox() {
        if (this.isEmpty()) {
            return null;
        }
        JunBoundingObject junBoundingObject = null;
        JunBoundingObject[] junBoundingObjectArray = this.boundingObjects();
        for (int i = 0; i < junBoundingObjectArray.length; ++i) {
            Jun2dBoundingBox jun2dBoundingBox = (Jun2dBoundingBox)junBoundingObjectArray[i];
            if (junBoundingObject == null) {
                junBoundingObject = jun2dBoundingBox;
                continue;
            }
            if (!((Jun2dBoundingBox)junBoundingObject).intersects_(jun2dBoundingBox)) continue;
            junBoundingObject = ((Jun2dBoundingBox)junBoundingObject).intersect_(jun2dBoundingBox);
        }
        if (junBoundingObject.isEmpty()) {
            return null;
        }
        return junBoundingObject;
    }

    public Jun2dBoundingBoxes intersectionBoxes() {
        Jun2dBoundingBox jun2dBoundingBox = this.intersectionBox();
        if (jun2dBoundingBox == null) {
            return new Jun2dBoundingBoxes();
        }
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes.add_(jun2dBoundingBox);
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes subdivide2Level_(int n) {
        Jun2dBoundingBoxes jun2dBoundingBoxes = this;
        for (int i = 0; i < n; ++i) {
            jun2dBoundingBoxes = jun2dBoundingBoxes.subdivide2();
        }
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBox unify() {
        return this.asBoundingBox();
    }

    public Jun2dBoundingBoxes unionBoxes() {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        Jun2dBoundingBox jun2dBoundingBox = this.intersectionBox();
        if (jun2dBoundingBox != null) {
            int n;
            Jun2dBoundingBox[] jun2dBoundingBoxArray = this.boundingBoxes();
            Jun2dBoundingBox[] jun2dBoundingBoxArray2 = new Jun2dBoundingBox[jun2dBoundingBoxArray.length + 1];
            for (n = 0; n < jun2dBoundingBoxArray.length; ++n) {
                jun2dBoundingBoxArray2[n] = jun2dBoundingBoxArray[n];
            }
            jun2dBoundingBoxArray2[jun2dBoundingBoxArray2.length - 1] = jun2dBoundingBox;
            for (n = 0; n < jun2dBoundingBoxArray2.length; ++n) {
                Jun2dBoundingBox jun2dBoundingBox2 = jun2dBoundingBoxArray2[n];
                Jun2dBoundingBoxes jun2dBoundingBoxes2 = new Jun2dBoundingBoxes();
                jun2dBoundingBoxes2.add_(jun2dBoundingBox2);
                Jun2dBoundingBox[] jun2dBoundingBoxArray3 = jun2dBoundingBoxes.boundingBoxes();
                for (int i = 0; i < jun2dBoundingBoxArray3.length; ++i) {
                    Jun2dBoundingBox jun2dBoundingBox3 = jun2dBoundingBoxArray3[i];
                    if (jun2dBoundingBox3.intersects_(jun2dBoundingBox2)) {
                        jun2dBoundingBoxes2.addAll_(jun2dBoundingBox3.boxesOutside_(jun2dBoundingBox2));
                        continue;
                    }
                    jun2dBoundingBoxes2.add_(jun2dBoundingBox3);
                }
                jun2dBoundingBoxes = jun2dBoundingBoxes2;
            }
        }
        jun2dBoundingBoxes = (Jun2dBoundingBoxes)jun2dBoundingBoxes.reject_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(((Jun2dBoundingBox)((Object)object)).isEmpty());
            }
        });
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes subdivide() {
        return this.subdivide4();
    }

    public Jun2dBoundingBoxes subdivide2() {
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>(this.size() * 2);
        for (int i = 0; i < this.size(); ++i) {
            Jun2dBoundingBox[] jun2dBoundingBoxArray = this.boundingBox().subdivide2().boundingBoxes();
            arrayList.add(jun2dBoundingBoxArray[0]);
            arrayList.add(jun2dBoundingBoxArray[1]);
        }
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes subdivide4() {
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>(this.size() * 4);
        for (int i = 0; i < this.size(); ++i) {
            Jun2dBoundingBox[] jun2dBoundingBoxArray = this.boundingBox().subdivide4().boundingBoxes();
            arrayList.add(jun2dBoundingBoxArray[0]);
            arrayList.add(jun2dBoundingBoxArray[1]);
            arrayList.add(jun2dBoundingBoxArray[2]);
            arrayList.add(jun2dBoundingBoxArray[3]);
        }
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        return jun2dBoundingBoxes;
    }

    public Jun2dBoundingBoxes subdivideLevel_(int n) {
        Jun2dBoundingBoxes jun2dBoundingBoxes = this;
        for (int i = 0; i < n; ++i) {
            jun2dBoundingBoxes = jun2dBoundingBoxes.subdivide();
        }
        return jun2dBoundingBoxes;
    }

    public boolean is2d() {
        return true;
    }

    public boolean touches_(final Jun2dBoundingBox jun2dBoundingBox) {
        return this.detect_ifNone_(new StBlockClosure(){

            public Object value(Object object) {
                return new Boolean(((Jun2dBoundingBox)((Object)object)).touches_(jun2dBoundingBox));
            }
        }, new StBlockClosure(){

            public Object value(Object object) {
                return null;
            }
        }) != null;
    }

    public Jun2dBoundingBoxes transform_(Jun2dTransformation jun2dTransformation) {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        JunBoundingObject[] junBoundingObjectArray = this.boundingObjects();
        for (int i = 0; i < junBoundingObjectArray.length; ++i) {
            this.add_(junBoundingObjectArray[i].transform_(jun2dTransformation));
        }
        return jun2dBoundingBoxes;
    }
}

