/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.forms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayProcessor;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.forms.JunAbstractFormTriangulation;
import jp.co.sra.jun.geometry.forms.JunForm2dRegion;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

public class JunFormTriangulation3
extends JunAbstractFormTriangulation {
    protected Jun2dTriangle[] universalDelaunayTriangles;

    public JunFormTriangulation3() {
    }

    public JunFormTriangulation3(Jun2dPoint[] jun2dPointArray) {
        super(jun2dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.universalDelaunayTriangles = null;
    }

    public void points_(Jun2dPoint[] jun2dPointArray) {
        super.points_(jun2dPointArray);
        this.universalDelaunayTriangles = null;
    }

    public Jun2dTriangle[] triangles() {
        return this.trianglesInterim_(null);
    }

    public Jun2dTriangle[] trianglesInterim_(StBlockClosure stBlockClosure) {
        if (this.pointsWithoutLast().length < 3) {
            return new Jun2dTriangle[0];
        }
        return this.universalDelaunayTrianglesInterim_(stBlockClosure);
    }

    protected Jun2dTriangle[] universalDelaunayTrianglesInterim_(StBlockClosure stBlockClosure) {
        if (this.universalDelaunayTriangles == null) {
            ArrayList<Jun2dTriangle> arrayList = null;
            if (stBlockClosure == null) {
                Jun2dDelaunayProcessor jun2dDelaunayProcessor = Jun2dDelaunayProcessor.FromPolygon_(this.pointsWithoutLast());
                JunPoint[][] junPointArray = jun2dDelaunayProcessor.insideTriangles();
                arrayList = new ArrayList<Jun2dTriangle>();
                for (int i = 0; i < junPointArray.length; ++i) {
                    Jun2dTriangle jun2dTriangle = new Jun2dTriangle(junPointArray[i][0].as2dPoint(), junPointArray[i][1].as2dPoint(), junPointArray[i][2].as2dPoint());
                    arrayList.add(jun2dTriangle);
                }
            } else {
                stBlockClosure.value_((Object)new Jun2dTriangle[0]);
                Jun2dPoint[] jun2dPointArray = this.pointsWithoutLast();
                ArrayList<Jun2dPoint> arrayList2 = new ArrayList<Jun2dPoint>(jun2dPointArray.length);
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    arrayList2.add(jun2dPointArray[i]);
                    if (i < 2) continue;
                    Jun2dDelaunayProcessor jun2dDelaunayProcessor = Jun2dDelaunayProcessor.FromPolygon_(arrayList2.toArray(new Jun2dPoint[arrayList2.size()]));
                    JunPoint[][] junPointArray = jun2dDelaunayProcessor.insideTriangles();
                    arrayList = new ArrayList();
                    for (int j = 0; j < junPointArray.length; ++j) {
                        Jun2dTriangle jun2dTriangle = new Jun2dTriangle(junPointArray[j][0].as2dPoint(), junPointArray[j][1].as2dPoint(), junPointArray[j][2].as2dPoint());
                        arrayList.add(jun2dTriangle);
                    }
                    stBlockClosure.value_((Object)arrayList.toArray(new Jun2dTriangle[arrayList.size()]));
                }
            }
            this.universalDelaunayTriangles = arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
        }
        return this.universalDelaunayTriangles;
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.displayOn_at_triangles_color_(graphics, point, this.triangles(), Color.red);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_triangles_color_(Graphics graphics, Point point, Jun2dTriangle[] jun2dTriangleArray, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Rectangle rectangle = this.boundingBox().asRectangle();
            Point point2 = new Point(0 - rectangle.x + point.x, 0 - rectangle.y + point.y);
            graphics2D.translate(point2.x, point2.y);
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            for (int i = 0; i < jun2dTriangleArray.length; ++i) {
                Object object;
                JunForm2dRegion junForm2dRegion;
                if (jun2dTriangleArray[i].first().equals((Object)jun2dTriangleArray[i].last())) {
                    junForm2dRegion = new JunForm2dRegion(jun2dTriangleArray[i].asPointArray());
                } else {
                    object = jun2dTriangleArray[i].asPointArray();
                    Jun2dPoint[] jun2dPointArray = new Jun2dPoint[((Jun2dPoint[])object).length + 1];
                    for (int j = 0; j < ((Jun2dPoint[])object).length; ++j) {
                        jun2dPointArray[j] = object[j];
                    }
                    jun2dPointArray[jun2dPointArray.length - 1] = object[0];
                    junForm2dRegion = new JunForm2dRegion(jun2dPointArray);
                }
                object = junForm2dRegion.toGeneralPath();
                graphics2D.setColor(StColorValue.Blend((Color)color, (Color)Color.white));
                graphics2D.fill((Shape)object);
                graphics2D.setColor(color);
                graphics2D.draw((Shape)object);
            }
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.toGeneralPath());
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void displayOn_triangles_(Graphics graphics, Jun2dTriangle[] jun2dTriangleArray) {
        this.displayOn_at_triangles_color_(graphics, new Point(0, 0), jun2dTriangleArray, Color.red);
    }
}

