/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.curves;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dPolyline;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.JunLine;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.smalltalk.SmalltalkException;

public class Jun2dLine
extends JunLine {
    protected double x0;
    protected double y0;
    protected double f;
    protected double g;

    protected Jun2dLine() {
    }

    public Jun2dLine(JunPoint junPoint, JunPoint junPoint2) {
        this.from_to_(junPoint, junPoint2);
    }

    public static final Jun2dLine Between_and_(JunPoint junPoint, JunPoint junPoint2) {
        Jun2dLine jun2dLine = new Jun2dLine();
        Jun2dLine.Between_and_(junPoint, junPoint2);
        return jun2dLine;
    }

    public static final Jun2dLine Unity() {
        Jun2dLine jun2dLine = new Jun2dLine(Jun2dPoint.Zero(), Jun2dPoint.Unity());
        return jun2dLine.normalizedLine();
    }

    public static final Jun2dLine Zero() {
        throw SmalltalkException.ShouldNotImplement();
    }

    protected JunPoint _from() {
        return this.from();
    }

    protected JunPoint _to() {
        return this.to();
    }

    public JunAngle angleWithLine_(Jun2dLine jun2dLine) {
        double d = (Math.pow(this.f(), 2.0) + Math.pow(this.g(), 2.0)) * (Math.pow(jun2dLine.f(), 2.0) + Math.pow(jun2dLine.g(), 2.0));
        if ((d = Math.sqrt(d)) < Jun2dPoint.Accuracy()) {
            SmalltalkException.Error((String)"unexpected line parameters");
        }
        double d2 = this.f() * jun2dLine.f() + this.g() * jun2dLine.g();
        double d3 = Math.min(Math.max(d2 / d, -1.0), 1.0);
        return JunAngle.FromRad_(Math.acos(d3));
    }

    public JunAngle angleWithLine_(Jun3dLine jun3dLine) {
        Jun2dLine jun2dLine = new Jun2dLine(new Jun2dPoint(jun3dLine.first().x(), jun3dLine.first().y()), new Jun2dPoint(jun3dLine.last().x(), jun3dLine.last().y()));
        return this.angleWithLine_(jun2dLine);
    }

    public Jun2dPoint atT_(double d) {
        return new Jun2dPoint(this.x0 + this.f * d, this.y0 + this.g * d);
    }

    public Jun2dPoint atX_(double d) {
        Jun2dLine jun2dLine = new Jun2dPoint(d, 0.0).to_(new Jun2dPoint(d, 1.0));
        return jun2dLine.intersectingPointWithLine_(this);
    }

    public Jun2dPoint atY_(double d) {
        Jun2dLine jun2dLine = new Jun2dPoint(0.0, d).to_(new Jun2dPoint(1.0, d));
        return jun2dLine.intersectingPointWithLine_(this);
    }

    public void between_and_(JunPoint junPoint, JunPoint junPoint2) {
        Jun2dPoint jun2dPoint;
        Jun2dPoint jun2dPoint2 = Jun2dPoint.Coerce_(junPoint);
        if (jun2dPoint2.equals((Object)(jun2dPoint = Jun2dPoint.Coerce_(junPoint2)))) {
            throw new IllegalArgumentException("'can not define a line");
        }
        double d = jun2dPoint.x() - jun2dPoint2.x();
        double d2 = jun2dPoint.y() - jun2dPoint2.y();
        double d3 = Math.sqrt(d) + Math.sqrt(d2);
        if (d3 < this.Accuracy()) {
            throw new IllegalArgumentException("'can not define a line");
        }
        d3 = Math.sqrt(d3);
        this.setX0_((jun2dPoint2.x() + jun2dPoint.x()) / 2.0);
        this.setY0_((jun2dPoint2.y() + jun2dPoint.y()) / 2.0);
        this.setF_((0.0 - d2) / d3);
        this.setG_(d / d3);
    }

    public Jun2dBoundingBall boundingBall() {
        return this.asBoundingBall();
    }

    public Jun2dBoundingBox boundingBox() {
        return this.asBoundingBox();
    }

    public Jun2dPoint center() {
        return this.atT_(0.5);
    }

    public Jun2dPoint first() {
        return this.from();
    }

    public Jun2dPoint from() {
        return this.atT_(0.0);
    }

    public void from_to_(JunPoint junPoint, JunPoint junPoint2) {
        Jun2dPoint jun2dPoint = Jun2dPoint.Coerce_(junPoint);
        Jun2dPoint jun2dPoint2 = Jun2dPoint.Coerce_(junPoint2);
        this.x0 = jun2dPoint.x();
        this.y0 = jun2dPoint.y();
        this.f = jun2dPoint2.x() - jun2dPoint.x();
        this.g = jun2dPoint2.y() - jun2dPoint.y();
    }

    public Jun2dPoint last() {
        return this.to();
    }

    public double length() {
        return this.first().distance_(this.last());
    }

    public Jun2dPoint normalUnitVector() {
        return this.normalizedLine().normalVector();
    }

    public Jun2dPoint normalVector() {
        return this.to().minus_(this.from());
    }

    public double tAtPoint_(Jun2dPoint jun2dPoint) {
        double d = this.f * this.f + this.g * this.g;
        if (d < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d2 = jun2dPoint.x() - this.x0;
        double d3 = jun2dPoint.y() - this.y0;
        return (this.f * d2 + this.g * d3) / d;
    }

    public double tAtX_(double d) {
        if (Math.abs(this.f()) < this.Accuracy()) {
            return Double.NaN;
        }
        return (d - this.x0()) / this.f();
    }

    public double tAtY_(double d) {
        if (Math.abs(this.g()) < this.Accuracy()) {
            return Double.NaN;
        }
        return (d - this.y0()) / this.g();
    }

    public Jun2dPoint to() {
        return this.atT_(1.0);
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dLine jun2dLine = (Jun2dLine)((Object)object);
        return this.isEqualNumber_to_(this.x0, jun2dLine.x0) && this.isEqualNumber_to_(this.y0, jun2dLine.y0) && this.isEqualNumber_to_(this.f, jun2dLine.f) && this.isEqualNumber_to_(this.g, jun2dLine.g);
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dLine jun2dLine = (Jun2dLine)((Object)object);
        return this.x0 == jun2dLine.x0 && this.y0 == jun2dLine.y0 && this.f == jun2dLine.f && this.g == jun2dLine.g;
    }

    public Jun2dPoint[][] asArrays() {
        return new Jun2dPoint[][]{{this.from(), this.to()}};
    }

    public Jun2dLine[] asArrayOfLines() {
        return this.asArrayOf2dLines();
    }

    public Jun2dLine[] asArrayOf2dLines() {
        return new Jun2dLine[]{this};
    }

    public Jun2dBoundingBall asBoundingBall() {
        Jun2dPoint jun2dPoint = this.center();
        double d = jun2dPoint.distance_(this.to());
        return new Jun2dBoundingBall(jun2dPoint, d);
    }

    public Jun2dBoundingBox asBoundingBox() {
        return Jun2dBoundingBox.Vertex_vertex_(this.from(), this.to());
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(this.from().x(), this.from().y(), 0.0), new Jun3dPoint(this.to().x(), this.to().y(), 0.0)};
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
        junOpenGL3dPolyline.lineWidth_(1.0f);
        junOpenGL3dPolyline.paint_(this.defaultColor());
        return junOpenGL3dPolyline;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectWithPoints() {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(this.from().x(), this.from().y(), 0.0), new Jun3dPoint(this.to().x(), this.to().y(), 0.0)};
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        JunOpenGL3dObject junOpenGL3dObject = this.from().asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.red);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        JunOpenGL3dObject junOpenGL3dObject2 = this.to().asJunOpenGL3dObject();
        junOpenGL3dObject2.paint_(Color.blue);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject2);
        return junOpenGL3dCompoundObject;
    }

    public JunNurbsCurve asNurbsCurve() {
        return JunNurbsCurve.BezierControlPoints_(new Jun3dPoint[]{this.from().as3dPoint(), this.center().as3dPoint(), this.to().as3dPoint()});
    }

    public Point[][] asPointArrays() {
        Jun2dPoint[][] jun2dPointArray = this.asArrays();
        Point[][] pointArray = new Point[jun2dPointArray.length][];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            pointArray[i] = new Point[jun2dPointArray[i].length];
            for (int j = 0; j < jun2dPointArray[i].length; ++j) {
                pointArray[i][j] = jun2dPointArray[i][j].asPoint();
            }
        }
        return pointArray;
    }

    public Jun2dPolyline asPolyline() {
        return new Jun2dPolyline(new Jun2dPoint[]{this.from(), this.to()});
    }

    public Jun2dLine reversed() {
        return new Jun2dLine(this.to(), this.from());
    }

    public JunAngle angleWithLine_(JunLine junLine) {
        Jun2dLine jun2dLine = junLine instanceof Jun2dLine ? (Jun2dLine)junLine : new Jun2dLine(junLine._from(), junLine._to());
        double d = (this.f() * this.f() + this.g() * this.g()) * (jun2dLine.f() * jun2dLine.f() + jun2dLine.g() * jun2dLine.g());
        if ((d = Math.sqrt(d)) < this.accuracy()) {
            throw new IllegalArgumentException("unexpected line parameters");
        }
        double d2 = this.f() * jun2dLine.f() + this.g() * jun2dLine.g();
        double d3 = Math.min(Math.max(d2 / d, -1.0), 1.0);
        return JunAngle.FromRad_(Math.acos(d3));
    }

    public double distanceFromPoint_(Jun2dPoint jun2dPoint) {
        Jun2dPoint jun2dPoint2 = this.nearestPointFromPoint_(jun2dPoint);
        return jun2dPoint.distance_(jun2dPoint2);
    }

    public Jun2dPoint intersectingPointWithLine_(Jun2dLine jun2dLine) {
        double d = this.intersectingTWithLine_(jun2dLine);
        if (Double.isNaN(d)) {
            return null;
        }
        return this.atT_(d);
    }

    public double intersectingTWithLine_(Jun2dLine jun2dLine) {
        double d = jun2dLine.f;
        double d2 = jun2dLine.g;
        double d3 = d * this.g - this.f * d2;
        if (Math.abs(d3) < 1.0E-12) {
            return Double.NaN;
        }
        return (d * (jun2dLine.y0 - this.y0) - d2 * (jun2dLine.x0 - this.x0)) / d3;
    }

    public boolean lineSegmentContainsPoint_(Jun2dPoint jun2dPoint) {
        if (!this.containsPoint_(jun2dPoint)) {
            return false;
        }
        double d = this.tAtPoint_(jun2dPoint);
        return -1.0E-12 <= d && d <= 1.000000000001;
    }

    public double lineSegmentDistanceFromPoint_(Jun2dPoint jun2dPoint) {
        Jun2dPoint jun2dPoint2 = this.lineSegmentNearestPointFromPoint_(jun2dPoint);
        return jun2dPoint.distance_(jun2dPoint2);
    }

    public Jun2dPoint lineSegmentIntersectingPointWithLineSegment_(Jun2dLine jun2dLine) {
        Jun2dPoint jun2dPoint = this.intersectingPointWithLine_(jun2dLine);
        if (jun2dPoint == null) {
            return null;
        }
        if (!this.lineSegmentContainsPoint_(jun2dPoint)) {
            return null;
        }
        if (!jun2dLine.lineSegmentContainsPoint_(jun2dPoint)) {
            return null;
        }
        return jun2dPoint;
    }

    public Jun2dPoint lineSegmentNearestPointFromPoint_(Jun2dPoint jun2dPoint) {
        double d;
        double d2 = this.f * this.f + this.g * this.g;
        if (d2 < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d3 = jun2dPoint.x() - this.x0;
        double d4 = (this.f * d3 + this.g * (d = jun2dPoint.y() - this.y0)) / d2;
        if (d4 < 0.0) {
            d4 = 0.0;
        } else if (d4 > 1.0) {
            d4 = 1.0;
        }
        return this.atT_(d4);
    }

    public Jun2dPoint nearestPointFromPoint_(Jun2dPoint jun2dPoint) {
        double d = this.f * this.f + this.g * this.g;
        if (d < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        double d2 = jun2dPoint.x() - this.x0;
        double d3 = jun2dPoint.y() - this.y0;
        return this.atT_((this.f * d2 + this.g * d3) / d);
    }

    public Jun2dLine normalized() {
        return this.normalizedLine();
    }

    public Jun2dLine normalizedLine() {
        Jun2dLine jun2dLine = (Jun2dLine)this.copy();
        double d = this.n();
        jun2dLine.f = this.f * d;
        jun2dLine.g = this.g * d;
        return jun2dLine;
    }

    public double valueF_(JunPoint junPoint) {
        Jun2dPoint jun2dPoint = Jun2dPoint.Coerce_(junPoint);
        return this.a() * jun2dPoint.x() + this.b() * jun2dPoint.y() + this.c();
    }

    public int whichSide_(Jun2dPoint jun2dPoint) {
        double d = this.valueF_(jun2dPoint);
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public double a() {
        return 0.0 - this.g();
    }

    public double b() {
        return this.f();
    }

    public double c() {
        return this.x0() * this.g() - this.y0() * this.f();
    }

    public double f() {
        return this.f;
    }

    public double g() {
        return this.g;
    }

    public double n() {
        double d = this.f * this.f + this.g * this.g;
        if (d < 1.0E-12) {
            throw SmalltalkException.Error((String)"can not define a line");
        }
        return 1.0 / Math.sqrt(d);
    }

    public double x0() {
        return this.x0;
    }

    public double y0() {
        return this.y0;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("2dLine (");
        this.from().printOn_(writer);
        writer.write(" , ");
        this.to().printOn_(writer);
        writer.write(")");
    }

    public Jun2dPolyline subdivide() {
        return new Jun2dPolyline(new Jun2dPoint[]{this.from(), this.center(), this.to()});
    }

    public Jun2dPolyline subdivideLevel_(int n) {
        Jun2dPolyline jun2dPolyline = this.asPolyline();
        for (int i = 0; i < n; ++i) {
            jun2dPolyline = jun2dPolyline.subdivide();
        }
        return jun2dPolyline;
    }

    public boolean containsPoint_(Jun2dPoint jun2dPoint) {
        return this.distanceFromPoint_(jun2dPoint) < 1.0E-12;
    }

    public boolean is2d() {
        return true;
    }

    public boolean isParallelWithLine_(Jun2dLine jun2dLine) {
        double d = this.angleWithLine_(jun2dLine).deg();
        return Math.abs(0.0 - d) < Jun2dPoint.Accuracy() || Math.abs(180.0 - d) < Jun2dPoint.Accuracy();
    }

    public Jun2dLine rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun2dTransformation.Rotate_(junAngle));
    }

    public Jun2dLine scaledBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Scale_(jun2dPoint));
    }

    public Jun2dLine transform_(Jun2dTransformation jun2dTransformation) {
        return new Jun2dLine(this.from().transform_(jun2dTransformation), this.to().transform_(jun2dTransformation));
    }

    public JunGeometry transform_(JunTransformation junTransformation) {
        return this.transform_((Jun2dTransformation)junTransformation);
    }

    public Jun2dLine translatedBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Translate_(jun2dPoint));
    }

    protected void setF_(double d) {
        this.f = d;
    }

    protected void setG_(double d) {
        this.g = d;
    }

    protected void setX0_(double d) {
        this.x0 = d;
    }

    protected void setY0_(double d) {
        this.y0 = d;
    }
}

