/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.coordinate;

import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.coordinate.JunCoordinateSystem;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.smalltalk.StObject;

public class Jun3dCoordinateSystem
extends JunCoordinateSystem {
    protected Jun3dPoint origin;
    protected Jun3dTransformation transformation;
    protected Jun3dTransformation invTransformation;
    protected Jun3dTransformation globalTransformation;
    protected Jun3dTransformation globalInvTransformation;
    protected Jun3dCoordinateSystem outerCoordinateSystem;
    protected ArrayList localCoordinateSystems;
    protected Jun3dPoint xUnitVector;
    protected Jun3dPoint yUnitVector;
    protected Jun3dPoint zUnitVector;

    public static Jun3dCoordinateSystem Scale_(double d) {
        return new Jun3dCoordinateSystem(Jun3dTransformation.Scale_(d));
    }

    public static Jun3dCoordinateSystem Scale_(Jun3dPoint jun3dPoint) {
        return new Jun3dCoordinateSystem(Jun3dTransformation.Scale_(jun3dPoint));
    }

    public static Jun3dCoordinateSystem Translate_(double d) {
        return new Jun3dCoordinateSystem(Jun3dTransformation.Translate_(d));
    }

    public static Jun3dCoordinateSystem Translate_(Jun3dPoint jun3dPoint) {
        return new Jun3dCoordinateSystem(Jun3dTransformation.Translate_(jun3dPoint));
    }

    public static Jun3dCoordinateSystem Transformation_(Jun3dTransformation jun3dTransformation) {
        return new Jun3dCoordinateSystem(jun3dTransformation);
    }

    public Jun3dCoordinateSystem(Jun3dTransformation jun3dTransformation) {
        this.transformation_(jun3dTransformation);
    }

    protected void initialize() {
        super.initialize();
        this.origin = null;
        this.transformation = null;
        this.invTransformation = null;
        this.globalTransformation = null;
        this.globalInvTransformation = null;
        this.outerCoordinateSystem = null;
        this.localCoordinateSystems = null;
        this.xUnitVector = null;
        this.yUnitVector = null;
        this.zUnitVector = null;
    }

    public Jun3dTransformation transformation() {
        if (this.transformation == null) {
            this.transformation = this.computeTransformation();
        }
        return this.transformation;
    }

    public JunTransformation _transformation() {
        return this.transformation();
    }

    public void transformation_(Jun3dTransformation jun3dTransformation) {
        if (this.transformation == null ? jun3dTransformation == null : this.transformation.equals((Object)jun3dTransformation)) {
            return;
        }
        this.transformation = jun3dTransformation;
        this.invTransformation = null;
        this.clearGlobalTransformation();
        this.clearOriginAndVectors();
    }

    public Jun3dTransformation invTransformation() {
        if (this.invTransformation == null) {
            this.invTransformation = this.transformation().inverse();
        }
        return this.invTransformation;
    }

    public void invTransformation_(Jun3dTransformation jun3dTransformation) {
        this.invTransformation = jun3dTransformation;
        this.transformation = jun3dTransformation.inverse();
        this.clearOriginAndVectors();
    }

    public Jun3dTransformation globalTransformation() {
        if (this.globalTransformation == null) {
            this.globalTransformation = this.transformation();
            if (this.outerCoordinateSystem != null) {
                this.globalTransformation = this.globalTransformation.product_(this.outerCoordinateSystem.globalTransformation());
            }
        }
        return this.globalTransformation;
    }

    public Jun3dTransformation globalInvTransformation() {
        if (this.globalInvTransformation == null) {
            this.globalInvTransformation = this.globalTransformation().inverse();
        }
        return this.globalInvTransformation;
    }

    public JunTransformation _globalInvTransformation() {
        return this.globalInvTransformation();
    }

    public Jun3dCoordinateSystem outerCoordinateSystem() {
        return this.outerCoordinateSystem;
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this == object;
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this == object;
    }

    public Jun3dCoordinateSystem asLocalCoordinateSystemOf_(Jun3dCoordinateSystem jun3dCoordinateSystem) {
        if (this.outerCoordinateSystem == null ? jun3dCoordinateSystem == null : this.outerCoordinateSystem.equals((Object)jun3dCoordinateSystem)) {
            return this;
        }
        if (jun3dCoordinateSystem == null) {
            return new Jun3dCoordinateSystem(this.globalTransformation());
        }
        return jun3dCoordinateSystem.newLocalCoordinateSystemTransformation_(this.globalTransformation().product_(jun3dCoordinateSystem.globalInvTransformation()));
    }

    public StObject postCopy() {
        super.postCopy();
        this.localCoordinateSystems = null;
        if (this.outerCoordinateSystem != null) {
            this.outerCoordinateSystem.privateAddLocalCoordinateSystem_(this);
        }
        return this;
    }

    public Jun3dCoordinateSystem newLocalCoordinateSystemScale_(double d) {
        Jun3dCoordinateSystem jun3dCoordinateSystem = Jun3dCoordinateSystem.Scale_(d);
        this.privateAddLocalCoordinateSystem_(jun3dCoordinateSystem);
        return jun3dCoordinateSystem;
    }

    public Jun3dCoordinateSystem newLocalCoordinateSystemTransformation_(Jun3dTransformation jun3dTransformation) {
        Jun3dCoordinateSystem jun3dCoordinateSystem = Jun3dCoordinateSystem.Transformation_(jun3dTransformation);
        this.privateAddLocalCoordinateSystem_(jun3dCoordinateSystem);
        return jun3dCoordinateSystem;
    }

    public boolean is3d() {
        return true;
    }

    protected void clearGlobalTransformation() {
        if (this.globalTransformation == null && this.globalInvTransformation == null) {
            return;
        }
        this.globalTransformation = null;
        this.globalInvTransformation = null;
        if (this.localCoordinateSystems != null) {
            for (int i = 0; i < this.localCoordinateSystems.size(); ++i) {
                ((Jun3dCoordinateSystem)((Object)this.localCoordinateSystems.get(i))).clearGlobalTransformation();
            }
        }
    }

    protected void clearOriginAndVectors() {
        this.origin = null;
        this.xUnitVector = null;
        this.yUnitVector = null;
        this.zUnitVector = null;
    }

    protected void clearTransformations() {
        this.transformation = null;
        this.invTransformation = null;
        this.clearGlobalTransformation();
    }

    protected Jun3dTransformation computeTransformation() {
        double[] dArray = new double[]{this.xUnitVector.x() - this.origin.x(), this.xUnitVector.y() - this.origin.x(), this.xUnitVector.z() - this.origin.x(), 0.0, this.xUnitVector.x() - this.origin.y(), this.xUnitVector.y() - this.origin.y(), this.xUnitVector.z() - this.origin.y(), 0.0, this.xUnitVector.x() - this.origin.z(), this.xUnitVector.y() - this.origin.z(), this.xUnitVector.z() - this.origin.z(), 0.0, this.origin.x(), this.origin.y(), this.origin.z(), 1.0};
        return Jun3dTransformation.FromArray_(dArray);
    }

    protected void privateAddLocalCoordinateSystem_(Jun3dCoordinateSystem jun3dCoordinateSystem) {
        jun3dCoordinateSystem.outerCoordinateSystem = this;
        if (this.localCoordinateSystems == null) {
            this.localCoordinateSystems = new ArrayList();
        }
        this.localCoordinateSystems.add(jun3dCoordinateSystem);
    }
}

