/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxNode;
import jp.co.sra.jun.geometry.boxtree.JunBoundingBoxTree;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;

public class Jun3dBoundingBoxTree
extends JunBoundingBoxTree {
    protected Jun3dBoundingBoxNode rootNode;
    protected Jun3dBoundingBoxNode[] subdividedNodes;

    protected Jun3dBoundingBoxTree() {
    }

    public Jun3dBoundingBoxTree(Jun3dLine[] jun3dLineArray) {
        this();
        this.rootNode_(new Jun3dBoundingBoxNode(jun3dLineArray));
    }

    public Jun3dBoundingBoxTree(Jun3dPoint[] jun3dPointArray) {
        this();
        this.rootNode_(new Jun3dBoundingBoxNode(jun3dPointArray));
    }

    public Jun3dBoundingBoxTree(Jun3dTriangle[] jun3dTriangleArray) {
        this();
        this.rootNode_(new Jun3dBoundingBoxNode(jun3dTriangleArray));
    }

    protected void initialize() {
        super.initialize();
        this.rootNode = null;
        this.subdividedNodes = null;
    }

    public Jun3dBoundingBox boundingBox() {
        return this.rootNode().boundingBox();
    }

    public JunGeometry[] containedObjects() {
        return this.rootNode().containedObjects();
    }

    public Jun3dBoundingBoxNode rootNode() {
        return this.rootNode;
    }

    public void rootNode_(Jun3dBoundingBoxNode jun3dBoundingBoxNode) {
        this.rootNode = jun3dBoundingBoxNode;
    }

    public Jun3dBoundingBoxNode[] subdividedNodes() {
        if (this.subdividedNodes == null) {
            this.subdividedNodesLevel_(1);
        }
        return this.subdividedNodes;
    }

    public Jun3dBoundingBoxNode[] subdividedNodesLevel_(int n) {
        this.levelNumber = n;
        this.subdividedNodes = this.rootNode().subdividedNodesLevel_(this.levelNumber);
        this.rootNode().flushSubdividedNodes();
        return this.subdividedNodes;
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this.boundingBox().equal_((Object)((Jun3dBoundingBoxTree)((Object)object)).boundingBox());
    }

    public Jun3dBoundingBox asBoundingBox() {
        return this.boundingBox();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        Jun3dBoundingBoxNode[] jun3dBoundingBoxNodeArray = this.subdividedNodes();
        for (int i = 0; i < jun3dBoundingBoxNodeArray.length; ++i) {
            junOpenGL3dCompoundObject.add_(jun3dBoundingBoxNodeArray[i].asJunOpenGL3dObjectColor_alpha_(Color.getHSBColor((float)i / (float)jun3dBoundingBoxNodeArray.length, 1.0f, 1.0f), 0.25f));
            Jun3dPoint[][] jun3dPointArray = jun3dBoundingBoxNodeArray[i].boundingBox().pps();
            for (int j = 0; j < jun3dPointArray.length; ++j) {
                JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray[j]);
                junOpenGL3dPolylineLoop.paint_(Color.gray);
                junOpenGL3dPolylineLoop.lineWidth_(1.0f);
                junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop);
            }
        }
        return junOpenGL3dCompoundObject;
    }

    public boolean is3d() {
        return true;
    }
}

