/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.boxtree.JunBoundingBoxNode;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class Jun3dBoundingBoxNode
extends JunBoundingBoxNode {
    protected Jun3dBoundingBoxNode containerNode;
    protected Jun3dBoundingBox boundingBox;

    protected Jun3dBoundingBoxNode() {
    }

    public Jun3dBoundingBoxNode(Collection collection, Jun3dBoundingBox jun3dBoundingBox) {
        this.containedObjects_(collection);
        this.boundingBox_(jun3dBoundingBox);
    }

    public Jun3dBoundingBoxNode(Jun3dLine[] jun3dLineArray) {
        JunGeometry.HashEqualitySet hashEqualitySet = new JunGeometry.HashEqualitySet(jun3dLineArray.length);
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            hashEqualitySet.add(jun3dLineArray[i]);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashEqualitySet);
        hashEqualitySet = new JunGeometry.HashEqualitySet(jun3dLineArray.length + 1);
        for (int i = 0; i < jun3dLineArray.length; ++i) {
            hashEqualitySet.add(jun3dLineArray[i].first());
            hashEqualitySet.add(jun3dLineArray[i].last());
        }
        Jun3dPoint[] jun3dPointArray = hashEqualitySet.toArray(new Jun3dPoint[hashEqualitySet.size()]);
        Jun3dBoundingBox jun3dBoundingBox = new Jun3dBoundingBox(jun3dPointArray);
        this.containedObjects_(arrayList);
        this.boundingBox_(jun3dBoundingBox);
    }

    public Jun3dBoundingBoxNode(Jun3dPoint[] jun3dPointArray) {
        JunGeometry.HashEqualitySet hashEqualitySet = new JunGeometry.HashEqualitySet(jun3dPointArray.length);
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            hashEqualitySet.add(jun3dPointArray[i]);
        }
        ArrayList arrayList = new ArrayList(hashEqualitySet);
        Jun3dBoundingBox jun3dBoundingBox = new Jun3dBoundingBox(arrayList.toArray(new Jun3dPoint[arrayList.size()]));
        this.containedObjects_(arrayList);
        this.boundingBox_(jun3dBoundingBox);
    }

    public Jun3dBoundingBoxNode(Jun3dTriangle[] jun3dTriangleArray) {
        JunGeometry.HashEqualitySet hashEqualitySet = new JunGeometry.HashEqualitySet(jun3dTriangleArray.length);
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            hashEqualitySet.add(jun3dTriangleArray[i]);
        }
        ArrayList arrayList = new ArrayList(hashEqualitySet);
        hashEqualitySet = new JunGeometry.HashEqualitySet(jun3dTriangleArray.length + 1);
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            hashEqualitySet.add(jun3dTriangleArray[i].p1());
            hashEqualitySet.add(jun3dTriangleArray[i].p2());
            hashEqualitySet.add(jun3dTriangleArray[i].p3());
        }
        Jun3dPoint[] jun3dPointArray = hashEqualitySet.toArray(new Jun3dPoint[hashEqualitySet.size()]);
        Jun3dBoundingBox jun3dBoundingBox = new Jun3dBoundingBox(jun3dPointArray);
        this.containedObjects_(arrayList);
        this.boundingBox_(jun3dBoundingBox);
    }

    protected void initialize() {
        super.initialize();
        this.containerNode = null;
        this.boundingBox = null;
        this.compareWithBlock = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                JunGeometry junGeometry = (JunGeometry)((Object)object);
                Jun3dBoundingBox jun3dBoundingBox = (Jun3dBoundingBox)((Object)object2);
                if (junGeometry.isPoint()) {
                    return new Boolean(((Jun3dPoint)junGeometry).boundingBox().touches_(jun3dBoundingBox));
                }
                if (junGeometry.isBoundingBox()) {
                    return new Boolean(((Jun3dBoundingBox)junGeometry).boundingBox().touches_(jun3dBoundingBox));
                }
                if (junGeometry.isLine()) {
                    return new Boolean(((Jun3dLine)junGeometry).boundingBox().touches_(jun3dBoundingBox));
                }
                if (junGeometry.isTriangle()) {
                    return new Boolean(((Jun3dTriangle)junGeometry).boundingBox().touches_(jun3dBoundingBox));
                }
                return null;
            }
        };
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new Jun3dBoundingBox();
        }
        return this.boundingBox;
    }

    public void boundingBox_(Jun3dBoundingBox jun3dBoundingBox) {
        this.boundingBox = jun3dBoundingBox;
        this.flushSubdividedNodes();
    }

    public Jun3dBoundingBoxNode containerNode() {
        return this.containerNode;
    }

    public void containerNode_(Jun3dBoundingBoxNode jun3dBoundingBoxNode) {
        this.containerNode = jun3dBoundingBoxNode;
    }

    public int levelNumber() {
        if (this.levelNumber <= 0) {
            Jun3dBoundingBoxNode jun3dBoundingBoxNode = this.containerNode();
            int n = 0;
            while (jun3dBoundingBoxNode != null) {
                jun3dBoundingBoxNode = jun3dBoundingBoxNode.containerNode();
                ++n;
            }
            this.levelNumber = n;
        }
        return this.levelNumber;
    }

    public Jun3dBoundingBoxNode[] subdividedNodes() {
        if (this.subdividedNodes == null) {
            this.subdivide();
        }
        return this.subdividedNodes.toArray(new Jun3dBoundingBoxNode[this.subdividedNodes.size()]);
    }

    public Jun3dBoundingBoxNode[] subdividedNodesLevel_(int n) {
        this.subdivideLevel_(n);
        final ArrayList arrayList = new ArrayList();
        this.do_(new StBlockClosure(){

            public Object value_(Object object) {
                if (((Jun3dBoundingBoxNode)((Object)object)).boxSituation() == 2.$((String)"necessary")) {
                    arrayList.add(object);
                }
                return null;
            }
        });
        return arrayList.toArray(new Jun3dBoundingBoxNode[arrayList.size()]);
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this.boundingBox().equal_((Object)((Jun3dBoundingBoxNode)((Object)object)).boundingBox());
    }

    public int hashCode() {
        return this.boundingBox().hashCode();
    }

    public Jun3dBoundingBox asBoundingBox() {
        return this.boundingBox();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        Color color = Color.gray;
        if (this.boxSituation == Jun3dBoundingBoxNode.$((String)"through")) {
            color = Color.cyan;
        }
        if (this.boxSituation == Jun3dBoundingBoxNode.$((String)"necessary")) {
            color = Color.magenta;
        }
        if (this.boxSituation == Jun3dBoundingBoxNode.$((String)"unnecessary")) {
            color = Color.yellow;
        }
        float f = 0.25f;
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(this.boundingBox().asJunOpenGL3dObjectColor_alpha_(color, f));
        Jun3dPoint[][] jun3dPointArray = this.boundingBox().pps();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray[i]);
            junOpenGL3dPolylineLoop.paint_(color);
            junOpenGL3dPolylineLoop.lineWidth_(1.0f);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop);
        }
        return junOpenGL3dCompoundObject;
    }

    public Object do_(StBlockClosure stBlockClosure) {
        switch (stBlockClosure.numArgs()) {
            case 1: {
                stBlockClosure.valueWithArguments_(new Object[]{this});
                break;
            }
            case 2: {
                stBlockClosure.valueWithArguments_(new Object[]{this, new Integer(this.levelNumber)});
            }
        }
        if (this.subdividedNodes != null && this.subdividedNodes.size() > 0) {
            Jun3dBoundingBoxNode[] jun3dBoundingBoxNodeArray = this.subdividedNodes();
            for (int i = 0; i < jun3dBoundingBoxNodeArray.length; ++i) {
                jun3dBoundingBoxNodeArray[i].do_(stBlockClosure);
            }
        }
        return null;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("(");
        writer.write(this.shortPrintString());
        writer.write(Integer.toString(this.containedObjects().length));
        writer.write(", ");
        this.boundingBox().printOn_(writer);
        writer.write(")");
    }

    public String shortPrintString() {
        return "3dbbn";
    }

    public Jun3dBoundingBoxNode subdivide() {
        return this.subdivideLevel_(1);
    }

    public Jun3dBoundingBoxNode subdivideLevel_(int n) {
        int n2;
        Jun3dBoundingBoxNode[] jun3dBoundingBoxNodeArray;
        if (this.levelNumber() == n) {
            return this;
        }
        final Jun3dBoundingBoxNode jun3dBoundingBoxNode = this;
        if (this.subdividedNodes == null) {
            jun3dBoundingBoxNodeArray = new ArrayList(2);
            try {
                ((Jun3dBoundingBoxes)((Object)this.boundingBox().perform_(this.messageToSubdivide().toString()))).do_(new StBlockClosure((List)jun3dBoundingBoxNodeArray){
                    private final /* synthetic */ List val$aCollection;
                    {
                        this.val$aCollection = list;
                    }

                    public Object value_(Object object) {
                        Jun3dBoundingBox jun3dBoundingBox = (Jun3dBoundingBox)((Object)object);
                        JunGeometry[] junGeometryArray = jun3dBoundingBoxNode.containedObjects();
                        ArrayList<JunGeometry> arrayList = new ArrayList<JunGeometry>();
                        for (int i = 0; i < junGeometryArray.length; ++i) {
                            if (!Boolean.TRUE.equals(jun3dBoundingBoxNode.compare_with_(junGeometryArray[i], jun3dBoundingBox))) continue;
                            arrayList.add(junGeometryArray[i]);
                        }
                        Jun3dBoundingBoxNode jun3dBoundingBoxNode2 = new Jun3dBoundingBoxNode();
                        jun3dBoundingBoxNode2.containedObjects_(arrayList);
                        jun3dBoundingBoxNode2.boundingBox_(jun3dBoundingBox);
                        jun3dBoundingBoxNode2.vanishBoolean_(Jun3dBoundingBoxNode.this.vanishBoolean);
                        jun3dBoundingBoxNode2.messageToSubdivide_(Jun3dBoundingBoxNode.this.messageToSubdivide);
                        jun3dBoundingBoxNode2.compareWithBlock_(Jun3dBoundingBoxNode.this.compareWithBlock);
                        jun3dBoundingBoxNode2.containerNode_(jun3dBoundingBoxNode);
                        if (arrayList.isEmpty()) {
                            jun3dBoundingBoxNode2.boxSituation_(3.$((String)"unnecessary"));
                        } else {
                            jun3dBoundingBoxNode2.boxSituation_(3.$((String)"necessary"));
                        }
                        this.val$aCollection.add(jun3dBoundingBoxNode2);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                throw new SmalltalkException(exception);
            }
            this.subdividedNodes = jun3dBoundingBoxNodeArray;
        }
        jun3dBoundingBoxNodeArray = this.subdividedNodes.toArray(new Jun3dBoundingBoxNode[this.subdividedNodes.size()]);
        for (int i = 0; i < jun3dBoundingBoxNodeArray.length; ++i) {
            jun3dBoundingBoxNodeArray[i] = jun3dBoundingBoxNodeArray[i].subdivideLevel_(n);
            this.subdividedNodes.set(i, jun3dBoundingBoxNodeArray[i]);
        }
        ArrayList<StSymbol> arrayList = new ArrayList<StSymbol>();
        for (n2 = 0; n2 < jun3dBoundingBoxNodeArray.length; ++n2) {
            arrayList.add(jun3dBoundingBoxNodeArray[n2].boxSituation());
        }
        if (arrayList.contains(Jun3dBoundingBoxNode.$((String)"unnecessary")) || arrayList.contains(Jun3dBoundingBoxNode.$((String)"through"))) {
            this.boxSituation_(Jun3dBoundingBoxNode.$((String)"through"));
        } else {
            int n3;
            n2 = 1;
            StSymbol[] stSymbolArray = arrayList.toArray(new StSymbol[arrayList.size()]);
            for (n3 = 0; n3 < stSymbolArray.length; ++n3) {
                if (stSymbolArray[n3] == Jun3dBoundingBoxNode.$((String)"necessary")) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0) {
                this.boxSituation_(Jun3dBoundingBoxNode.$((String)"necessary"));
                if (this.vanishBoolean()) {
                    this.flushSubdividedNodes();
                } else {
                    for (n3 = 0; n3 < jun3dBoundingBoxNodeArray.length; ++n3) {
                        jun3dBoundingBoxNodeArray[n3].boxSituation_(Jun3dBoundingBoxNode.$((String)"unnecessary"));
                    }
                }
            } else {
                this.boxSituation_(Jun3dBoundingBoxNode.$((String)"through"));
            }
        }
        return this;
    }

    public boolean is3d() {
        return true;
    }
}

