/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boxtree.JunBoundingBoxNode;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBoxes;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class Jun2dBoundingBoxNode
extends JunBoundingBoxNode {
    protected Jun2dBoundingBoxNode containerNode;
    protected Jun2dBoundingBox boundingBox;

    protected Jun2dBoundingBoxNode() {
    }

    public Jun2dBoundingBoxNode(Collection collection, Jun2dBoundingBox jun2dBoundingBox) {
        this.containedObjects_(collection);
        this.boundingBox_(jun2dBoundingBox);
    }

    public Jun2dBoundingBoxNode(Jun2dLine[] jun2dLineArray) {
        JunGeometry.HashEqualitySet hashEqualitySet = new JunGeometry.HashEqualitySet(jun2dLineArray.length);
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            hashEqualitySet.add(jun2dLineArray[i]);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashEqualitySet);
        hashEqualitySet = new JunGeometry.HashEqualitySet(jun2dLineArray.length + 1);
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            hashEqualitySet.add(jun2dLineArray[i].first());
            hashEqualitySet.add(jun2dLineArray[i].last());
        }
        Jun2dPoint[] jun2dPointArray = hashEqualitySet.toArray(new Jun2dPoint[hashEqualitySet.size()]);
        Jun2dBoundingBox jun2dBoundingBox = new Jun2dBoundingBox(jun2dPointArray);
        this.containedObjects_(arrayList);
        this.boundingBox_(jun2dBoundingBox);
    }

    public Jun2dBoundingBoxNode(Jun2dPoint[] jun2dPointArray) {
        JunGeometry.HashEqualitySet hashEqualitySet = new JunGeometry.HashEqualitySet(jun2dPointArray.length);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            hashEqualitySet.add(jun2dPointArray[i]);
        }
        Jun2dPoint[] jun2dPointArray2 = hashEqualitySet.toArray(new Jun2dPoint[hashEqualitySet.size()]);
        Jun2dBoundingBox jun2dBoundingBox = new Jun2dBoundingBox(jun2dPointArray2);
        this.containedObjects_(hashEqualitySet);
        this.boundingBox_(jun2dBoundingBox);
    }

    public Jun2dBoundingBoxNode(Jun2dTriangle[] jun2dTriangleArray) {
        JunGeometry.HashEqualitySet hashEqualitySet = new JunGeometry.HashEqualitySet(jun2dTriangleArray.length);
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            hashEqualitySet.add(jun2dTriangleArray[i]);
        }
        ArrayList arrayList = new ArrayList(hashEqualitySet);
        hashEqualitySet = new JunGeometry.HashEqualitySet(jun2dTriangleArray.length + 1);
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            hashEqualitySet.add(jun2dTriangleArray[i].p1());
            hashEqualitySet.add(jun2dTriangleArray[i].p2());
            hashEqualitySet.add(jun2dTriangleArray[i].p3());
        }
        Jun2dPoint[] jun2dPointArray = hashEqualitySet.toArray(new Jun2dPoint[hashEqualitySet.size()]);
        Jun2dBoundingBox jun2dBoundingBox = new Jun2dBoundingBox(jun2dPointArray);
        this.containedObjects_(arrayList);
        this.boundingBox_(jun2dBoundingBox);
    }

    protected void initialize() {
        super.initialize();
        this.containerNode = null;
        this.boundingBox = null;
        this.compareWithBlock = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                JunGeometry junGeometry = (JunGeometry)((Object)object);
                Jun2dBoundingBox jun2dBoundingBox = (Jun2dBoundingBox)((Object)object2);
                if (junGeometry.isPoint()) {
                    return new Boolean(((Jun2dPoint)junGeometry).boundingBox().touches_(jun2dBoundingBox));
                }
                if (junGeometry.isBoundingBox()) {
                    return new Boolean(((Jun2dBoundingBox)junGeometry).boundingBox().touches_(jun2dBoundingBox));
                }
                if (junGeometry.isLine()) {
                    return new Boolean(((Jun2dLine)junGeometry).boundingBox().touches_(jun2dBoundingBox));
                }
                if (junGeometry.isTriangle()) {
                    return new Boolean(((Jun2dTriangle)junGeometry).boundingBox().touches_(jun2dBoundingBox));
                }
                return null;
            }
        };
    }

    public Jun2dBoundingBox boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new Jun2dBoundingBox();
        }
        return this.boundingBox;
    }

    public void boundingBox_(Jun2dBoundingBox jun2dBoundingBox) {
        this.boundingBox = jun2dBoundingBox;
        this.flushSubdividedNodes();
    }

    public Jun2dBoundingBoxNode containerNode() {
        return this.containerNode;
    }

    public void containerNode_(Jun2dBoundingBoxNode jun2dBoundingBoxNode) {
        this.containerNode = jun2dBoundingBoxNode;
    }

    public int levelNumber() {
        if (this.levelNumber <= 0) {
            Jun2dBoundingBoxNode jun2dBoundingBoxNode = this.containerNode();
            int n = 0;
            while (jun2dBoundingBoxNode != null) {
                jun2dBoundingBoxNode = jun2dBoundingBoxNode.containerNode();
                ++n;
            }
            this.levelNumber = n;
        }
        return this.levelNumber;
    }

    public Jun2dBoundingBoxNode[] subdividedNodes() {
        if (this.subdividedNodes == null) {
            this.subdivide();
        }
        return this.subdividedNodes.toArray(new Jun2dBoundingBoxNode[this.subdividedNodes.size()]);
    }

    public Jun2dBoundingBoxNode[] subdividedNodesLevel_(int n) {
        this.subdivideLevel_(n);
        final ArrayList arrayList = new ArrayList();
        this.do_(new StBlockClosure(){

            public Object value_(Object object) {
                if (((Jun2dBoundingBoxNode)((Object)object)).boxSituation() == 2.$((String)"necessary")) {
                    arrayList.add(object);
                }
                return null;
            }
        });
        return arrayList.toArray(new Jun2dBoundingBoxNode[arrayList.size()]);
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this.boundingBox().equal_((Object)((Jun2dBoundingBoxNode)((Object)object)).boundingBox());
    }

    public int hashCode() {
        return this.boundingBox().hashCode();
    }

    public Jun2dBoundingBox asBoundingBox() {
        return this.boundingBox();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        int n;
        Color color = Color.gray;
        if (this.boxSituation == Jun2dBoundingBoxNode.$((String)"through")) {
            color = Color.cyan;
        }
        if (this.boxSituation == Jun2dBoundingBoxNode.$((String)"necessary")) {
            color = Color.magenta;
        }
        if (this.boxSituation == Jun2dBoundingBoxNode.$((String)"unnecessary")) {
            color = Color.yellow;
        }
        float f = 0.25f;
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(this.boundingBox().asJunOpenGL3dObjectColor_alpha_(color, f));
        Jun2dPoint[][] jun2dPointArray = this.boundingBox().pps();
        Jun3dPoint[][] jun3dPointArrayArray = new Jun3dPoint[jun2dPointArray.length][];
        for (n = 0; n < jun2dPointArray.length; ++n) {
            jun3dPointArrayArray[n] = new Jun3dPoint[jun2dPointArray[n].length];
            for (int i = 0; i < jun2dPointArray[n].length; ++i) {
                jun3dPointArrayArray[n][i] = jun2dPointArray[n][i].as3dPoint();
            }
        }
        for (n = 0; n < jun3dPointArrayArray.length; ++n) {
            JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArrayArray[n]);
            junOpenGL3dPolylineLoop.paint_(color);
            junOpenGL3dPolylineLoop.lineWidth_(1.0f);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop);
        }
        return junOpenGL3dCompoundObject;
    }

    public Object do_(StBlockClosure stBlockClosure) {
        switch (stBlockClosure.numArgs()) {
            case 1: {
                stBlockClosure.valueWithArguments_(new Object[]{this});
                break;
            }
            case 2: {
                stBlockClosure.valueWithArguments_(new Object[]{this, new Integer(this.levelNumber)});
            }
        }
        if (this.subdividedNodes != null && this.subdividedNodes.size() > 0) {
            Jun2dBoundingBoxNode[] jun2dBoundingBoxNodeArray = this.subdividedNodes();
            for (int i = 0; i < jun2dBoundingBoxNodeArray.length; ++i) {
                jun2dBoundingBoxNodeArray[i].do_(stBlockClosure);
            }
        }
        return null;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("(");
        writer.write(this.shortPrintString());
        writer.write(Integer.toString(this.containedObjects().length));
        writer.write(", ");
        this.boundingBox().printOn_(writer);
        writer.write(")");
    }

    public String shortPrintString() {
        return "2dbbn";
    }

    public Jun2dBoundingBoxNode subdivide() {
        return this.subdivideLevel_(1);
    }

    public Jun2dBoundingBoxNode subdivideLevel_(int n) {
        int n2;
        Jun2dBoundingBoxNode[] jun2dBoundingBoxNodeArray;
        if (this.levelNumber() == n) {
            return this;
        }
        final Jun2dBoundingBoxNode jun2dBoundingBoxNode = this;
        if (this.subdividedNodes == null) {
            jun2dBoundingBoxNodeArray = new ArrayList(2);
            try {
                ((Jun2dBoundingBoxes)((Object)this.boundingBox().perform_(this.messageToSubdivide().toString()))).do_(new StBlockClosure((List)jun2dBoundingBoxNodeArray){
                    private final /* synthetic */ List val$aCollection;
                    {
                        this.val$aCollection = list;
                    }

                    public Object value_(Object object) {
                        Jun2dBoundingBox jun2dBoundingBox = (Jun2dBoundingBox)((Object)object);
                        JunGeometry[] junGeometryArray = jun2dBoundingBoxNode.containedObjects();
                        ArrayList<JunGeometry> arrayList = new ArrayList<JunGeometry>();
                        for (int i = 0; i < junGeometryArray.length; ++i) {
                            if (!Boolean.TRUE.equals(jun2dBoundingBoxNode.compare_with_(junGeometryArray[i], jun2dBoundingBox))) continue;
                            arrayList.add(junGeometryArray[i]);
                        }
                        Jun2dBoundingBoxNode jun2dBoundingBoxNode2 = new Jun2dBoundingBoxNode();
                        jun2dBoundingBoxNode2.containedObjects_(arrayList);
                        jun2dBoundingBoxNode2.boundingBox_(jun2dBoundingBox);
                        jun2dBoundingBoxNode2.vanishBoolean_(Jun2dBoundingBoxNode.this.vanishBoolean);
                        jun2dBoundingBoxNode2.messageToSubdivide_(Jun2dBoundingBoxNode.this.messageToSubdivide);
                        jun2dBoundingBoxNode2.compareWithBlock_(Jun2dBoundingBoxNode.this.compareWithBlock);
                        jun2dBoundingBoxNode2.containerNode_(jun2dBoundingBoxNode);
                        if (arrayList.isEmpty()) {
                            jun2dBoundingBoxNode2.boxSituation_(3.$((String)"unnecessary"));
                        } else {
                            jun2dBoundingBoxNode2.boxSituation_(3.$((String)"necessary"));
                        }
                        this.val$aCollection.add(jun2dBoundingBoxNode2);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                throw new SmalltalkException(exception);
            }
            this.subdividedNodes = jun2dBoundingBoxNodeArray;
        }
        jun2dBoundingBoxNodeArray = this.subdividedNodes.toArray(new Jun2dBoundingBoxNode[this.subdividedNodes.size()]);
        for (int i = 0; i < jun2dBoundingBoxNodeArray.length; ++i) {
            jun2dBoundingBoxNodeArray[i] = jun2dBoundingBoxNodeArray[i].subdivideLevel_(n);
            this.subdividedNodes.set(i, jun2dBoundingBoxNodeArray[i]);
        }
        ArrayList<StSymbol> arrayList = new ArrayList<StSymbol>();
        for (n2 = 0; n2 < jun2dBoundingBoxNodeArray.length; ++n2) {
            arrayList.add(jun2dBoundingBoxNodeArray[n2].boxSituation());
        }
        if (arrayList.contains(Jun2dBoundingBoxNode.$((String)"unnecessary")) || arrayList.contains(Jun2dBoundingBoxNode.$((String)"through"))) {
            this.boxSituation_(Jun2dBoundingBoxNode.$((String)"through"));
        } else {
            int n3;
            n2 = 1;
            StSymbol[] stSymbolArray = arrayList.toArray(new StSymbol[arrayList.size()]);
            for (n3 = 0; n3 < stSymbolArray.length; ++n3) {
                if (stSymbolArray[n3] == Jun2dBoundingBoxNode.$((String)"necessary")) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0) {
                this.boxSituation_(Jun2dBoundingBoxNode.$((String)"necessary"));
                if (this.vanishBoolean()) {
                    this.flushSubdividedNodes();
                } else {
                    for (n3 = 0; n3 < jun2dBoundingBoxNodeArray.length; ++n3) {
                        jun2dBoundingBoxNodeArray[n3].boxSituation_(Jun2dBoundingBoxNode.$((String)"unnecessary"));
                    }
                }
            } else {
                this.boxSituation_(Jun2dBoundingBoxNode.$((String)"through"));
            }
        }
        return this;
    }

    public boolean is2d() {
        return true;
    }
}

