/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boundaries;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dPolygonalBoundary;
import jp.co.sra.jun.geometry.boundaries.JunBorderGenerator;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;

public class JunBorderGeneratorTestExamples
extends JunTestExamples {
    public static boolean Example2D_Circle() {
        final Jun2dPoint jun2dPoint = new Jun2dPoint(0.0, 0.0);
        Jun2dPolygonalBoundary jun2dPolygonalBoundary = JunBorderGenerator.PolygonalBoundaryWith_max_xInterval_yInterval_interim_(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                return new Double(jun2dPoint.distance_(new Jun2dPoint((Number)object, (Number)object2)));
            }
        }, 1.0, new StInterval(-1.1, 1.1, 0.1), new StInterval(-1.1, 1.1, 0.1), null);
        JunOpenGL3dObject junOpenGL3dObject = jun2dPolygonalBoundary.asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.blue);
        junOpenGL3dObject.show();
        return true;
    }

    public static boolean Example2D_Eclipse() {
        final Jun2dPoint jun2dPoint = new Jun2dPoint(-0.4, 0.0);
        final Jun2dPoint jun2dPoint2 = new Jun2dPoint(0.4, 0.0);
        Jun2dPolygonalBoundary jun2dPolygonalBoundary = JunBorderGenerator.PolygonalBoundaryWith_max_xInterval_yInterval_interim_(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                Jun2dPoint jun2dPoint3 = new Jun2dPoint((Number)object, (Number)object2);
                return new Double(jun2dPoint3.distance_(jun2dPoint) + jun2dPoint3.distance_(jun2dPoint2));
            }
        }, 1.0, new StInterval(-1.1, 1.1, 0.1), new StInterval(-1.1, 1.1, 0.1), null);
        JunOpenGL3dObject junOpenGL3dObject = jun2dPolygonalBoundary.asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.blue);
        junOpenGL3dObject.show();
        return true;
    }

    public static boolean Example2D_NegativeCircle() {
        Jun2dPolygonalBoundary jun2dPolygonalBoundary = JunBorderGenerator.PolygonalBoundaryWith_min_xInterval_yInterval_interim_(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                return new Double(new Jun2dPoint((Number)object, (Number)object2).r());
            }
        }, 1.0, new StInterval(-1.1, 1.1, 0.1), new StInterval(-1.1, 1.1, 0.1), null);
        JunOpenGL3dObject junOpenGL3dObject = jun2dPolygonalBoundary.asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.blue);
        junOpenGL3dObject.show();
        return true;
    }

    public static boolean Example2D_ImageContouring() {
        final StImage stImage = StImage._OfArea((Rectangle)new Rectangle(2, 2, 128, 128));
        int n = stImage.width();
        int n2 = stImage.height();
        double d = Math.max(n, n2);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[]{new Jun3dPoint(-n, -n2, 0.0), new Jun3dPoint(n, -n2, 0.0), new Jun3dPoint(n, n2, 0.0), new Jun3dPoint(-n, n2, 0.0)});
        JunOpenGLTexture junOpenGLTexture = new JunOpenGLTexture(stImage);
        junOpenGL3dPolygon.texture_(junOpenGLTexture);
        junOpenGLTexture.zPositiveParameters();
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolygon);
        HashMap<StSymbol, Jun3dPoint> hashMap = new HashMap<StSymbol, Jun3dPoint>();
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"eyePoint"), new Jun3dPoint(0.0, d * -4.0, d * 2.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"sightPoint"), new Jun3dPoint(0.0, 0.0, d / 2.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"upVector"), new Jun3dPoint(0.0, 1.0, 0.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"projection"), (Jun3dPoint)JunBorderGeneratorTestExamples.$((String)"parallelProjection"));
        JunOpenGLDisplayModel junOpenGLDisplayModel = junOpenGL3dCompoundObject.showProjectionTable_(hashMap);
        for (int i = 0; i <= 10; ++i) {
            double d2 = (double)i * 0.1;
            Jun2dPoint[][] jun2dPointArray = JunBorderGenerator.ContourPolylinesFrom_at_xInterval_yInterval_interim_(new StBlockClosure(){

                public Object value_value_(Object object, Object object2) {
                    int n = ((Number)object).intValue();
                    int n2 = ((Number)object2).intValue();
                    return new Float(StColorValue._GetBrightness((Color)stImage.valueAtPoint_(new Point(n, n2))));
                }
            }, d2, new StInterval(0.0, (double)(n - 1)), new StInterval(0.0, (double)(n2 - 1)), null);
            for (int j = 0; j < jun2dPointArray.length; ++j) {
                Jun2dPoint[] jun2dPointArray2 = jun2dPointArray[j];
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray2.length];
                for (int k = 0; k < jun3dPointArray.length; ++k) {
                    double d3 = jun2dPointArray2[k].x();
                    double d4 = jun2dPointArray2[k].y();
                    jun3dPointArray[k] = new Jun3dPoint(d3 * 2.0 - (double)n + 3.0, (double)n2 - d4 * 2.0 - 2.0, d2 * d);
                }
                JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray, StColorValue.Brightness_((double)d2));
                junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
            }
            junOpenGLDisplayModel.resetView();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example2D_CutFigure() {
        final StImage stImage = StImage._OfArea((Rectangle)new Rectangle(2, 2, 128, 128));
        int n = stImage.width();
        int n2 = stImage.height();
        double d = Math.max(n, n2);
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        HashMap<StSymbol, Jun3dPoint> hashMap = new HashMap<StSymbol, Jun3dPoint>();
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"eyePoint"), new Jun3dPoint(0.0, d * -12.0, d * 4.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"sightPoint"), new Jun3dPoint(0.0, 0.0, d));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"upVector"), new Jun3dPoint(0.0, 1.0, 0.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"projection"), (Jun3dPoint)JunBorderGeneratorTestExamples.$((String)"parallelProjection"));
        junOpenGLDisplayModel.defaultProjectionTable_(hashMap);
        junOpenGLDisplayModel.open();
        Rectangle rectangle = junOpenGLDisplayModel.getWindow().getBounds();
        JunImageDisplayModel junImageDisplayModel = JunImageDisplayModel.Show_at_((StDisplayable)stImage, new Point(rectangle.x + rectangle.width + 8, rectangle.y));
        for (int i = 0; i <= 9; ++i) {
            Object object;
            final double d2 = (double)i * 0.1;
            Jun2dPolygonalBoundary jun2dPolygonalBoundary = JunBorderGenerator.PolygonalBoundaryWith_min_max_xInterval_yInterval_interim_(new StBlockClosure(){

                public Object value_value_(Object object, Object object2) {
                    int n = ((Number)object).intValue();
                    int n2 = ((Number)object2).intValue();
                    return new Float(StColorValue._GetBrightness((Color)stImage.valueAtPoint_(new Point(n, n2))));
                }
            }, d2, 1.0, new StInterval(0.0, (double)(n - 1)), new StInterval(0.0, (double)(n2 - 1)), null);
            Graphics graphics = null;
            try {
                graphics = stImage.image().getGraphics();
                graphics.setColor(Color.blue);
                object = jun2dPolygonalBoundary.polygons();
                for (int j = 0; j < ((Jun2dPolygon[])object).length; ++j) {
                    object[j].displayOn_(graphics);
                }
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
            junImageDisplayModel.image_((StDisplayable)stImage);
            junImageDisplayModel.redisplay();
            object = new JunOpenGL3dCompoundObject();
            jun2dPolygonalBoundary.scaledBy_(new Jun2dPoint(2.0, -2.0)).translatedBy_(new Jun2dPoint(-n, n2)).asJunOpenGL3dObjectsDo_(new StBlockClosure((JunOpenGL3dCompoundObject)object){
                private final /* synthetic */ JunOpenGL3dCompoundObject val$body;
                {
                    this.val$body = junOpenGL3dCompoundObject;
                }

                public Object value_(Object object) {
                    JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                    junOpenGL3dObject.paint_(StColorValue.Brightness_((double)d2));
                    this.val$body.add_(junOpenGL3dObject);
                    return null;
                }
            });
            JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dTransformedObject((JunOpenGL3dObject)((Object)object), new Jun3dPoint(0.0, 0.0, d2).multipliedBy_(d * 2.0).transformationToTranslate()));
            if (junOpenGLDisplayModel.displayObject() != null) {
                junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject(junOpenGLDisplayModel.displayObject(), junOpenGL3dCompoundObject);
            }
            junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
            junOpenGLDisplayModel.resetView();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example2D_Text() {
        String string = JunDialog.Request_(JunBorderGeneratorTestExamples.$String((String)"Type in your favorite phrase."), JunBorderGeneratorTestExamples.$String((String)"Be free!"));
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = JunDialog.Request_(JunSystem.$String((String)"Enter weight of the font.") + " (0.1 .. 0.9)", "0.5");
        if (string2 == null) {
            return false;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        d = Math.max(0.1, Math.min(d, 0.9));
        Font font = StComposedText.DefaultFont();
        Dimension dimension = new StComposedText(string, font).extent();
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.open();
        HashMap<StSymbol, Jun3dPoint> hashMap = new HashMap<StSymbol, Jun3dPoint>();
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"eyePoint"), new Jun3dPoint(dimension.getWidth() / 2.0, dimension.getHeight() / 2.0, dimension.getWidth()));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"sightPoint"), new Jun3dPoint(dimension.getWidth() / 2.0, dimension.getHeight() / 2.0, 0.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"upVector"), new Jun3dPoint(0.0, 1.0, 0.0));
        junOpenGLDisplayModel.defaultProjectionTable_(hashMap);
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            StComposedText stComposedText = new StComposedText(String.valueOf(cArray[i]), font);
            final StImage stImage = new StImage(stComposedText.extent());
            Graphics graphics = null;
            try {
                graphics = stImage.image().getGraphics();
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, stImage.width(), stImage.height());
                graphics.setColor(Color.white);
                stComposedText.displayOn_(graphics);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
            Jun2dPolygonalBoundary jun2dPolygonalBoundary = JunBorderGenerator.PolygonalBoundaryWith_min_max_xInterval_yInterval_interim_(new StBlockClosure(){

                public Object value_value_(Object object, Object object2) {
                    Point point = new Point(((Number)object).intValue(), ((Number)object2).intValue());
                    return new Float(StColorValue._GetBrightness((Color)stImage.valueAtPoint_(point)));
                }
            }, 1.0 - d, 1.0, new StInterval(0.0, (double)(stImage.width() - 1)), new StInterval(0.0, (double)(stImage.height() - 1)), null);
            jun2dPolygonalBoundary = jun2dPolygonalBoundary.scaledBy_(new Jun2dPoint(1.0, -1.0));
            jun2dPolygonalBoundary = jun2dPolygonalBoundary.translatedBy_(new Jun2dPoint(n, stImage.height()));
            n += stImage.width();
            JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)junOpenGLDisplayModel.displayObject();
            if (junOpenGL3dCompoundObject == null) {
                junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
            }
            junOpenGL3dCompoundObject.add_(jun2dPolygonalBoundary.asJunOpenGL3dObjectColor_(Color.blue));
            junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
            junOpenGLDisplayModel.resetView();
        }
        return true;
    }

    public static boolean Example3D_Sphere() {
        final Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 0.0);
        final JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.open();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                final Jun3dPolygon[] jun3dPolygonArray = collection.toArray(new Jun3dPolygon[collection.size()]);
                junOpenGLDisplayModel.do_forMilliseconds_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
                            junOpenGL3dCompoundObject.add_(jun3dPolygonArray[i].asJunOpenGL3dObjectColor_(Color.cyan));
                        }
                        junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                        junOpenGLDisplayModel.resetView();
                        return null;
                    }
                }, 500);
                return null;
            }
        };
        final StValueHolder stValueHolder = new StValueHolder(0);
        JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                return new Double(new Jun3dPoint((Number)object, (Number)object2, (Number)object3).distance_(jun3dPoint));
            }
        }, 1.0, -1, new StInterval(-1.2, 1.2, 0.2), new StInterval(-1.2, 1.2, 0.2), new StInterval(-1.2, 1.2, 0.2), new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                if (collection.size() != stValueHolder._intValue()) {
                    stBlockClosure.value_((Object)collection);
                    stValueHolder.value_(collection.size());
                }
                return null;
            }
        });
        return true;
    }

    public static boolean Example3D_ElectricField() {
        final int[] nArray = new int[]{1, 3, -2, -4};
        final Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(-1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, -1.0, 0.0)};
        int[] nArray2 = new int[]{1, 0, -1};
        final Color[] colorArray = new Color[]{Color.blue, Color.yellow, Color.red};
        final JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.open();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                Collection collection = (Collection)object;
                final Jun3dPolygon[] jun3dPolygonArray = collection.toArray(new Jun3dPolygon[collection.size()]);
                final int n = ((Number)object2).intValue();
                junOpenGLDisplayModel.do_forMilliseconds_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)junOpenGLDisplayModel.displayObject();
                        if (junOpenGL3dCompoundObject == null) {
                            junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                        }
                        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
                            junOpenGL3dCompoundObject.add_(jun3dPolygonArray[i].asJunOpenGL3dObjectColor_(colorArray[n]));
                        }
                        junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                        junOpenGLDisplayModel.resetView();
                        return null;
                    }
                }, 500);
                return null;
            }
        };
        for (int i = 0; i < nArray2.length; ++i) {
            final Integer n = new Integer(i);
            final StValueHolder stValueHolder = new StValueHolder(0);
            JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure(){

                public Object value_value_value_(Object object, Object object2, Object object3) {
                    Jun3dPoint jun3dPoint = new Jun3dPoint((Number)object, (Number)object2, (Number)object3);
                    double d = 0.0;
                    for (int i = 0; i < nArray.length; ++i) {
                        double d2 = jun3dPoint.distance_(jun3dPointArray[i]);
                        if (d2 < jun3dPointArray[i].accuracy()) {
                            d += (double)nArray[i];
                            continue;
                        }
                        d += (double)nArray[i] / Math.pow(d2, 2.0);
                    }
                    return new Double(d);
                }
            }, nArray2[i], 1, new StInterval(-2.0, 2.0, 0.3), new StInterval(-2.0, 2.0, 0.3), new StInterval(-2.0, 2.0, 0.3), new StBlockClosure(){

                public Object value_(Object object) {
                    Collection collection = (Collection)object;
                    if (collection.size() != stValueHolder._intValue()) {
                        stBlockClosure.value_value_((Object)collection, (Object)n);
                        stValueHolder.value_(collection.size());
                    }
                    return null;
                }
            });
        }
        return true;
    }

    public static boolean Example3D_Rugbyball() {
        final Jun3dPoint jun3dPoint = new Jun3dPoint(-0.5, 0.0, 0.0);
        final Jun3dPoint jun3dPoint2 = new Jun3dPoint(0.5, 0.0, 0.0);
        final JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.open();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                final Jun3dPolygon[] jun3dPolygonArray = collection.toArray(new Jun3dPolygon[collection.size()]);
                junOpenGLDisplayModel.do_forMilliseconds_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
                            junOpenGL3dCompoundObject.add_(jun3dPolygonArray[i].asJunOpenGL3dObjectColor_(Color.green));
                        }
                        junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                        junOpenGLDisplayModel.resetView();
                        return null;
                    }
                }, 1000);
                return null;
            }
        };
        final StValueHolder stValueHolder = new StValueHolder(0);
        JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Jun3dPoint jun3dPoint3 = new Jun3dPoint((Number)object, (Number)object2, (Number)object3);
                return new Double(jun3dPoint3.distance_(jun3dPoint) + jun3dPoint3.distance_(jun3dPoint2));
            }
        }, 1.3, -1, new StInterval(-1.0, 2.0, 0.2), new StInterval(-1.0, 1.0, 0.1), new StInterval(-1.0, 1.0, 0.1), new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                if (collection.size() != stValueHolder._intValue()) {
                    stBlockClosure.value_((Object)collection);
                    stValueHolder.value_(collection.size());
                }
                return null;
            }
        });
        return true;
    }

    public static boolean Example3D_Jun3dLogo() {
        final StImage stImage = new StImage(JunSystem.LogoImage());
        final JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        HashMap<StSymbol, Jun3dPoint> hashMap = new HashMap<StSymbol, Jun3dPoint>();
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"eyePoint"), new Jun3dPoint(stImage.bounds().getCenterX(), stImage.bounds().getCenterY(), 1000.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"sightPoint"), new Jun3dPoint(stImage.bounds().getCenterX(), stImage.bounds().getCenterY(), 0.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"upVector"), new Jun3dPoint(0.0, 1.0, 0.0));
        junOpenGLDisplayModel.defaultProjectionTable_(hashMap);
        junOpenGLDisplayModel.open();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                Jun3dPolygon[] jun3dPolygonArray = collection.toArray(new Jun3dPolygon[collection.size()]);
                JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                for (int i = 0; i < jun3dPolygonArray.length; ++i) {
                    junOpenGL3dCompoundObject.add_(jun3dPolygonArray[i].asJunOpenGL3dObjectColor_(Color.blue));
                }
                junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                junOpenGLDisplayModel.resetView();
                return null;
            }
        };
        final StValueHolder stValueHolder = new StValueHolder(0);
        JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Color color = stImage.valueAtPoint_(new Point(((Number)object).intValue(), stImage.height() - ((Number)object2).intValue()));
                double d = StColorValue._GetBrightness((Color)color);
                return new Double(Math.sqrt(Math.pow(d, 2.0) + Math.pow(((Number)object3).doubleValue() / 3.0, 2.0)));
            }
        }, 0.5, -1, new StInterval(0.0, (double)(stImage.width() - 1), 2.0), new StInterval(1.0, (double)stImage.height(), 2.0), new StInterval(-4.0, 4.0, 2.0), new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                if (collection.size() != stValueHolder._intValue()) {
                    stBlockClosure.value_((Object)collection);
                    stValueHolder.value_(collection.size());
                }
                return null;
            }
        });
        return true;
    }

    public static boolean Example3D_ImageLandscape() {
        final StImage stImage = StImage._OfArea((Rectangle)new Rectangle(0, 0, 100, 100));
        int n = stImage.width();
        int n2 = stImage.height();
        final double d = Math.min(n, n2) / 4;
        final JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        HashMap<StSymbol, Jun3dPoint> hashMap = new HashMap<StSymbol, Jun3dPoint>();
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"eyePoint"), new Jun3dPoint(n / 2, -n2, n2 * 2));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"sightPoint"), new Jun3dPoint(n / 2, n2 / 2, d / 2.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"upVector"), new Jun3dPoint(0.0, 1.0, 0.0));
        junOpenGLDisplayModel.defaultProjectionTable_(hashMap);
        junOpenGLDisplayModel.open();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                final Jun3dPolygon[] jun3dPolygonArray = collection.toArray(new Jun3dPolygon[collection.size()]);
                junOpenGLDisplayModel.do_forMilliseconds_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
                            junOpenGL3dCompoundObject.add_(jun3dPolygonArray[i].asJunOpenGL3dObjectColor_(Color.red));
                        }
                        junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                        junOpenGLDisplayModel.resetView();
                        return null;
                    }
                }, 1000);
                return null;
            }
        };
        final StValueHolder stValueHolder = new StValueHolder(0);
        JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Point point = new Point(((Number)object).intValue() - 1, stImage.height() - ((Number)object2).intValue());
                Color color = stImage.valueAtPoint_(point);
                double d2 = StColorValue._GetBrightness((Color)color);
                return new Double(d2 * d - ((Number)object3).doubleValue());
            }
        }, 0.0, 1, new StInterval(1.0, (double)n, 1.0), new StInterval(1.0, (double)n2, 1.0), new StInterval(d / -4.0, d * 5.0 / 4.0, d / 4.0), new StBlockClosure(){

            public Object value_(Object object) {
                Collection collection = (Collection)object;
                if (collection.size() != stValueHolder._intValue()) {
                    stBlockClosure.value_((Object)collection);
                    stValueHolder.value_(collection.size());
                }
                return null;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example3D_Text() {
        String string = JunDialog.Request_(JunSystem.$String((String)"Type in your favorite phrase."), JunSystem.$String((String)"Be free!"));
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = JunDialog.Request_(JunSystem.$String((String)"Enter weight of the font.") + " (0.1 .. 0.9)", "0.5");
        if (string2 == null) {
            return false;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        d = Math.max(0.1, Math.min(d, 0.9));
        Font font = StComposedText.DefaultFont();
        Dimension dimension = new StComposedText(string, font).extent();
        final JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        HashMap<StSymbol, Jun3dPoint> hashMap = new HashMap<StSymbol, Jun3dPoint>();
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"eyePoint"), new Jun3dPoint(dimension.getWidth() / 2.0, dimension.getHeight() / 2.0, 100.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"sightPoint"), new Jun3dPoint(dimension.getWidth() / 2.0, dimension.getHeight() / 2.0, 0.0));
        hashMap.put(JunBorderGeneratorTestExamples.$((String)"upVector"), new Jun3dPoint(0.0, 1.0, 0.0));
        junOpenGLDisplayModel.defaultProjectionTable_(hashMap);
        junOpenGLDisplayModel.open();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                Collection collection = (Collection)object;
                final Jun3dPolygon[] jun3dPolygonArray = collection.toArray(new Jun3dPolygon[collection.size()]);
                final int n = ((StValueHolder)object2)._intValue();
                junOpenGLDisplayModel.do_forMilliseconds_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)junOpenGLDisplayModel.displayObject();
                        if (junOpenGL3dCompoundObject == null) {
                            junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
                        }
                        for (int i = 0; i < jun3dPolygonArray.length; ++i) {
                            junOpenGL3dCompoundObject.add_(jun3dPolygonArray[i].asJunOpenGL3dObjectColor_(Color.magenta).translatedBy_(new Jun3dPoint(n, 0.0, 0.0)));
                        }
                        junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                        junOpenGLDisplayModel.resetView();
                        return null;
                    }
                }, 500);
                return null;
            }
        };
        final StValueHolder stValueHolder = new StValueHolder(0);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            final StValueHolder stValueHolder2 = new StValueHolder(0);
            StComposedText stComposedText = new StComposedText(String.valueOf(cArray[i]), font);
            final StImage stImage = new StImage(stComposedText.extent());
            Graphics graphics = null;
            try {
                graphics = stImage.image().getGraphics();
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, stImage.width(), stImage.height());
                graphics.setColor(Color.white);
                stComposedText.displayOn_(graphics);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
            JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure(){

                public Object value_value_value_(Object object, Object object2, Object object3) {
                    Point point = new Point(((Number)object).intValue(), stImage.height() - ((Number)object2).intValue());
                    double d = 1.0f - StColorValue._GetBrightness((Color)stImage.valueAtPoint_(point));
                    return new Double(Math.sqrt(Math.pow(d, 2.0) + Math.pow(((Number)object3).doubleValue(), 2.0)));
                }
            }, d, -1, new StInterval(0.0, (double)(stImage.width() - 1)), new StInterval(1.0, (double)stImage.height()), new StInterval(-1.0, 1.0), new StBlockClosure(){

                public Object value_(Object object) {
                    Collection collection = (Collection)object;
                    if (collection.size() != stValueHolder2._intValue()) {
                        stBlockClosure.value_value_((Object)collection, (Object)stValueHolder);
                    }
                    return null;
                }
            });
            stValueHolder.value_(stValueHolder._intValue() + stImage.width());
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        new JunBorderGeneratorTestExamples();
    }
}

