/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boundaries;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBall;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBalls;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBoxes;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun2dBoundingBall
extends JunBoundingBall {
    public Jun2dBoundingBall(Jun2dPoint jun2dPoint, double d) {
        this.center_(jun2dPoint);
        this.radius_(d);
    }

    public Jun2dBoundingBall(Jun2dPoint[] jun2dPointArray) {
        if (jun2dPointArray == null || jun2dPointArray.length == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            d += jun2dPointArray[i].x();
            d2 += jun2dPointArray[i].y();
        }
        Jun2dPoint jun2dPoint = new Jun2dPoint(d / (double)jun2dPointArray.length, d2 / (double)jun2dPointArray.length);
        double d3 = 0.0;
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d4 = jun2dPoint.distance_(jun2dPointArray[i]);
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        this.center_(jun2dPoint);
        this.radius_(d3);
    }

    protected void initialize() {
        super.initialize();
        this.center = Jun2dPoint.Zero();
    }

    public Jun2dPoint center() {
        return (Jun2dPoint)this._center();
    }

    public void center_(Jun2dPoint jun2dPoint) {
        this._center(jun2dPoint);
    }

    public double area() {
        return Math.PI * Math.pow(this.radius(), 2.0);
    }

    public double depth() {
        throw SmalltalkException.ShouldNotImplement();
    }

    public Jun2dBoundingBall boundingBall() {
        return this;
    }

    public Jun2dBoundingBox boundingBox() {
        return Jun2dBoundingBox.Origin_extent_(this.center(), Jun2dPoint.Zero()).expandedBy_(this.radius());
    }

    protected JunBoundingBox _boundingBox() {
        return this.boundingBox();
    }

    public Jun2dBoundingBalls detailedBoundingBalls() {
        return this.tetraBoundingBalls();
    }

    public Jun2dBoundingBoxes detailedBoundingBoxes() {
        return this.tetraBoundingBoxes();
    }

    public Jun2dBoundingBalls tetraBoundingBalls() {
        Jun2dBoundingBalls jun2dBoundingBalls = new Jun2dBoundingBalls();
        jun2dBoundingBalls.addAll_(this.boundingBox().tetraBoundingBalls());
        return jun2dBoundingBalls;
    }

    public Jun2dBoundingBoxes tetraBoundingBoxes() {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        jun2dBoundingBoxes.addAll_(this.boundingBox().tetraBoundingBoxes());
        return jun2dBoundingBoxes;
    }

    public void add_(Jun2dPoint jun2dPoint) {
        if (this.center().distance_(jun2dPoint) > this.radius()) {
            Jun2dBoundingBall jun2dBoundingBall = this.merge_(new Jun2dBoundingBall(jun2dPoint, 0.0));
            this.center_(jun2dBoundingBall.center());
            this.radius_(jun2dBoundingBall.radius());
        }
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.PieFrom_to_by_radius_(0.0, 360.0, 10.0, this.radius()).translatedBy_(new Jun3dPoint(this.center().x(), this.center().y(), 0.0));
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject.reversed());
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        junOpenGL3dCompoundObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_alpha_(Jun2dBoundingBall.this.defaultColor(), Jun2dBoundingBall.this.defaultAlpha());
                return null;
            }
        });
        return junOpenGL3dCompoundObject;
    }

    public Jun2dBoundingBall expandedBy_(double d) {
        return new Jun2dBoundingBall(this.center(), this.radius() + d);
    }

    public Jun2dBoundingBall insetBy_(double d) {
        return new Jun2dBoundingBall(this.center(), this.radius() - d);
    }

    public Jun2dBoundingBall merge_(Jun2dBoundingBall jun2dBoundingBall) {
        double d = this.center().distance_(jun2dBoundingBall.center());
        if (d + jun2dBoundingBall.radius() < this.radius()) {
            return (Jun2dBoundingBall)this.copy();
        }
        if (d + this.radius() < jun2dBoundingBall.radius()) {
            return (Jun2dBoundingBall)jun2dBoundingBall.copy();
        }
        Jun2dLine jun2dLine = new Jun2dLine(this.center(), jun2dBoundingBall.center());
        Jun2dPoint jun2dPoint = jun2dLine.atT_(0.0 - this.radius() / d);
        Jun2dPoint jun2dPoint2 = jun2dLine.atT_(1.0 + jun2dBoundingBall.radius() / d);
        return new Jun2dBoundingBall(jun2dPoint.center_(jun2dPoint2), jun2dPoint.distance_(jun2dPoint2) / 2.0);
    }

    public boolean contains_(Jun2dBoundingBall jun2dBoundingBall) {
        double d = this.center().distance_(jun2dBoundingBall.center());
        return d <= this.radius() && d + jun2dBoundingBall.radius() <= this.radius();
    }

    public boolean containsPoint_(Jun2dPoint jun2dPoint) {
        return this.center().distance_(jun2dPoint) <= this.radius() || this.touchesPoint_(jun2dPoint);
    }

    public boolean intersects_(Jun2dBoundingBall jun2dBoundingBall) {
        return this.center().distance_(jun2dBoundingBall.center()) <= this.radius() + jun2dBoundingBall.radius();
    }

    public boolean touchesPoint_(Jun2dPoint jun2dPoint) {
        double d = this.center().distance_(jun2dPoint);
        return this.isEqualNumber_to_(d, this.radius());
    }

    public boolean is2d() {
        return true;
    }

    public boolean touches_(Jun2dBoundingBall jun2dBoundingBall) {
        if (this.isEqualPoint_to_(this.center(), jun2dBoundingBall.center()) && this.isEqualNumber_to_(this.radius(), jun2dBoundingBall.radius())) {
            return true;
        }
        double d = this.center().distance_(jun2dBoundingBall.center());
        if (d <= this.radius()) {
            return this.isEqualNumber_to_(this.radius(), d + jun2dBoundingBall.radius());
        }
        if (d <= jun2dBoundingBall.radius()) {
            return this.isEqualNumber_to_(jun2dBoundingBall.radius(), d + this.radius());
        }
        return this.isEqualNumber_to_(d, this.radius() + jun2dBoundingBall.radius());
    }

    public JunGeometry transform_(JunTransformation junTransformation) {
        Jun2dLine jun2dLine = new Jun2dLine(this.center(), this.center().plus_(new Jun2dPoint(this.radius(), 0.0)));
        jun2dLine = (Jun2dLine)jun2dLine.transform_(junTransformation);
        return new Jun2dBoundingBall(jun2dLine.from(), jun2dLine.from().distance_(jun2dLine.to()));
    }

    public Jun2dBoundingBall rounded() {
        return new Jun2dBoundingBall(this.center().rounded(), Math.round(this.radius()));
    }

    public Jun2dBoundingBall truncated() {
        double d = this.radius() >= 0.0 ? Math.ceil(this.radius()) : Math.floor(this.radius());
        return new Jun2dBoundingBall(this.center().truncated(), d);
    }
}

