/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.basic;

import java.awt.Point;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.JunPlane;

public abstract class JunPoint
extends JunGeometry {
    public static Point[] NeighborhoodPoints_(Point point) {
        return JunPoint.Neighborhood8Points_(point);
    }

    public static Point[] Neighborhood4Points_(Point point) {
        return new Point[]{new Point(point.x + 1, point.y + 0), new Point(point.x + 0, point.y + 1), new Point(point.x - 1, point.y + 0), new Point(point.x + 0, point.y - 1)};
    }

    public static Point[] Neighborhood8Points_(Point point) {
        return new Point[]{new Point(point.x + 1, point.y + 0), new Point(point.x + 1, point.y + 1), new Point(point.x + 0, point.y + 1), new Point(point.x - 1, point.y + 1), new Point(point.x - 1, point.y + 0), new Point(point.x - 1, point.y - 1), new Point(point.x + 0, point.y - 1), new Point(point.x + 1, point.y - 1)};
    }

    public static Point[] Neighborhood24Points_(Point point) {
        ArrayList<Point> arrayList = new ArrayList<Point>(24);
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (j == 0 && i == 0) continue;
                arrayList.add(new Point(point.x + j, point.y + i));
            }
        }
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    public abstract double x();

    public abstract double y();

    public abstract JunPoint plus_(JunPoint var1);

    public abstract int generality();

    public double r() {
        return this.rho();
    }

    public abstract Jun2dPoint as2dPoint();

    public abstract Jun3dPoint as3dPoint();

    public abstract double[] asArray();

    public Point asPoint() {
        return new Point((int)Math.round(this.x()), (int)Math.round(this.y()));
    }

    public double length() {
        return this.rho();
    }

    public JunPlane plane_(JunPoint junPoint) {
        return JunPlane.On_normalVector_(this, junPoint);
    }

    public JunPlane plane_and_(JunPoint junPoint, JunPoint junPoint2) {
        return new JunPlane(this, junPoint, junPoint2);
    }

    public abstract int hashCode();

    public abstract double rho();

    public boolean isPoint() {
        return true;
    }

    public abstract boolean isZero();

    public abstract boolean negative();

    public abstract boolean positive();

    public int whichSideOf_(JunPlane junPlane) {
        return junPlane.whichSide_(this);
    }
}

