/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.basic;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;

public class Jun3dPoint
extends JunPoint {
    protected double x;
    protected double y;
    protected double z;

    public static Jun3dPoint Coerce_(JunPoint junPoint) {
        double d = junPoint instanceof Jun3dPoint ? ((Jun3dPoint)junPoint).z() : 0.0;
        return new Jun3dPoint(junPoint.x(), junPoint.y(), d);
    }

    public static Jun3dPoint Coerce_(double d) {
        return new Jun3dPoint(d, d, d);
    }

    public static Jun3dPoint Unity() {
        return new Jun3dPoint(1.0, 1.0, 1.0);
    }

    public static Jun3dPoint Zero() {
        return new Jun3dPoint(0.0, 0.0, 0.0);
    }

    public Jun3dPoint(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Jun3dPoint(Number number, Number number2, Number number3) {
        this(number.doubleValue(), number2.doubleValue(), number3.doubleValue());
    }

    public Jun3dPoint(Jun2dPoint jun2dPoint, double d) {
        this(jun2dPoint.x, jun2dPoint.y, d);
    }

    public Jun3dPoint(Jun2dPoint jun2dPoint, Number number) {
        this(jun2dPoint, number.doubleValue());
    }

    public Jun3dPoint(JunPoint junPoint) {
        this(junPoint.x(), junPoint.y(), junPoint instanceof Jun3dPoint ? ((Jun3dPoint)junPoint).z() : 0.0);
    }

    public static Jun3dPoint FromArray_(double[] dArray) {
        return new Jun3dPoint(dArray[0], dArray[1], dArray[2]);
    }

    public static Jun3dPoint FromPoint_(JunPoint junPoint) {
        return new Jun3dPoint(junPoint);
    }

    public Jun3dBoundingBox boundingBox() {
        return this.asBoundingBox();
    }

    public Jun3dPoint normalUnitVector() {
        return this.unitVector();
    }

    public Jun3dPoint normalVector() {
        return this;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Jun3dPoint abs() {
        return new Jun3dPoint(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public Jun3dPoint dividedBy_(double d) {
        return new Jun3dPoint(this.x / d, this.y / d, this.z / d);
    }

    public Jun3dPoint dividedBy_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(this.x / jun3dPoint.x, this.y / jun3dPoint.y, this.z / jun3dPoint.z);
    }

    public Jun3dPoint minus_(double d) {
        return new Jun3dPoint(this.x - d, this.y - d, this.z - d);
    }

    public Jun3dPoint minus_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(this.x - jun3dPoint.x, this.y - jun3dPoint.y, this.z - jun3dPoint.z);
    }

    public Jun3dPoint multipliedBy_(double d) {
        return new Jun3dPoint(this.x * d, this.y * d, this.z * d);
    }

    public Jun3dPoint multipliedBy_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(this.x * jun3dPoint.x, this.y * jun3dPoint.y, this.z * jun3dPoint.z);
    }

    public Jun3dPoint negated() {
        return Jun3dPoint.Zero().minus_(this);
    }

    public Jun3dPoint plus_(double d) {
        return new Jun3dPoint(this.x + d, this.y + d, this.z + d);
    }

    public JunPoint plus_(JunPoint junPoint) {
        if (junPoint instanceof Jun3dPoint) {
            return this.plus_((Jun3dPoint)junPoint);
        }
        return this.plus_(Jun3dPoint.Coerce_(junPoint));
    }

    public Jun3dPoint plus_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(this.x + jun3dPoint.x, this.y + jun3dPoint.y, this.z + jun3dPoint.z);
    }

    public Jun3dPoint reciprocal() {
        return Jun3dPoint.Unity().dividedBy_(this);
    }

    public int generality() {
        return 220;
    }

    public boolean equal_(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
        return this.isEqualNumber_to_(this.x, jun3dPoint.x) && this.isEqualNumber_to_(this.y, jun3dPoint.y) && this.isEqualNumber_to_(this.z, jun3dPoint.z);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
        return this.x == jun3dPoint.x && this.y == jun3dPoint.y && this.z == jun3dPoint.z;
    }

    public boolean isGreaterThan_(Jun3dPoint jun3dPoint) {
        return this.x > jun3dPoint.x && this.y > jun3dPoint.y && this.z > jun3dPoint.z;
    }

    public boolean isGreaterThanOrEqualTo_(Jun3dPoint jun3dPoint) {
        return this.x >= jun3dPoint.x && this.y >= jun3dPoint.y && this.z >= jun3dPoint.z;
    }

    public boolean isLessThan_(Jun3dPoint jun3dPoint) {
        return this.x < jun3dPoint.x && this.y < jun3dPoint.y && this.z < jun3dPoint.z;
    }

    public boolean isLessThanOrEqualTo_(Jun3dPoint jun3dPoint) {
        return this.x <= jun3dPoint.x && this.y <= jun3dPoint.y && this.z <= jun3dPoint.z;
    }

    public Jun3dPoint max_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(Math.max(this.x, jun3dPoint.x), Math.max(this.y, jun3dPoint.y), Math.max(this.z, jun3dPoint.z));
    }

    public Jun3dPoint min_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(Math.min(this.x, jun3dPoint.x), Math.min(this.y, jun3dPoint.y), Math.min(this.z, jun3dPoint.z));
    }

    public Jun3dBoundingBox extent_(Jun3dPoint jun3dPoint) {
        return Jun3dBoundingBox.Origin_extent_(this, jun3dPoint);
    }

    public Jun2dPoint as2dPoint() {
        return new Jun2dPoint(this.x(), this.y());
    }

    public Jun3dPoint as3dPoint() {
        return this;
    }

    public double[] asArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public Jun3dBoundingBox asBoundingBox() {
        return Jun3dBoundingBox.Origin_corner_(this, this);
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dVertex junOpenGL3dVertex = new JunOpenGL3dVertex(this);
        junOpenGL3dVertex.size_(5.0f);
        junOpenGL3dVertex.paint_(this.defaultColor());
        return junOpenGL3dVertex;
    }

    public Jun3dPoint differenceFromPoint_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(jun3dPoint.x - this.x, jun3dPoint.y - this.y, jun3dPoint.z - this.z);
    }

    public boolean equalFromPoint_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(jun3dPoint);
        return jun3dPoint2.x == this.x && jun3dPoint2.y == this.y && jun3dPoint2.z == this.z;
    }

    public Jun3dPoint productFromPoint_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(jun3dPoint);
        return new Jun3dPoint(jun3dPoint2.x * this.x, jun3dPoint2.y * this.y, jun3dPoint2.z * this.z);
    }

    public Jun3dPoint quoFromInteger_(int n) {
        return new Jun3dPoint((double)n / this.x, (double)n / this.y, (double)n / this.z).truncated();
    }

    public Jun3dPoint quotientFromPoint_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(jun3dPoint);
        return new Jun3dPoint(jun3dPoint2.x / this.x, jun3dPoint2.y / this.y, jun3dPoint2.z / this.z);
    }

    public Jun3dPoint sumFromPoint_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(jun3dPoint);
        return new Jun3dPoint(jun3dPoint2.x + this.x, jun3dPoint2.y + this.y, jun3dPoint2.z + this.z);
    }

    public Jun3dBoundingBall ball_(double d) {
        return new Jun3dBoundingBall(this, d);
    }

    public JunPlane bisector_(Jun3dPoint jun3dPoint) {
        return JunPlane.Between_and_(this, jun3dPoint);
    }

    public Jun3dBoundingBox box_(Jun3dPoint jun3dPoint) {
        return Jun3dBoundingBox.Vertex_vertex_(this, jun3dPoint);
    }

    public Jun3dPoint center_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(jun3dPoint);
        return this.plus_(jun3dPoint2.minus_(this).dividedBy_(2.0));
    }

    public Jun3dBoundingBox corner_(Jun3dPoint jun3dPoint) {
        return Jun3dBoundingBox.Origin_corner_(this, jun3dPoint);
    }

    public double distance_(Jun3dPoint jun3dPoint) {
        return this.minus_(jun3dPoint).rho();
    }

    public double dotProduct_(Jun3dPoint jun3dPoint) {
        Jun3dPoint jun3dPoint2 = this.multipliedBy_(jun3dPoint);
        return jun3dPoint2.x + jun3dPoint2.y + jun3dPoint2.z;
    }

    public Jun3dLine from_(JunPoint junPoint) {
        return new Jun3dLine(junPoint, this);
    }

    public double innerProduct_(Jun3dPoint jun3dPoint) {
        return this.dotProduct_(jun3dPoint);
    }

    public Jun3dPoint intersectingPointWithLine_(Jun3dLine jun3dLine) {
        if (jun3dLine.containsPoint_(this)) {
            return this;
        }
        return null;
    }

    public Jun3dPoint length_(double d) {
        double d2 = this.length();
        if (d2 <= 1.0E-12) {
            return this;
        }
        return this.multipliedBy_(d / d2);
    }

    public Jun3dPoint outerProduct_(Jun3dPoint jun3dPoint) {
        return this.outerProduct_(jun3dPoint);
    }

    public Jun3dPolyline polyline_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return new Jun3dPolyline(new Jun3dPoint[]{this, jun3dPoint, jun3dPoint2});
    }

    public Jun3dPolyline polyline_with_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        return new Jun3dPolyline(new Jun3dPoint[]{this, jun3dPoint, jun3dPoint2, jun3dPoint3});
    }

    public Jun3dPolyline polyline_with_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Jun3dPoint jun3dPoint4) {
        return new Jun3dPolyline(new Jun3dPoint[]{this, jun3dPoint, jun3dPoint2, jun3dPoint3, jun3dPoint4});
    }

    public Jun3dPoint product_(Jun3dPoint jun3dPoint) {
        return this.vectorProduct_(jun3dPoint);
    }

    public Jun3dLine to_(JunPoint junPoint) {
        return new Jun3dLine(this, junPoint);
    }

    public Jun3dTriangle triangle_and_(JunPoint junPoint, JunPoint junPoint2) {
        return Jun3dTriangle.On_on_on_(this, junPoint, junPoint2);
    }

    public Jun3dPoint unitVector() {
        return this.length_(1.0);
    }

    public Jun3dPoint vectorProduct_(Jun3dPoint jun3dPoint) {
        return new Jun3dPoint(this.y * jun3dPoint.z - this.z * jun3dPoint.y, this.z * jun3dPoint.x - this.x * jun3dPoint.z, this.x * jun3dPoint.y - this.y * jun3dPoint.x);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        int n = (int)(l ^ l >> 32);
        long l2 = Double.doubleToLongBits(this.y);
        int n2 = (int)(l2 ^ l2 >> 32);
        long l3 = Double.doubleToLongBits(this.z);
        int n3 = (int)(l3 ^ l3 >> 32);
        return (n >> 2 | n2) >> 2 | n3;
    }

    public double phi() {
        if (this.x == 0.0) {
            if (this.y == 0.0) {
                return JunAngle.Zero().rad();
            }
            if (this.y >= 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        JunAngle junAngle = JunAngle.FromRad_(Math.atan(this.y / this.x));
        if (this.x >= 0.0) {
            if (this.y >= 0.0) {
                return junAngle.rad();
            }
            return Math.PI * 2 + junAngle.rad();
        }
        return Math.PI + junAngle.rad();
    }

    public double rho() {
        return Math.sqrt(this.dotProduct_(this));
    }

    public double theta() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        if (this.z == 0.0) {
            if (d == 0.0) {
                return JunAngle.Zero().rad();
            }
            return 1.5707963267948966;
        }
        JunAngle junAngle = JunAngle.FromRad_(Math.atan(d / this.z));
        if (this.z >= 0.0) {
            return junAngle.rad();
        }
        return Math.PI + junAngle.rad();
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(String.valueOf(this.x));
        writer.write(" , ");
        writer.write(String.valueOf(this.y));
        writer.write(" , ");
        writer.write(String.valueOf(this.z));
        writer.write(41);
    }

    public boolean is3d() {
        return true;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean negative() {
        return this.isLessThan_(Jun3dPoint.Zero());
    }

    public boolean positive() {
        return this.isGreaterThanOrEqualTo_(Jun3dPoint.Zero());
    }

    public Jun3dPoint rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun3dTransformation.Rotate_(junAngle));
    }

    public Jun3dPoint scaledBy_(double d) {
        return this.transform_(Jun3dTransformation.Scale_(d));
    }

    public Jun3dPoint scaledBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Scale_(jun3dPoint));
    }

    public Jun3dPoint transform_(Jun3dTransformation jun3dTransformation) {
        return jun3dTransformation.applyToPoint_(this);
    }

    public Jun3dTransformation transformationToScale() {
        return Jun3dTransformation.Scale_(this);
    }

    public Jun3dTransformation transformationToTranslate() {
        return Jun3dTransformation.Translate_(this);
    }

    public Jun3dPoint translatedBy_(double d) {
        return this.transform_(Jun3dTransformation.Translate_(d));
    }

    public Jun3dPoint translatedBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Translate_(jun3dPoint));
    }

    public Jun3dPoint ceiling() {
        return new Jun3dPoint(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Jun3dPoint floor() {
        return new Jun3dPoint(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Jun3dPoint rounded() {
        return new Jun3dPoint(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Jun3dPoint roundTo_(double d) {
        return this.dividedBy_(d).rounded().multipliedBy_(d);
    }

    public Jun3dPoint roundTo_(Jun3dPoint jun3dPoint) {
        return this.dividedBy_(jun3dPoint).rounded().multipliedBy_(jun3dPoint);
    }

    public Jun3dPoint truncated() {
        double d = this.x >= 0.0 ? Math.ceil(this.x) : Math.floor(this.x);
        double d2 = this.y >= 0.0 ? Math.ceil(this.y) : Math.floor(this.y);
        double d3 = this.z >= 0.0 ? Math.ceil(this.z) : Math.floor(this.z);
        return new Jun3dPoint(d, d2, d3);
    }
}

