/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.dxf.support;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeSet;
import jp.co.sra.jun.dxf.support.JunDXFParser;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayView;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunCADModel
extends JunOpenGLDisplayModel {
    protected HashMap layerNames;
    protected ArrayList hiddenObjects;
    protected StMenu _layersMenu;

    protected void initialize() {
        super.initialize();
        this.layerNames = null;
        this.hiddenObjects = null;
        this._layersMenu = null;
    }

    public HashMap layerNames() {
        return this.layerNames;
    }

    public void layerNames_(HashMap hashMap) {
        this.layerNames = hashMap;
    }

    public String[] layerNameStrings() {
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
        treeSet.addAll(this.layerNames().keySet());
        return treeSet.toArray(new String[treeSet.size()]);
    }

    protected ArrayList hiddenObjects() {
        if (this.hiddenObjects == null) {
            this.hiddenObjects = new ArrayList();
        }
        return this.hiddenObjects;
    }

    public JunOpenGLProjector displayProjector() {
        if (this.openGLProjector == null) {
            this.openGLProjector = new JunOpenGLProjector();
            this.openGLProjector.projection_(this.openGLProjector.projection().asParallelProjection());
            this.openGLProjector.eyePoint_(this.defaultEyePoint());
            this.openGLProjector.sightPoint_(this.defaultSightPoint());
            this.openGLProjector.upVector_(this.defaultUpVector());
            this.openGLProjector.viewFactor_(this.defaultViewFactor());
        }
        return this.openGLProjector;
    }

    public Jun3dPoint defaultEyePoint() {
        if (this.openGL3dObject() == null) {
            return new Jun3dPoint(0.0, 0.0, 10000.0);
        }
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)this.defaultProjectionTable().get(JunCADModel.$((String)"eyePoint")));
        if (jun3dPoint == null) {
            Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
            double d = jun3dBoundingBox.depth();
            d = Math.max(d * 2.0, 10000.0);
            jun3dPoint = this.defaultSightPoint().plus_(new Jun3dPoint(0.0, 0.0, d));
        }
        return jun3dPoint;
    }

    public Jun3dPoint defaultUpVector() {
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)this.defaultProjectionTable().get(JunCADModel.$((String)"upVector")));
        if (jun3dPoint == null) {
            jun3dPoint = new Jun3dPoint(0.0, 1.0, 0.0);
        }
        return jun3dPoint;
    }

    protected void setLayerNames_(Enumeration enumeration) {
        HashMap hashMap = new HashMap();
        while (enumeration.hasMoreElements()) {
            hashMap.put(enumeration.nextElement(), Boolean.TRUE);
        }
        this.layerNames_(hashMap);
    }

    protected void setLayerObjects_(Enumeration enumeration) {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        while (enumeration.hasMoreElements()) {
            junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)((Object)enumeration.nextElement()));
        }
        this.displayObject_(junOpenGL3dCompoundObject);
    }

    protected JunOpenGL3dObject layerAt_(String string) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = ((JunOpenGL3dCompoundObject)this.displayObject()).components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            if (!junOpenGL3dObjectArray[i].name().equals(string)) continue;
            return junOpenGL3dObjectArray[i];
        }
        return null;
    }

    protected JunOpenGL3dObject hiddenLayerAt_(String string) {
        ArrayList arrayList = this.hiddenObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)arrayList.get(i));
            if (!junOpenGL3dObject.name().equals(string)) continue;
            return junOpenGL3dObject;
        }
        return null;
    }

    protected void toggleLayerOn_(String string) {
        JunOpenGL3dObject junOpenGL3dObject = this.hiddenLayerAt_(string);
        if (junOpenGL3dObject != null) {
            this.hiddenObjects().remove((Object)junOpenGL3dObject);
            ((JunOpenGL3dCompoundObject)this.displayObject()).add_(junOpenGL3dObject);
            this.toggleLayerMenu_(string, true);
        }
    }

    protected void toggleLayerOff_(String string) {
        JunOpenGL3dObject junOpenGL3dObject = this.layerAt_(string);
        if (junOpenGL3dObject != null) {
            this.hiddenObjects().add(junOpenGL3dObject);
            ((JunOpenGL3dCompoundObject)this.displayObject()).remove_(junOpenGL3dObject);
            this.toggleLayerMenu_(string, false);
        }
    }

    protected void toggleLayerMenu_(String string, boolean bl) {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunCADModel.$((String)"layersMenu"));
        if (stMenu == null) {
            return;
        }
        StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)stMenu.atNameKey_(JunCADModel.$((String)string));
        if (stCheckBoxMenuItem != null) {
            stCheckBoxMenuItem.beSelected(bl);
        }
    }

    protected void toggleAllLayersOn() {
        String[] stringArray = this.layerNameStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            this.toggleLayerOn_(stringArray[i]);
        }
    }

    protected void toggleAllLayersOff() {
        String[] stringArray = this.layerNameStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            this.toggleLayerOff_(stringArray[i]);
        }
    }

    protected Hashtable readFromDXF_(File file) {
        if (file == null) {
            return null;
        }
        Hashtable hashtable = null;
        JunDXFParser junDXFParser = JunDXFParser.OnSmart_(file);
        if (junDXFParser.parsedOk()) {
            hashtable = junDXFParser.layers();
        }
        return hashtable;
    }

    public StView defaultView() {
        JunOpenGLDisplayView junOpenGLDisplayView = (JunOpenGLDisplayView)super.defaultView();
        junOpenGLDisplayView.getOpenGLDrawable().toComponent().setBackground(Color.black);
        return junOpenGLDisplayView;
    }

    protected String windowTitle() {
        return JunCADModel.$String((String)"DXF Viewer");
    }

    protected void addLayerMenuItems() {
        StMenu stMenu = new StMenu((Object)"Layers");
        String[] stringArray = this.layerNameStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            StCheckBoxMenuItem stCheckBoxMenuItem = new StCheckBoxMenuItem((Object)string, true, (MenuListener)new MenuPerformer((StObject)this, "toggleLayer_", (Object)string));
            stMenu.add((StMenuItem)stCheckBoxMenuItem);
        }
        ((StMenu)this._menuBar().atNameKey_(JunCADModel.$((String)"layersMenu"))).add((StMenuItem)stMenu);
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createEditMenu());
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createLightMenu());
            this._menuBar.add(this._createLayersMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createLayersMenu() {
        StMenu stMenu = new StMenu((Object)JunCADModel.$String((String)"Layer", (String)"Layers"), JunCADModel.$((String)"layersMenu"));
        stMenu.add(new StMenuItem((Object)JunCADModel.$String((String)"Show all"), (MenuListener)new MenuPerformer((StObject)this, "allLayersShow")));
        stMenu.add(new StMenuItem((Object)JunCADModel.$String((String)"Hide all"), (MenuListener)new MenuPerformer((StObject)this, "allLayersHide")));
        return stMenu;
    }

    public void openLST() {
        this.openDXF();
    }

    public void openDXF() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunCADModel.$String((String)"<1p> files", null, (Object)"DXF"), new String[]{"*.dxf", "*.DXF"})};
        File file = JunFileRequesterDialog.RequestFile(JunCADModel.$String((String)"Select a <1p> file.", null, (Object)"DXF"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        Hashtable hashtable = this.readFromDXF_(file);
        if (hashtable == null) {
            return;
        }
        this.setLayerNames_(hashtable.keys());
        this.setLayerObjects_(hashtable.elements());
        this.addLayerMenuItems();
        this.resetView();
        if (this.showModel() != null) {
            this.showModel().resetView();
        }
    }

    public void openParser_(JunDXFParser junDXFParser) {
        Hashtable hashtable = junDXFParser.layers();
        if (hashtable == null) {
            return;
        }
        this.setLayerNames_(hashtable.keys());
        this.setLayerObjects_(hashtable.elements());
        this.addLayerMenuItems();
        this.resetView();
        if (this.showModel() != null) {
            this.showModel().resetView();
        }
    }

    public void allLayersShow() {
        this.toggleAllLayersOn();
        this.changed_(JunCADModel.$((String)"object"));
    }

    public void allLayersHide() {
        this.toggleAllLayersOff();
        this.changed_(JunCADModel.$((String)"object"));
    }

    protected void toggleLayer_(String string) {
        JunOpenGL3dObject junOpenGL3dObject = this.layerAt_(string);
        if (junOpenGL3dObject == null) {
            this.toggleLayerOn_(string);
        } else {
            this.toggleLayerOff_(string);
        }
        this.changed_(JunCADModel.$((String)"object"));
    }
}

