/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.collections.sequences;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.collections.sequences.JunSequence;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;

public class JunMatrix
extends JunSequence {
    protected int rowSize;
    protected int columnSize;
    protected Object[][] _matrix;

    public JunMatrix() {
        this(0);
    }

    public JunMatrix(int n) {
        this(n, n);
    }

    public JunMatrix(int n, Object[] objectArray) {
        this(n);
        this.collection_(objectArray);
    }

    public JunMatrix(int n, int n2) {
        this.rowSize = n;
        this.columnSize = n2;
        this._matrix = new Object[this.rowSize][this.columnSize];
    }

    public JunMatrix(int n, int n2, Object[] objectArray) {
        this(n, n2);
        this.collection_(objectArray);
    }

    public Object _at(int n, int n2) {
        return this._matrix[n][n2];
    }

    public void _put(int n, int n2, Object object) {
        this._matrix[n][n2] = object;
    }

    public Object at_(int n) {
        return this.atPoint_(this.computeLocation_(n));
    }

    public void at_put_(int n, Object object) {
        this.atPoint_put_(this.computeLocation_(n), object);
    }

    public void atAllPut_(Object object) {
        for (int i = 0; i < this.rowSize(); ++i) {
            for (int j = 0; j < this.columnSize(); ++j) {
                this._put(i, j, object);
            }
        }
    }

    public Object atPoint_(Point point) {
        return this._at(point.x, point.y);
    }

    public void atPoint_put_(Point point, Object object) {
        this._put(point.x, point.y, object);
    }

    public Object[] basicAt_(int n) {
        return this.atRow_(n);
    }

    public void basicAt_put_(int n, Object[] objectArray) {
        this.atRow_put_(n, objectArray);
    }

    public void collection_(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                this._matrix[i][j] = objectArray[n];
                ++n;
            }
        }
    }

    public Point matrixSize() {
        return new Point(this.rowSize, this.columnSize);
    }

    public Object row_column_(int n, int n2) {
        return this._at(n, n2);
    }

    public void row_column_put_(int n, int n2, Object object) {
        this._put(n, n2, object);
    }

    public int size() {
        return this.columnSize() * this.rowSize();
    }

    public Object[] atColumn_(int n) {
        Object[] objectArray = new Object[this.rowSize];
        for (int i = 0; i < this.rowSize; ++i) {
            objectArray[i] = this._at(i, n);
        }
        return objectArray;
    }

    public void atColumn_put_(int n, Object[] objectArray) {
        for (int i = 0; i < this.rowSize(); ++i) {
            this._put(i, n, objectArray[i]);
        }
    }

    public int columnSize() {
        return this.columnSize;
    }

    public Object[] atRow_(int n) {
        Object[] objectArray = new Object[this.columnSize];
        for (int i = 0; i < this.columnSize; ++i) {
            objectArray[i] = this._at(n, i);
        }
        return objectArray;
    }

    public void atRow_put_(int n, Object[] objectArray) {
        for (int i = 0; i < this.columnSize(); ++i) {
            this._put(n, i, objectArray[i]);
        }
    }

    public int rowSize() {
        return this.rowSize;
    }

    public Object[] asArray() {
        Object[] objectArray = new Object[this.rowSize * this.columnSize];
        int n = 0;
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                objectArray[n] = this._at(i, j);
                ++n;
            }
        }
        return objectArray;
    }

    public StObject copy() {
        JunMatrix junMatrix = (JunMatrix)((Object)JunMatrix._New((Class)this.species(), (Object)new Integer(this.rowSize), (Object)new Integer(this.columnSize)));
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                junMatrix._put(i, j, this._at(i, j));
            }
        }
        return junMatrix;
    }

    public Object do_(final StBlockClosure stBlockClosure) {
        return this.doIJ_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                return stBlockClosure.value_(object);
            }
        });
    }

    public Object doIJ_(StBlockClosure stBlockClosure) {
        int n = this.rowSize();
        int n2 = this.columnSize();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = stBlockClosure.value_value_value_(this._matrix[i][j], (Object)new Integer(i), (Object)new Integer(j));
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public Object rowIndex_doJ_(int n, StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.columnSize; ++i) {
            Object object = stBlockClosure.value_value_(this._matrix[n][i], (Object)new Integer(i));
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public JunMatrix horizontalFlip() {
        int n = this.rowSize();
        int n2 = this.columnSize();
        JunMatrix junMatrix = (JunMatrix)((Object)JunMatrix._New(((Object)((Object)this)).getClass(), (Object[])new Object[]{new Integer(n), new Integer(n2)}));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                junMatrix.row_column_put_(i, n2 - j - 1, this._at(i, j));
            }
        }
        return junMatrix;
    }

    public JunMatrix mirror() {
        return this.horizontalFlip();
    }

    public JunMatrix transpose() {
        int n = this.rowSize();
        int n2 = this.columnSize();
        JunMatrix junMatrix = (JunMatrix)((Object)JunMatrix._New(((Object)((Object)this)).getClass(), (Object[])new Object[]{new Integer(n2), new Integer(n)}));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                junMatrix.row_column_put_(j, i, this._at(i, j));
            }
        }
        return junMatrix;
    }

    public JunMatrix upsideDown() {
        return this.horizontalFlip();
    }

    public JunMatrix verticalFlip() {
        int n = this.rowSize();
        int n2 = this.columnSize();
        JunMatrix junMatrix = (JunMatrix)((Object)JunMatrix._New(((Object)((Object)this)).getClass(), (Object[])new Object[]{new Integer(n), new Integer(n2)}));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                junMatrix.row_column_put_(n - i - 1, j, this._at(i, j));
            }
        }
        return junMatrix;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("Matrix (");
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                Object object = this._matrix[i][j];
                writer.write(object != null ? object.toString() : "null");
                if (j >= this.columnSize - 1) continue;
                writer.write(" ");
            }
            if (i >= this.rowSize - 1) continue;
            writer.write(" , ");
        }
        writer.write(")");
    }

    public boolean isSquare() {
        return this.rowSize() == this.columnSize();
    }

    public JunMatrix product_(JunMatrix junMatrix) {
        if (this.columnSize != junMatrix.rowSize) {
            throw SmalltalkException.Error((String)"my column size is not equal to your row size.");
        }
        JunMatrix junMatrix2 = (JunMatrix)((Object)JunMatrix._New((Class)this.species(), (Object)new Integer(this.rowSize), (Object)new Integer(junMatrix.columnSize)));
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < junMatrix.columnSize; ++j) {
                junMatrix2._put(i, j, this._calculateProductElementAt(i, j, junMatrix));
            }
        }
        return junMatrix2;
    }

    protected Object _calculateProductElementAt(int n, int n2, JunMatrix junMatrix) {
        throw new SmalltalkException("don't know how to calculate a product element.");
    }

    protected Point computeLocation_(int n) {
        return new Point(n / this.columnSize(), n % this.columnSize());
    }
}

