/*
 * HtmlReporterTest.java
 * JUnit based test
 *
 * Created on 16. juillet 2007, 15:21
 */

package org.jdiffchaser.publish;

import junit.framework.*;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.jdiffchaser.scenarihandling.TestSet;
import org.jdiffchaser.utils.ImageUtilities;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HtmlReporterTest extends TestCase {
    
    public HtmlReporterTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(HtmlReporterTest.class);
        
        return suite;
    }

    /**
     * Test of createMagnifyHtmlContent method, of class org.jdiffchaser.publish.HtmlReporter.
     */
    public void testCreateMagnifyHtmlContent() {
        System.out.println("createMagnifyHtmlContent");
        
        String scenarioName = "scenario one";
        String previousImgFilename = "image1.png";
        String currentImgFilename = "image2.png";
        String nextImgFilename = "diffs.png";
        
        String expResult = 
        "<html>"
        + "\n<title>"
        + "\nscenario one: image2.png"
        + "\n</title>"
        + "\n<body>"
        + "\n<center><a href=\"../../index.html\">back to report</a></center>"
        + "\n<center>scenario one: image2.png</center>"                  
        + "\n<table border=\"0\" width=\"100%\">"
        + "\n<tr>"
        + "\n<td><center><a href=\"image1.html\">Previous</a>&nbsp;&nbsp;<a href=\"diffs.html\">Next</a></center></td>"
        + "\n</tr>"
        + "\n<tr>"
        + "\n<td><center><img src=\"image2.png\" border=\"0\"></center></td>"
        + "\n</tr>"
        + "\n<tr>"
        + "\n<td><center><a href=\"image1.html\">Previous</a>&nbsp;&nbsp;<a href=\"diffs.html\">Next</a></center></td>"
        + "\n</tr>"
        + "\n</table>"
        + "\n</body>"
        + "\n</html>";  
        
        String result = HtmlReporter.createMagnifyHtmlContent(scenarioName, 
                                                              previousImgFilename, 
                                                              currentImgFilename, 
                                                              nextImgFilename);
        assertEquals(expResult, result);
        
        previousImgFilename = null;
        currentImgFilename = "image1.png";
        nextImgFilename = "image2.png";
        
        expResult = 
        "<html>"
        + "\n<title>"
        + "\nscenario one: image1.png"
        + "\n</title>"
        + "\n<body>"
        + "\n<center><a href=\"../../index.html\">back to report</a></center>"
        + "\n<center>scenario one: image1.png</center>"
        + "\n<table border=\"0\" width=\"100%\">"
        + "\n<tr>"
        + "\n<td><center>&nbsp;&nbsp;<a href=\"image2.html\">Next</a></center></td>"
        + "\n</tr>"
        + "\n<tr>"
        + "\n<td><center><img src=\"image1.png\" border=\"0\"></center></td>"
        + "\n</tr>"
        + "\n<tr>"
        + "\n<td><center>&nbsp;&nbsp;<a href=\"image2.html\">Next</a></center></td>"
        + "\n</tr>"
        + "\n</table>"
        + "\n</body>"
        + "\n</html>";  
        
        result = HtmlReporter.createMagnifyHtmlContent(scenarioName, 
                                                       previousImgFilename, 
                                                       currentImgFilename, 
                                                       nextImgFilename);
        assertEquals(expResult, result);
        
        
        previousImgFilename = "image2.png";
        currentImgFilename = "diffs.png";
        nextImgFilename = null;
        
        expResult = 
        "<html>"
        + "\n<title>"
        + "\nscenario one: diffs.png"
        + "\n</title>"
        + "\n<body>"
        + "\n<center><a href=\"../../index.html\">back to report</a></center>"
        + "\n<center>scenario one: diffs.png</center>"                
        + "\n<table border=\"0\" width=\"100%\">"
        + "\n<tr>"
        + "\n<td><center><a href=\"image2.html\">Previous</a>&nbsp;&nbsp;</center></td>"
        + "\n</tr>"
        + "\n<tr>"
        + "\n<td><center><img src=\"diffs.png\" border=\"0\"></center></td>"
        + "\n</tr>"
        + "\n<tr>"
        + "\n<td><center><a href=\"image2.html\">Previous</a>&nbsp;&nbsp;</center></td>"
        + "\n</tr>"
        + "\n</table>"
        + "\n</body>"
        + "\n</html>";  
        
        result = HtmlReporter.createMagnifyHtmlContent(scenarioName, 
                                                       previousImgFilename, 
                                                       currentImgFilename, 
                                                       nextImgFilename);
        assertEquals(expResult, result);        
    }
    
}
