/*
 * This file is part of jDiffChaser.
 *
 *  jDiffChaser is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  jDiffChaser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with jDiffChaser; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package org.jdiffchaser.scenarihandling;

import org.jdiffchaser.scenarihandling.events.ComparisonEvent;
import org.jdiffchaser.imgprocessing.Screenshot;
import org.jdiffchaser.imgprocessing.ScreenshotException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JScrollPane;



public class ComparisonDialog extends javax.swing.JDialog {
    
    private Component eventSource;
    private ComparisonEvent comparisonEvent;
    
    private static ComparisonDialog instance;
    
    private boolean fullScreen;
            
    private ScreenshotPanel screenshotPanel;
    private JScrollPane     scrollPane;
    
    /** Creates new form BeanForm */
    private ComparisonDialog(Component eventSource) {
        initComponents();
        this.setTitle("Screenshot that will be used for comparison");
        this.setModal(true);
        this.eventSource = eventSource;
        this.scrollPane = new JScrollPane();
        this.getContentPane().add(scrollPane, BorderLayout.CENTER);
        this.scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        this.scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(60);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(60);
    }
    
    public static synchronized ComparisonEvent show(Component eventSource, boolean fullScreen) throws ScreenshotException{
        if(instance==null){
            instance = new ComparisonDialog(eventSource);
        }else{
            instance.eventSource = eventSource;
        }
        instance.addScreenshotToDialog(eventSource, fullScreen);
        instance.pack();
        instance.setVisible(true);
        instance.setResizable(true);
        return instance.comparisonEvent;
    }
    
    private void addScreenshotToDialog(Component eventSource, boolean fullScreen) throws ScreenshotException{
        if(this.screenshotPanel!=null){
            this.scrollPane.getViewport().remove(this.screenshotPanel);
        }
        
        this.fullScreen = fullScreen;
        BufferedImage imgBuf = Screenshot.createScreenCapture(eventSource, fullScreen);

        this.screenshotPanel = new ScreenshotPanel(imgBuf, true);
        this.screenshotPanel.setPreferredSize(new Dimension(imgBuf.getWidth(), imgBuf.getHeight()));
        this.scrollPane.getViewport().add(screenshotPanel);        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        btOk = new javax.swing.JButton();
        btCancel = new javax.swing.JButton();

        jPanel1.setLayout(new java.awt.BorderLayout());

        btOk.setMnemonic('K');
        btOk.setText("Ok");
        btOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btOkActionPerformed(evt);
            }
        });

        jPanel2.add(btOk);

        btCancel.setMnemonic('C');
        btCancel.setText("Cancel");
        btCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btCancelActionPerformed(evt);
            }
        });

        jPanel2.add(btCancel);

        jPanel1.add(jPanel2, java.awt.BorderLayout.EAST);

        getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);

    }
    // </editor-fold>//GEN-END:initComponents

    private void btCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btCancelActionPerformed
        this.screenshotPanel.resetIgnoredAreas();
        this.comparisonEvent = null;
        this.setVisible(false);
    }//GEN-LAST:event_btCancelActionPerformed

    private void btOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btOkActionPerformed

        this.comparisonEvent = new ComparisonEvent(this.eventSource, 
                                                   Integer.MIN_VALUE, 
                                                   this.screenshotPanel.getIgnoredZones(),
                                                   this.fullScreen);
        this.setVisible(false);
        
    }//GEN-LAST:event_btOkActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btCancel;
    private javax.swing.JButton btOk;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    // End of variables declaration//GEN-END:variables
    
}
