/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.RMIExporter;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

public class RMIJRMPServerImpl
extends RMIServerImpl {
    private final int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private final Map env;

    public RMIJRMPServerImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Map env) throws IOException {
        super(env);
        if (port < 0) {
            throw new IllegalArgumentException("Negative port: " + port);
        }
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        this.env = env == null ? Collections.EMPTY_MAP : env;
    }

    protected void export() throws IOException {
        this.export(this);
    }

    private void export(Remote obj) throws RemoteException {
        RMIExporter exporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        if (exporter == null) {
            UnicastRemoteObject.exportObject(obj, this.port, this.csf, this.ssf);
        } else {
            exporter.exportObject(obj, this.port, this.csf, this.ssf);
        }
    }

    private void unexport(Remote obj, boolean force) throws NoSuchObjectException {
        RMIExporter exporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        if (exporter == null) {
            UnicastRemoteObject.unexportObject(obj, force);
        } else {
            exporter.unexportObject(obj, force);
        }
    }

    protected String getProtocol() {
        return "rmi";
    }

    public Remote toStub() throws IOException {
        return RemoteObject.toStub(this);
    }

    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl client = new RMIConnectionImpl(this, connectionId, this.getDefaultClassLoader(), subject, this.env);
        this.export(client);
        return client;
    }

    protected void closeClient(RMIConnection client) throws IOException {
        this.unexport(client, true);
    }

    protected void closeServer() throws IOException {
        this.unexport(this, true);
    }
}

