/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.examples.win32.W32API;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Rectangle;

public interface GDI32
extends W32API {
    public static final GDI32 INSTANCE = (GDI32)Native.loadLibrary("gdi32", 1.class$com$sun$jna$examples$win32$GDI32 == null ? (1.class$com$sun$jna$examples$win32$GDI32 = 1.class$("com.sun.jna.examples.win32.GDI32")) : 1.class$com$sun$jna$examples$win32$GDI32, DEFAULT_OPTIONS);
    public static final int RDH_RECTANGLES = 1;
    public static final int RGN_AND = 1;
    public static final int RGN_OR = 2;
    public static final int RGN_XOR = 3;
    public static final int RGN_DIFF = 4;
    public static final int RGN_COPY = 5;
    public static final int ERROR = 0;
    public static final int NULLREGION = 1;
    public static final int SIMPLEREGION = 2;
    public static final int COMPLEXREGION = 3;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    public static final int BI_JPEG = 4;
    public static final int BI_PNG = 5;
    public static final int DIB_RGB_COLORS = 0;
    public static final int DIB_PAL_COLORS = 1;

    public Pointer ExtCreateRegion(Pointer var1, int var2, RGNDATA var3);

    public int CombineRgn(Pointer var1, Pointer var2, Pointer var3, int var4);

    public Pointer CreateRectRgn(int var1, int var2, int var3, int var4);

    public Pointer CreateRoundRectRgn(int var1, int var2, int var3, int var4, int var5, int var6);

    public boolean SetRectRgn(Pointer var1, int var2, int var3, int var4, int var5);

    public int SetPixel(Pointer var1, int var2, int var3, int var4);

    public Pointer CreateCompatibleDC(Pointer var1);

    public boolean DeleteDC(Pointer var1);

    public Pointer CreateDIBitmap(Pointer var1, BITMAPINFOHEADER var2, int var3, Pointer var4, BITMAPINFO var5, int var6);

    public Pointer CreateDIBSection(Pointer var1, BITMAPINFO var2, int var3, PointerByReference var4, Pointer var5, int var6);

    public Pointer CreateCompatibleBitmap(Pointer var1, int var2, int var3);

    public Pointer SelectObject(Pointer var1, Pointer var2);

    public boolean DeleteObject(Pointer var1);

    static class 1 {
        static /* synthetic */ Class class$com$sun$jna$examples$win32$GDI32;
    }

    public static class BITMAPINFO
    extends Structure {
        public BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        int[] bmiColors = new int[1];

        public BITMAPINFO() {
            this(1);
        }

        public BITMAPINFO(int size) {
            this.bmiColors = new int[size];
            this.allocateMemory();
        }
    }

    public static class RGBQUAD
    extends Structure {
        public byte rgbBlue;
        public byte rgbGreen;
        public byte rgbRed;
        public byte rgbReserved = 0;
    }

    public static class BITMAPINFOHEADER
    extends Structure {
        public int biSize = this.size();
        public int biWidth;
        public int biHeight;
        public short biPlanes;
        public short biBitCount;
        public int biCompression;
        public int biSizeImage;
        public int biXPelsPerMeter;
        public int biYPelsPerMeter;
        public int biClrUsed;
        public int biClrImportant;
    }

    public static class RGNDATA
    extends Structure {
        public RGNDATAHEADER rdh;
        public byte[] Buffer;

        public RGNDATA(int bufferSize) {
            this.Buffer = new byte[bufferSize];
            this.allocateMemory();
        }
    }

    public static class RGNDATAHEADER
    extends Structure {
        public int dwSize = this.size();
        public int iType = 1;
        public int nCount;
        public int nRgnSize;
        public RECT rcBound;
    }

    public static class RECT
    extends Structure {
        public int left;
        public int top;
        public int right;
        public int bottom;

        public Rectangle toRectangle() {
            return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
        }

        public String toString() {
            return "[(" + this.left + "," + this.top + ")(" + this.right + "," + this.bottom + ")]";
        }
    }
}

