/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.Pointer;
import com.sun.jna.examples.win32.Kernel32;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class FileMonitor {
    public static final int FILE_CREATED = 1;
    public static final int FILE_DELETED = 2;
    public static final int FILE_MODIFIED = 4;
    public static final int FILE_ACCESSED = 8;
    public static final int FILE_NAME_CHANGED_OLD = 16;
    public static final int FILE_NAME_CHANGED_NEW = 32;
    public static final int FILE_RENAMED = 48;
    public static final int FILE_SIZE_CHANGED = 64;
    public static final int FILE_ATTRIBUTES_CHANGED = 128;
    public static final int FILE_SECURITY_CHANGED = 256;
    public static final int FILE_ANY = 511;
    private Map watched = new HashMap();
    private List listeners = new ArrayList();

    protected abstract void watch(File var1, int var2, boolean var3) throws IOException;

    protected abstract void unwatch(File var1);

    protected abstract void dispose();

    public void addWatch(File dir) throws IOException {
        this.addWatch(dir, 511);
    }

    public void addWatch(File dir, int mask) throws IOException {
        this.addWatch(dir, mask, dir.isDirectory());
    }

    public void addWatch(File dir, int mask, boolean recursive) throws IOException {
        this.watched.put(dir, new Integer(mask));
        this.watch(dir, mask, recursive);
    }

    public void removeWatch(File file) {
        if (this.watched.remove(file) != null) {
            this.unwatch(file);
        }
    }

    protected void notify(FileEvent e) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((FileListener)i.next()).fileChanged(e);
        }
    }

    public synchronized void addFileListener(FileListener x) {
        ArrayList<FileListener> list = new ArrayList<FileListener>(this.listeners);
        list.add(x);
        this.listeners = list;
    }

    public synchronized void removeFileListener(FileListener x) {
        ArrayList list = new ArrayList(this.listeners);
        list.remove(x);
        this.listeners = list;
    }

    protected void finalize() {
        Iterator i = this.watched.keySet().iterator();
        while (i.hasNext()) {
            this.removeWatch((File)i.next());
        }
        this.dispose();
    }

    public static FileMonitor getInstance() {
        return Holder.INSTANCE;
    }

    private static class INotifyFileMonitor
    extends FileMonitor {
        private INotifyFileMonitor() {
        }

        protected void watch(File file, int mask, boolean recursive) {
        }

        protected void unwatch(File file) {
        }

        protected void dispose() {
        }
    }

    private static class KQueueFileMonitor
    extends FileMonitor {
        private KQueueFileMonitor() {
        }

        protected void watch(File file, int mask, boolean recursive) {
        }

        protected void unwatch(File file) {
        }

        protected void dispose() {
        }
    }

    private static class W32FileMonitor
    extends FileMonitor {
        private static final int BUFFER_SIZE = 4096;
        private Thread watcher;
        private Pointer port;
        private Map fileMap = new HashMap();
        private Map handleMap = new HashMap();

        private W32FileMonitor() {
        }

        private void handleChanges(FileInfo finfo) throws IOException {
            Kernel32 klib = Kernel32.INSTANCE;
            Kernel32.FILE_NOTIFY_INFORMATION fni = finfo.info;
            fni.read();
            do {
                FileEvent event = null;
                File file = new File(finfo.file, fni.getFilename());
                switch (fni.Action) {
                    case 3: {
                        event = new FileEvent(file, 4);
                        break;
                    }
                    case 1: {
                        event = new FileEvent(file, 1);
                        break;
                    }
                    case 2: {
                        event = new FileEvent(file, 2);
                        break;
                    }
                    case 4: {
                        event = new FileEvent(file, 16);
                        break;
                    }
                    case 5: {
                        event = new FileEvent(file, 32);
                        break;
                    }
                    default: {
                        System.err.println("Unrecognized action: " + fni.Action);
                    }
                }
                if (event == null) continue;
                this.notify(event);
            } while ((fni = fni.next()) != null);
            if (!klib.ReadDirectoryChangesW(finfo.handle, finfo.info, finfo.info.size(), finfo.recursive, finfo.notifyMask, finfo.infoLength, finfo.overlapped, null)) {
                throw new IOException("ReadDirectoryChangesW failed on " + finfo.file + " (" + klib.GetLastError() + ")");
            }
        }

        private FileInfo waitForChange() {
            Kernel32 klib = Kernel32.INSTANCE;
            IntByReference rcount = new IntByReference();
            PointerByReference rkey = new PointerByReference();
            PointerByReference roverlap = new PointerByReference();
            klib.GetQueuedCompletionStatus(this.port, rcount, rkey, roverlap, -1);
            Pointer handle = rkey.getValue();
            return (FileInfo)this.handleMap.get(handle);
        }

        private int convertMask(int mask) {
            int result = 0;
            if ((mask & 1) != 0) {
                result |= 0x40;
            }
            if ((mask & 2) != 0) {
                result |= 0x40;
            }
            if ((mask & 4) != 0) {
                result |= 0x10;
            }
            if ((mask & 0x30) != 0) {
                result |= 3;
            }
            if ((mask & 0x40) != 0) {
                result |= 8;
            }
            if ((mask & 8) != 0) {
                result |= 0x20;
            }
            if ((mask & 0x80) != 0) {
                result |= 4;
            }
            if ((mask & 0x100) != 0) {
                result |= 0x100;
            }
            return result;
        }

        protected void watch(File file, int eventMask, boolean recursive) throws IOException {
            File dir = file;
            if (!dir.isDirectory()) {
                recursive = false;
                dir = file.getParentFile();
            }
            while (dir != null && !dir.exists()) {
                recursive = true;
                dir = dir.getParentFile();
            }
            if (dir == null) {
                throw new FileNotFoundException("No ancestor found for " + file);
            }
            Kernel32 klib = Kernel32.INSTANCE;
            int mask = 7;
            int flags = 0x42000000;
            Pointer handle = klib.CreateFile(file.getAbsolutePath(), 1, mask, null, 3, flags, null);
            if (Kernel32.INVALID_HANDLE_VALUE.equals(handle)) {
                throw new IOException("Unable to open " + file + " (" + klib.GetLastError() + ")");
            }
            int notifyMask = this.convertMask(eventMask);
            FileInfo finfo = new FileInfo(file, handle, notifyMask, recursive);
            this.fileMap.put(file, finfo);
            this.handleMap.put(handle, finfo);
            this.port = klib.CreateIoCompletionPort(handle, this.port, handle, 0);
            if (Kernel32.INVALID_HANDLE_VALUE.equals(this.port)) {
                throw new IOException("Unable to create I/O Completion port for " + file + " (" + klib.GetLastError() + ")");
            }
            if (!klib.ReadDirectoryChangesW(handle, finfo.info, finfo.info.size(), recursive, notifyMask, finfo.infoLength, finfo.overlapped, null)) {
                throw new IOException("ReadDirectoryChangesW failed on " + finfo.file + ":" + finfo.handle + " (" + klib.GetLastError() + ")");
            }
            if (this.watcher == null) {
                this.watcher = new Thread(this, "W32 File Monitor"){
                    private final /* synthetic */ W32FileMonitor this$0;
                    {
                        this.this$0 = this$0;
                        super(x0);
                    }

                    public void run() {
                        FileInfo finfo;
                        while ((finfo = W32FileMonitor.access$100(this.this$0)) != null) {
                            try {
                                W32FileMonitor.access$200(this.this$0, finfo);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                this.watcher.setDaemon(true);
                this.watcher.start();
            }
        }

        protected void unwatch(File file) {
            FileInfo finfo = (FileInfo)this.fileMap.remove(file);
            if (finfo != null) {
                this.handleMap.remove(finfo.handle);
                Kernel32 klib = Kernel32.INSTANCE;
                klib.CloseHandle(finfo.handle);
            }
        }

        protected void dispose() {
            Kernel32 klib = Kernel32.INSTANCE;
            klib.PostQueuedCompletionStatus(this.port, 0, null, null);
            klib.CloseHandle(this.port);
        }

        static /* synthetic */ FileInfo access$100(W32FileMonitor x0) {
            return x0.waitForChange();
        }

        static /* synthetic */ void access$200(W32FileMonitor x0, FileInfo x1) throws IOException {
            x0.handleChanges(x1);
        }

        private class FileInfo {
            public File file;
            public Pointer handle;
            public int notifyMask;
            public boolean recursive;
            public Kernel32.FILE_NOTIFY_INFORMATION info = new Kernel32.FILE_NOTIFY_INFORMATION(4096);
            public IntByReference infoLength = new IntByReference();
            public Kernel32.OVERLAPPED overlapped = new Kernel32.OVERLAPPED();

            public FileInfo(File f, Pointer h, int mask, boolean recurse) {
                this.file = f;
                this.handle = h;
                this.notifyMask = mask;
                this.recursive = recurse;
            }
        }
    }

    private static class Holder {
        public static final FileMonitor INSTANCE;

        private Holder() {
        }

        static {
            String os = System.getProperty("os.name");
            if (!os.startsWith("Windows")) {
                throw new Error("FileMonitor not implemented for " + os);
            }
            INSTANCE = new W32FileMonitor();
        }
    }

    public class FileEvent
    extends EventObject {
        private File file;
        private int type;

        public FileEvent(File file, int type) {
            super(FileMonitor.this);
            this.file = file;
            this.type = type;
        }

        public File getFile() {
            return this.file;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return "FileEvent: " + this.file + ":" + this.type;
        }
    }

    public static interface FileListener {
        public void fileChanged(FileEvent var1);
    }
}

