/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.types.XSListODMG30;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionInfoODMG30
extends CollectionInfo {
    public CollectionInfoODMG30(XSType contentType, String name, String elementName) {
        super(contentType, name, elementName);
        this.setSchemaType(new XSListODMG30(contentType));
        this.xsList = (XSListODMG30)this.getSchemaType();
    }

    public void generateInitializerCode(JSourceCode jsc) {
        jsc.add(this.getName());
        jsc.append(" = ODMG.getImplementation().newDArray();");
    }

    public void createAddMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append(this.getName());
            jsc.append(".size() < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".add(");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
    }

    public void createAddInsertMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append(this.getName());
            jsc.append(".size() < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".add(index, ");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createGetMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("int size = ");
        jsc.append(this.getName());
        jsc.append(".size();");
        String variableName = this.getName() + ".get(index)";
        JType compType = jType.getComponentType();
        jsc.add(compType.toString());
        jsc.append("[] mArray = new ");
        if (compType.isArray()) {
            jsc.append(compType.getComponentType().toString());
        } else {
            jsc.append(compType.toString());
        }
        jsc.append("[size]");
        if (compType.isArray()) {
            jsc.append("[]");
        }
        jsc.append(";");
        jsc.add("for (int index = 0; index < size; index++) {");
        jsc.indent();
        jsc.add("mArray[index] = ");
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.getName());
            jsc.append(") ");
            jsc.append(variableName);
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode(variableName));
        }
        jsc.append(";");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return mArray;");
    }

    public void createGetByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("//-- check bounds for index");
        jsc.add("if ((index < 0) || (index > ");
        jsc.append(this.getName());
        jsc.append(".size())) {");
        jsc.indent();
        jsc.add("throw new IndexOutOfBoundsException();");
        jsc.unindent();
        jsc.add("}");
        jsc.add("");
        jsc.add("return ");
        String variableName = this.getName() + ".get(index)";
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.toString());
            jsc.append(") ");
            jsc.append(variableName);
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode(variableName));
        }
        jsc.append(";");
    }

    public void createSetArrayMethod(JMethod method) {
        String index;
        JSourceCode jsc = method.getSourceCode();
        String paramName = method.getParameter(0).getName();
        if (paramName.equals(index = "i")) {
            index = "j";
        }
        jsc.add("//-- copy array");
        jsc.add(this.getName());
        jsc.append(".clear();");
        jsc.add("for (int ");
        jsc.append(index);
        jsc.append(" = 0; ");
        jsc.append(index);
        jsc.append(" < ");
        jsc.append(paramName);
        jsc.append(".length; ");
        jsc.append(index);
        jsc.append("++) {");
        jsc.indent();
        jsc.add(this.getName());
        jsc.append(".add(");
        jsc.append(this.getContentType().createToJavaObjectCode(paramName + '[' + index + ']'));
        jsc.append(");");
        jsc.unindent();
        jsc.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createSetByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("//-- check bounds for index");
        jsc.add("if ((index < 0) || (index > ");
        jsc.append(this.getName());
        jsc.append(".size())) {");
        jsc.indent();
        jsc.add("throw new IndexOutOfBoundsException();");
        jsc.unindent();
        jsc.add("}");
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize != 0) {
            jsc.add("if (!(");
            jsc.append(this.getName());
            jsc.append(".size() < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException();");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".set(");
        jsc.append("index, ");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
    }

    public void createGetCountMethod(JMethod method) {
        super.createGetCountMethod(method);
    }

    public void createEnumerateMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("java.util.Vector v = new java.util.Vector();");
        jsc.add("java.util.Iterator i = ");
        jsc.append(this.getName());
        jsc.append(".iterator();");
        jsc.add("while(i.hasNext()) v.add(i.next());");
        jsc.add("return v.elements();");
    }

    public void createRemoveByObjectMethod(JMethod method) {
        super.createRemoveByObjectMethod(method);
    }

    public void createRemoveByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("java.lang.Object obj = ");
        jsc.append(this.getName());
        jsc.append(".get(index);");
        jsc.add(this.getName());
        jsc.append(".remove(index);");
        jsc.add("return ");
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.getName());
            jsc.append(") obj;");
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode("obj"));
            jsc.append(";");
        }
    }

    public void createRemoveAllMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add(this.getName());
        jsc.append(".clear();");
    }
}

