/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = new Integer(0);
    private Number lowThreshold = new Integer(0);
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanGauge = new Number[16];
    private transient int[] status = new int[16];
    private transient int[] type = new int[16];
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "GaugeMonitor";
    }

    public GaugeMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the gauge monitor");
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("start", "the gauge monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
                this.previousScanGauge[i] = null;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.trace("stop", "stop the gauge monitor");
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (!this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("stop", "the counter monitor is already started");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            super.setGranularityPeriod(period);
            if (this.isActive()) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getDerivedGauge(ObjectName object) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            int index = this.indexOf(object);
            if (index != -1) {
                return this.derivedGauge[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName object) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            int index = this.indexOf(object);
            if (index != -1) {
                return this.derivedGaugeTimestamp[index];
            }
            return 0L;
        }
    }

    public Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null) {
            throw new IllegalArgumentException("The threshold values cannot be null.");
        }
        if (highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException("The high and the low thresholds must be of the same type.");
        }
        if (this.isFirstStrictlyGreaterThanLast(lowValue, highValue, highValue.getClass().getName())) {
            throw new IllegalArgumentException("The threshold high value must be greater than or equal to threshold low value.");
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.highThreshold = highValue;
            this.lowThreshold = lowValue;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 16);
                this.status[i] = 2;
            }
        }
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyHigh(boolean value) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyHigh = value;
        }
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyLow(boolean value) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyLow = value;
        }
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDifferenceMode(boolean value) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.differenceMode = value;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
                this.previousScanGauge[i] = null;
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED};
        MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
        return notifsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDerivedGauge(Object scanGauge, int index) {
        boolean is_derived_gauge_valid;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.derivedGaugeTimestamp[index] = System.currentTimeMillis();
            if (this.differenceMode) {
                if (this.previousScanGauge[index] != null) {
                    this.setDerivedGaugeWithDifference((Number)scanGauge, index);
                    is_derived_gauge_valid = true;
                } else {
                    is_derived_gauge_valid = false;
                }
                this.previousScanGauge[index] = (Number)scanGauge;
            } else {
                this.derivedGauge[index] = (Number)scanGauge;
                is_derived_gauge_valid = true;
            }
        }
        return is_derived_gauge_valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int index) {
        boolean sendNotify = false;
        String notifType = null;
        long timeStamp = 0L;
        String msg = null;
        Number derGauge = null;
        Number trigger = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.status[index] == 2) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[index], this.highThreshold, this.type[index])) {
                    if (this.notifyHigh) {
                        sendNotify = true;
                        notifType = MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED;
                        timeStamp = this.derivedGaugeTimestamp[index];
                        msg = "";
                        derGauge = this.derivedGauge[index];
                        trigger = this.highThreshold;
                    }
                    this.status[index] = 1;
                } else if (this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[index], this.type[index])) {
                    if (this.notifyLow) {
                        sendNotify = true;
                        notifType = MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED;
                        timeStamp = this.derivedGaugeTimestamp[index];
                        msg = "";
                        derGauge = this.derivedGauge[index];
                        trigger = this.lowThreshold;
                    }
                    this.status[index] = 0;
                }
            } else if (this.status[index] == 0) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[index], this.highThreshold, this.type[index])) {
                    if (this.notifyHigh) {
                        sendNotify = true;
                        notifType = MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED;
                        timeStamp = this.derivedGaugeTimestamp[index];
                        msg = "";
                        derGauge = this.derivedGauge[index];
                        trigger = this.highThreshold;
                    }
                    this.status[index] = 1;
                }
            } else if (this.status[index] == 1 && this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[index], this.type[index])) {
                if (this.notifyLow) {
                    sendNotify = true;
                    notifType = MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED;
                    timeStamp = this.derivedGaugeTimestamp[index];
                    msg = "";
                    derGauge = this.derivedGauge[index];
                    trigger = this.lowThreshold;
                }
                this.status[index] = 0;
            }
        }
        if (sendNotify) {
            this.sendNotification(notifType, timeStamp, msg, derGauge, trigger, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThresholdTypeValid(int index) {
        boolean is_same_type = false;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            switch (this.type[index]) {
                case 0: {
                    if (!(this.highThreshold instanceof Integer) || !(this.lowThreshold instanceof Integer)) break;
                    is_same_type = true;
                    break;
                }
                case 1: {
                    if (!(this.highThreshold instanceof Byte) || !(this.lowThreshold instanceof Byte)) break;
                    is_same_type = true;
                    break;
                }
                case 2: {
                    if (!(this.highThreshold instanceof Short) || !(this.lowThreshold instanceof Short)) break;
                    is_same_type = true;
                    break;
                }
                case 3: {
                    if (!(this.highThreshold instanceof Long) || !(this.lowThreshold instanceof Long)) break;
                    is_same_type = true;
                    break;
                }
                case 4: {
                    if (!(this.highThreshold instanceof Float) || !(this.lowThreshold instanceof Float)) break;
                    is_same_type = true;
                    break;
                }
                case 5: {
                    if (!(this.highThreshold instanceof Double) || !(this.lowThreshold instanceof Double)) break;
                    is_same_type = true;
                    break;
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("isThresholdTypeValid", "the threshold type is invalid");
                }
            }
        }
        return is_same_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDerivedGaugeWithDifference(Number scanGauge, int index) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            switch (this.type[index]) {
                case 0: {
                    this.derivedGauge[index] = new Integer((Integer)scanGauge - (Integer)this.previousScanGauge[index]);
                    break;
                }
                case 1: {
                    this.derivedGauge[index] = new Byte((byte)((Byte)scanGauge - (Byte)this.previousScanGauge[index]));
                    break;
                }
                case 2: {
                    this.derivedGauge[index] = new Short((short)((Short)scanGauge - (Short)this.previousScanGauge[index]));
                    break;
                }
                case 3: {
                    this.derivedGauge[index] = new Long((Long)scanGauge - (Long)this.previousScanGauge[index]);
                    break;
                }
                case 4: {
                    this.derivedGauge[index] = new Float(((Float)scanGauge).floatValue() - ((Float)this.previousScanGauge[index]).floatValue());
                    break;
                }
                case 5: {
                    this.derivedGauge[index] = new Double((Double)scanGauge - (Double)this.previousScanGauge[index]);
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
                }
            }
        }
    }

    private boolean isFirstGreaterThanLast(Number greater, Number less, int type) {
        boolean is_greater = false;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (greater.longValue() < less.longValue()) break;
                is_greater = true;
                break;
            }
            case 4: 
            case 5: {
                if (!(greater.doubleValue() >= less.doubleValue())) break;
                is_greater = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isFirstGreaterThanLast", "the threshold type is invalid");
            }
        }
        return is_greater;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number greater, Number less, String className) {
        boolean is_greater = false;
        if (className.equals("java.lang.Integer") || className.equals("java.lang.Byte") || className.equals("java.lang.Short") || className.equals("java.lang.Long")) {
            if (greater.longValue() > less.longValue()) {
                is_greater = true;
            }
        } else if (className.equals("java.lang.Float") || className.equals("java.lang.Double")) {
            if (greater.doubleValue() > less.doubleValue()) {
                is_greater = true;
            }
        } else if (this.isDebugOn()) {
            this.debug("isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        }
        return is_greater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int index) {
        boolean sendNotify = false;
        String notifType = null;
        long timeStamp = 0L;
        String msg = null;
        Number derGauge = null;
        Object trigger = null;
        Object scan_gauge = null;
        String notif_type = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            block35: {
                try {
                    if (!this.isActive()) break block35;
                    if (this.getObservedObject(index) == null || this.getObservedAttribute() == null) {
                        return;
                    }
                    try {
                        scan_gauge = this.server.getAttribute(this.getObservedObject(index), this.getObservedAttribute());
                        if (scan_gauge == null) {
                            return;
                        }
                    }
                    catch (NullPointerException np_ex) {
                        if ((this.alreadyNotifieds[index] & 8) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(index, 8);
                        throw new MonitorSettingException("The gauge monitor must be registered in the MBean server.");
                    }
                    catch (InstanceNotFoundException inf_ex) {
                        if ((this.alreadyNotifieds[index] & 1) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_OBJECT_ERROR;
                        this.setAlreadyNotified(index, 1);
                        throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                    }
                    catch (AttributeNotFoundException anf_ex) {
                        if ((this.alreadyNotifieds[index] & 2) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(index, 2);
                        throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                    }
                    catch (MBeanException mb_ex) {
                        if ((this.alreadyNotifieds[index] & 8) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(index, 8);
                        throw new MonitorSettingException(mb_ex.getMessage());
                    }
                    catch (ReflectionException ref_ex) {
                        if ((this.alreadyNotifieds[index] & 2) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(index, 2);
                        throw new MonitorSettingException(ref_ex.getMessage());
                    }
                    if (scan_gauge instanceof Integer) {
                        this.type[index] = 0;
                    } else if (scan_gauge instanceof Byte) {
                        this.type[index] = 1;
                    } else if (scan_gauge instanceof Short) {
                        this.type[index] = 2;
                    } else if (scan_gauge instanceof Long) {
                        this.type[index] = 3;
                    } else if (scan_gauge instanceof Float) {
                        this.type[index] = 4;
                    } else if (scan_gauge instanceof Double) {
                        this.type[index] = 5;
                    } else {
                        if ((this.alreadyNotifieds[index] & 4) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                        this.setAlreadyNotified(index, 4);
                        throw new MonitorSettingException("The observed attribute type must be an integer type or a floating-point type.");
                    }
                    if (!this.isThresholdTypeValid(index)) {
                        if ((this.alreadyNotifieds[index] & 0x10) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.THRESHOLD_ERROR;
                        this.setAlreadyNotified(index, 16);
                        throw new MonitorSettingException("The threshold high and threshold low must be of the same type as the gauge.");
                    }
                    this.resetAllAlreadyNotified(index);
                    boolean is_derived_gauge_valid = this.updateDerivedGauge(scan_gauge, index);
                    if (is_derived_gauge_valid) {
                        this.updateNotifications(index);
                    }
                }
                catch (MonitorSettingException ms_ex) {
                    sendNotify = true;
                    notifType = notif_type;
                    timeStamp = this.derivedGaugeTimestamp[index];
                    msg = ms_ex.getMessage();
                    derGauge = this.derivedGauge[index];
                    trigger = null;
                    this.status[index] = 2;
                    this.previousScanGauge[index] = null;
                }
            }
        }
        if (sendNotify) {
            this.sendNotification(notifType, timeStamp, msg, derGauge, trigger, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSpecificElementAt(int index) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            Integer nb = new Integer(0);
            this.insertNumberElementAt(this.derivedGauge, nb, index);
            this.insertNumberElementAt(this.previousScanGauge, null, index);
            this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), index);
            this.insertintElementAt(this.status, 2, index);
            this.insertintElementAt(this.type, 0, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpecificElementAt(int index) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.removeNumberElementAt(this.derivedGauge, index);
            this.removeNumberElementAt(this.previousScanGauge, index);
            this.removelongElementAt(this.derivedGaugeTimestamp, index);
            this.removeintElementAt(this.status, index);
            this.removeintElementAt(this.type, index);
        }
    }

    private static class GaugeAlarmClock
    extends TimerTask {
        GaugeMonitor listener = null;

        public GaugeAlarmClock(GaugeMonitor listener) {
            this.listener = listener;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }
    }
}

