/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private Number[] threshold = new Number[16];
    private Number modulus = new Integer(0);
    private Number offset = new Integer(0);
    private boolean notify = false;
    private boolean differenceMode = false;
    private transient Number initThreshold = new Integer(0);
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanCounter = new Number[16];
    private transient boolean[] modulusExceeded = new boolean[16];
    private transient Number[] derivedGaugeExceeded = new Number[16];
    private transient boolean[] eventAlreadyNotified = new boolean[16];
    private transient int[] type = new int[16];
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "CounterMonitor";
    }

    public CounterMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.isTraceOn()) {
            this.trace("preDeregister", "reset the threshold values");
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.threshold[i] = this.initThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the counter monitor");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.isActive()) {
                if (this.isTraceOn()) {
                    this.trace("start", "the counter monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i = 0; i < this.elementCount; ++i) {
                this.threshold[i] = this.initThreshold;
                this.modulusExceeded[i] = false;
                this.eventAlreadyNotified[i] = false;
                this.previousScanCounter[i] = null;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the counter monitor");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.isTraceOn()) {
                this.trace("stop", "the counter monitor is not started");
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            super.setGranularityPeriod(period);
            if (this.isActive()) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getDerivedGauge(ObjectName object) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            int index = this.indexOf(object);
            if (index != -1) {
                return this.derivedGauge[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName object) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            int index = this.indexOf(object);
            if (index != -1) {
                return this.derivedGaugeTimestamp[index];
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getThreshold(ObjectName object) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            int index = this.indexOf(object);
            if (index != -1) {
                return this.threshold[index];
            }
            return null;
        }
    }

    public Number getInitThreshold() {
        return this.initThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitThreshold(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("The threshold cannot be null.");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold must be greater than or equal to zero.");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.initThreshold = value;
            for (int i = 0; i < this.elementCount; ++i) {
                this.threshold[i] = value;
                this.resetAlreadyNotified(i, 16);
                this.modulusExceeded[i] = false;
                this.eventAlreadyNotified[i] = false;
            }
        }
    }

    public Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public Number getThreshold() {
        return this.threshold[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreshold(Number value) throws IllegalArgumentException {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.setInitThreshold(value);
        }
    }

    public Number getOffset() {
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("The offset cannot be null.");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("The offset must be greater than or equal to zero.");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.offset = value;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 16);
            }
        }
    }

    public Number getModulus() {
        return this.modulus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModulus(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("The modulus cannot be null.");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("The modulus must be greater than or equal to zero.");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.modulus = value;
            for (int i = 0; i < this.elementCount; ++i) {
                this.resetAlreadyNotified(i, 16);
                this.modulusExceeded[i] = false;
            }
        }
    }

    public boolean getNotify() {
        return this.notify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotify(boolean value) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.notify = value;
        }
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDifferenceMode(boolean value) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.differenceMode = value;
            for (int i = 0; i < this.elementCount; ++i) {
                this.threshold[i] = this.initThreshold;
                this.modulusExceeded[i] = false;
                this.eventAlreadyNotified[i] = false;
                this.previousScanCounter[i] = null;
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_VALUE_EXCEEDED};
        MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
        return notifsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDerivedGauge(Object scanCounter, int index) {
        this.derivedGaugeTimestamp[index] = System.currentTimeMillis();
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            boolean is_derived_gauge_valid;
            if (this.differenceMode) {
                if (this.previousScanCounter[index] != null) {
                    this.setDerivedGaugeWithDifference((Number)scanCounter, null, index);
                    if (this.derivedGauge[index].longValue() < 0L) {
                        if (this.modulus.longValue() > 0L) {
                            this.setDerivedGaugeWithDifference((Number)scanCounter, this.modulus, index);
                        }
                        this.threshold[index] = this.initThreshold;
                        this.eventAlreadyNotified[index] = false;
                    }
                    is_derived_gauge_valid = true;
                } else {
                    is_derived_gauge_valid = false;
                }
                this.previousScanCounter[index] = (Number)scanCounter;
            } else {
                this.derivedGauge[index] = (Number)scanCounter;
                is_derived_gauge_valid = true;
            }
            return is_derived_gauge_valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int index) {
        boolean sendNotif = false;
        String notifType = null;
        long timeStamp = 0L;
        String msg = null;
        Number derGauge = null;
        Number trigger = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (!this.eventAlreadyNotified[index]) {
                if (this.derivedGauge[index].longValue() >= this.threshold[index].longValue()) {
                    if (this.notify) {
                        sendNotif = true;
                        notifType = MonitorNotification.THRESHOLD_VALUE_EXCEEDED;
                        timeStamp = this.derivedGaugeTimestamp[index];
                        msg = "";
                        derGauge = this.derivedGauge[index];
                        trigger = this.threshold[index];
                    }
                    this.eventAlreadyNotified[index] = true;
                }
            } else if (this.isTraceOn()) {
                this.trace("updateNotifications", "the notification:\n\tNotification observed object = " + this.getObservedObject(index) + "\n\tNotification observed attribute = " + this.getObservedAttribute() + "\n\tNotification derived gauge = " + this.derivedGauge[index] + "has already been sent");
            }
        }
        if (sendNotif) {
            this.sendNotification(notifType, timeStamp, msg, derGauge, trigger, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreshold(int index) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.derivedGauge[index].longValue() >= this.threshold[index].longValue()) {
                if (this.offset.longValue() > 0L) {
                    long threshold_value;
                    for (threshold_value = this.threshold[index].longValue(); this.derivedGauge[index].longValue() >= threshold_value; threshold_value += this.offset.longValue()) {
                    }
                    switch (this.type[index]) {
                        case 0: {
                            this.threshold[index] = new Integer((int)threshold_value);
                            break;
                        }
                        case 1: {
                            this.threshold[index] = new Byte((byte)threshold_value);
                            break;
                        }
                        case 2: {
                            this.threshold[index] = new Short((short)threshold_value);
                            break;
                        }
                        case 3: {
                            this.threshold[index] = new Long(threshold_value);
                            break;
                        }
                        default: {
                            if (!this.isDebugOn()) break;
                            this.debug("updateThreshold", "the threshold type is invalid");
                        }
                    }
                    if (!this.differenceMode && this.modulus.longValue() > 0L && this.threshold[index].longValue() > this.modulus.longValue()) {
                        this.modulusExceeded[index] = true;
                        this.derivedGaugeExceeded[index] = this.derivedGauge[index];
                    }
                    this.eventAlreadyNotified[index] = false;
                } else {
                    this.modulusExceeded[index] = true;
                    this.derivedGaugeExceeded[index] = this.derivedGauge[index];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThresholdTypeValid(int index) {
        boolean is_same_type = false;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            switch (this.type[index]) {
                case 0: {
                    if (!(this.threshold[index] instanceof Integer) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Integer) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Integer)) break;
                    is_same_type = true;
                    break;
                }
                case 1: {
                    if (!(this.threshold[index] instanceof Byte) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Byte) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Byte)) break;
                    is_same_type = true;
                    break;
                }
                case 2: {
                    if (!(this.threshold[index] instanceof Short) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Short) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Short)) break;
                    is_same_type = true;
                    break;
                }
                case 3: {
                    if (!(this.threshold[index] instanceof Long) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Long) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Long)) break;
                    is_same_type = true;
                    break;
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("isThresholdTypeValid", "the threshold type is invalid");
                }
            }
        }
        return is_same_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDerivedGaugeWithDifference(Number scanCounter, Number mod, int index) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            switch (this.type[index]) {
                case 0: {
                    if (mod == null) {
                        this.derivedGauge[index] = new Integer((Integer)scanCounter - (Integer)this.previousScanCounter[index]);
                        break;
                    }
                    this.derivedGauge[index] = new Integer((Integer)scanCounter - (Integer)this.previousScanCounter[index] + (Integer)this.modulus);
                    break;
                }
                case 1: {
                    if (mod == null) {
                        this.derivedGauge[index] = new Byte((byte)((Byte)scanCounter - (Byte)this.previousScanCounter[index]));
                        break;
                    }
                    this.derivedGauge[index] = new Byte((byte)((Byte)scanCounter - (Byte)this.previousScanCounter[index] + (Byte)this.modulus));
                    break;
                }
                case 2: {
                    if (mod == null) {
                        this.derivedGauge[index] = new Short((short)((Short)scanCounter - (Short)this.previousScanCounter[index]));
                        break;
                    }
                    this.derivedGauge[index] = new Short((short)((Short)scanCounter - (Short)this.previousScanCounter[index] + (Short)this.modulus));
                    break;
                }
                case 3: {
                    if (mod == null) {
                        this.derivedGauge[index] = new Long((Long)scanCounter - (Long)this.previousScanCounter[index]);
                        break;
                    }
                    this.derivedGauge[index] = new Long((Long)scanCounter - (Long)this.previousScanCounter[index] + (Long)this.modulus);
                    break;
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int index) {
        boolean sendNotify = false;
        String notifType = null;
        long timeStamp = 0L;
        String msg = null;
        Number derGauge = null;
        Object trigger = null;
        Object scan_counter = null;
        String notif_type = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            block32: {
                try {
                    boolean is_derived_gauge_valid;
                    if (!this.isActive()) break block32;
                    if (this.getObservedObject(index) == null || this.getObservedAttribute() == null) {
                        return;
                    }
                    try {
                        scan_counter = this.server.getAttribute(this.getObservedObject(index), this.getObservedAttribute());
                        if (scan_counter == null) {
                            return;
                        }
                    }
                    catch (NullPointerException np_ex) {
                        if ((this.alreadyNotifieds[index] & 8) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(index, 8);
                        throw new MonitorSettingException("The counter monitor must be registered in the MBean server.");
                    }
                    catch (InstanceNotFoundException inf_ex) {
                        if ((this.alreadyNotifieds[index] & 1) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_OBJECT_ERROR;
                        this.setAlreadyNotified(index, 1);
                        throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                    }
                    catch (AttributeNotFoundException anf_ex) {
                        if ((this.alreadyNotifieds[index] & 2) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(index, 2);
                        throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                    }
                    catch (MBeanException mb_ex) {
                        if ((this.alreadyNotifieds[index] & 8) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(index, 8);
                        throw new MonitorSettingException(mb_ex.getMessage());
                    }
                    catch (ReflectionException ref_ex) {
                        if ((this.alreadyNotifieds[index] & 2) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(index, 2);
                        throw new MonitorSettingException(ref_ex.getMessage());
                    }
                    if (scan_counter instanceof Integer) {
                        this.type[index] = 0;
                    } else if (scan_counter instanceof Byte) {
                        this.type[index] = 1;
                    } else if (scan_counter instanceof Short) {
                        this.type[index] = 2;
                    } else if (scan_counter instanceof Long) {
                        this.type[index] = 3;
                    } else {
                        if ((this.alreadyNotifieds[index] & 4) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                        this.setAlreadyNotified(index, 4);
                        throw new MonitorSettingException("The observed attribute type must be an integer type.");
                    }
                    if (!this.isThresholdTypeValid(index)) {
                        if ((this.alreadyNotifieds[index] & 0x10) != 0) {
                            return;
                        }
                        notif_type = MonitorNotification.THRESHOLD_ERROR;
                        this.setAlreadyNotified(index, 16);
                        throw new MonitorSettingException("The threshold, offset and modulus must be of the same type as the counter.");
                    }
                    this.resetAllAlreadyNotified(index);
                    if (this.modulusExceeded[index] && this.derivedGauge[index].longValue() < this.derivedGaugeExceeded[index].longValue()) {
                        this.threshold[index] = this.initThreshold;
                        this.modulusExceeded[index] = false;
                        this.eventAlreadyNotified[index] = false;
                    }
                    if (is_derived_gauge_valid = this.updateDerivedGauge(scan_counter, index)) {
                        this.updateNotifications(index);
                        this.updateThreshold(index);
                    }
                }
                catch (MonitorSettingException ms_ex) {
                    sendNotify = true;
                    notifType = notif_type;
                    timeStamp = this.derivedGaugeTimestamp[index];
                    msg = ms_ex.getMessage();
                    derGauge = this.derivedGauge[index];
                    trigger = null;
                    this.modulusExceeded[index] = false;
                    this.eventAlreadyNotified[index] = false;
                    this.previousScanCounter[index] = null;
                }
            }
        }
        if (sendNotify) {
            this.sendNotification(notifType, timeStamp, msg, derGauge, trigger, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSpecificElementAt(int index) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            Integer nb = new Integer(0);
            this.insertNumberElementAt(this.threshold, nb, index);
            this.insertNumberElementAt(this.derivedGauge, nb, index);
            this.insertNumberElementAt(this.previousScanCounter, null, index);
            this.insertNumberElementAt(this.derivedGaugeExceeded, null, index);
            this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), index);
            this.insertbooleanElementAt(this.modulusExceeded, false, index);
            this.insertbooleanElementAt(this.eventAlreadyNotified, false, index);
            this.insertintElementAt(this.type, 0, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpecificElementAt(int index) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.removeNumberElementAt(this.threshold, index);
            this.removeNumberElementAt(this.derivedGauge, index);
            this.removeNumberElementAt(this.previousScanCounter, index);
            this.removeNumberElementAt(this.derivedGaugeExceeded, index);
            this.removelongElementAt(this.derivedGaugeTimestamp, index);
            this.removebooleanElementAt(this.modulusExceeded, index);
            this.removebooleanElementAt(this.eventAlreadyNotified, index);
            this.removeintElementAt(this.type, index);
        }
    }

    private static class CounterAlarmClock
    extends TimerTask {
        CounterMonitor listener = null;

        public CounterAlarmClock(CounterMonitor listener) {
            this.listener = listener;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }
    }
}

