/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;

    public AttributeValueExp() {
    }

    public AttributeValueExp(String attr) {
        this.attr = attr;
    }

    public String getAttributeName() {
        return this.attr;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        Object result = this.getAttribute(name);
        if (result instanceof Number) {
            return new NumericValueExp((Number)result);
        }
        if (result instanceof String) {
            return new StringValueExp((String)result);
        }
        if (result instanceof Boolean) {
            return new BooleanValueExp((Boolean)result);
        }
        throw new BadAttributeValueExpException(result);
    }

    public String toString() {
        return this.attr;
    }

    public void setMBeanServer(MBeanServer s) {
    }

    protected Object getAttribute(ObjectName name) {
        try {
            MBeanServer server = QueryEval.getMBeanServer();
            return server.getAttribute(name, this.attr);
        }
        catch (Exception re) {
            return null;
        }
    }
}

