/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.jmx;

import com.sun.management.jmx.Trace;
import com.sun.management.jmx.TraceNotification;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.management.Notification;
import javax.management.NotificationListener;

public class TraceListener
implements NotificationListener {
    protected PrintStream out;
    protected boolean needTobeClosed = false;
    protected boolean formated = false;

    public TraceListener() {
        this.out = System.out;
    }

    public TraceListener(PrintStream ps) throws IllegalArgumentException {
        if (ps == null) {
            throw new IllegalArgumentException("An PrintStream object should be specified.");
        }
        this.out = ps;
    }

    public TraceListener(String fileName) throws IOException {
        this.out = new PrintStream(new FileOutputStream(fileName, true));
        this.needTobeClosed = true;
    }

    public void setFormated(boolean f) {
        this.formated = f;
    }

    public void handleNotification(Notification notif, Object handback) {
        if (notif instanceof TraceNotification) {
            TraceNotification evt = (TraceNotification)notif;
            if (this.formated) {
                this.out.print("\nGlobal sequence number: " + evt.globalSequenceNumber + "     Sequence number: " + evt.sequenceNumber + "\n" + "Level: " + Trace.getLevel(evt.level) + "     Type: " + Trace.getType(evt.type) + "\n" + "Class  Name: " + new String(evt.className) + "\n" + "Method Name: " + new String(evt.methodName) + "\n");
                if (evt.exception != null) {
                    evt.exception.printStackTrace(this.out);
                    this.out.println();
                }
                if (evt.info != null) {
                    this.out.println("Information: " + evt.info);
                }
            } else {
                this.out.print("(" + evt.className + " " + evt.methodName + ") ");
                if (evt.exception != null) {
                    evt.exception.printStackTrace(this.out);
                    this.out.println();
                }
                if (evt.info != null) {
                    this.out.println(evt.info);
                }
            }
        }
    }

    public void setFile(String fileName) throws IOException {
        PrintStream newOut = new PrintStream(new FileOutputStream(fileName, true));
        if (this.needTobeClosed) {
            this.out.close();
        }
        this.out = newOut;
        this.needTobeClosed = true;
    }
}

