/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.ObjectInputStreamWithLoader;
import com.sun.jmx.mbeanserver.StandardMetaDataImpl;
import com.sun.jmx.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MBeanInstantiatorImpl
implements MBeanInstantiator {
    private final ModifiableClassLoaderRepository clr;
    private static final String dbgTag = "MBeanInstantiatorImpl";
    static /* synthetic */ Class class$com$sun$jmx$mbeanserver$MBeanInstantiatorImpl;

    public MBeanInstantiatorImpl(ModifiableClassLoaderRepository clr) {
        this.clr = clr;
    }

    public void testCreation(Class c) throws NotCompliantMBeanException {
        Introspector.testCreation(c);
    }

    public Class findClassWithDefaultLoaderRepository(String className) throws ReflectionException {
        Class theClass;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        try {
            if (this.clr == null) {
                throw new ClassNotFoundException(className);
            }
            theClass = this.clr.loadClass(className);
        }
        catch (ClassNotFoundException ee) {
            throw new ReflectionException(ee, "The MBean class could not be loaded by the default loader repository");
        }
        return theClass;
    }

    public Class findClass(String className, ClassLoader loader) throws ReflectionException {
        return MBeanInstantiatorImpl.loadClass(className, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String className, ObjectName aLoader) throws ReflectionException, InstanceNotFoundException {
        Object theClass = null;
        if (aLoader == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null loader passed in parameter");
        }
        ClassLoader loader = null;
        MBeanInstantiatorImpl mBeanInstantiatorImpl = this;
        synchronized (mBeanInstantiatorImpl) {
            if (this.clr != null) {
                loader = this.clr.getClassLoader(aLoader);
            }
        }
        if (loader == null) {
            throw new InstanceNotFoundException("The loader named " + aLoader + " is not registered in the MBeanServer");
        }
        return this.findClass(className, loader);
    }

    public Class[] findSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        if (signature == null) {
            return null;
        }
        ClassLoader aLoader = loader;
        int length = signature.length;
        Class[] tab = new Class[length];
        if (length == 0) {
            return tab;
        }
        try {
            for (int i = 0; i < length; ++i) {
                Class primCla = StandardMetaDataImpl.findClassForPrim(signature[i]);
                if (primCla != null) {
                    tab[i] = primCla;
                    continue;
                }
                if (aLoader != null) {
                    Class<?> sclass = aLoader.loadClass(signature[i]);
                    if (sclass == null) continue;
                    tab[i] = sclass;
                    continue;
                }
                tab[i] = this.findClass(signature[i], this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", e);
            throw new ReflectionException(e, "The parameter class could not be found");
        }
        catch (RuntimeException e) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", e);
            throw e;
        }
        return tab;
    }

    public Object instantiate(Class theClass) throws ReflectionException, MBeanException {
        Object moi = null;
        Constructor cons = StandardMetaDataImpl.findConstructor(theClass, null);
        if (cons == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            moi = cons.newInstance(null);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in the MBean's empty constructor");
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error thrown in the MBean's empty constructor");
            }
            throw new MBeanException((Exception)t, "Exception thrown in the MBean's empty constructor");
        }
        catch (NoSuchMethodError error) {
            throw new ReflectionException(new NoSuchMethodException("No constructor"), "No such constructor");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        return moi;
    }

    public Object instantiate(Class theClass, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException {
        Class[] tab;
        Object moi = null;
        try {
            ClassLoader aLoader = theClass.getClassLoader();
            tab = signature == null ? null : this.findSignatureClasses(signature, aLoader);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e, "The constructor parameter classes could not be loaded");
        }
        Constructor cons = null;
        cons = StandardMetaDataImpl.findConstructor(theClass, tab);
        if (cons == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            moi = cons.newInstance(params);
        }
        catch (NoSuchMethodError error) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor found"), "No such constructor");
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)th, "RuntimeException thrown in the MBean's constructor");
            }
            if (th instanceof Error) {
                throw new RuntimeErrorException((Error)th, "Error thrown in the MBean's constructor");
            }
            throw new MBeanException((Exception)th, "Exception thrown in the MBean's constructor");
        }
        return moi;
    }

    public ObjectInputStream deserialize(ClassLoader loader, byte[] data) throws OperationsException {
        ObjectInputStreamWithLoader objIn;
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (data.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try {
            objIn = new ObjectInputStreamWithLoader(bIn, loader);
        }
        catch (IOException e) {
            throw new OperationsException("An IOException occured trying to de-serialize the data");
        }
        return objIn;
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data, ClassLoader loader) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objIn;
        if (data == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (data.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        Class<?> theClass = null;
        if (loaderName == null) {
            theClass = this.findClass(className, loader);
        } else {
            try {
                ClassLoader instance = null;
                if (this.clr != null) {
                    instance = this.clr.getClassLoader(loaderName);
                }
                if (instance == null) {
                    throw new ClassNotFoundException(className);
                }
                theClass = ((ClassLoader)instance).loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "The MBean class could not be loaded by the " + loaderName.toString() + " class loader");
            }
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        try {
            objIn = new ObjectInputStreamWithLoader(bIn, theClass.getClassLoader());
        }
        catch (IOException e) {
            throw new OperationsException("An IOException occured trying to de-serialize the data");
        }
        return objIn;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, (Object[])null, (String[])null, null);
    }

    public Object instantiate(String className, ObjectName loaderName, ClassLoader loader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, null, null, loader);
    }

    public Object instantiate(String className, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException {
        Class theClass = this.findClassWithDefaultLoaderRepository(className);
        return this.instantiate(theClass, params, signature, loader);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature, ClassLoader loader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Class theClass = loaderName == null ? this.findClass(className, loader) : this.findClass(className, loaderName);
        return this.instantiate(theClass, params, signature, loader);
    }

    public ModifiableClassLoaderRepository getClassLoaderRepository() {
        return this.clr;
    }

    static Class loadClass(String className, ClassLoader loader) throws ReflectionException {
        Class<?> theClass = null;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        try {
            if (loader == null) {
                loader = (class$com$sun$jmx$mbeanserver$MBeanInstantiatorImpl == null ? (class$com$sun$jmx$mbeanserver$MBeanInstantiatorImpl = MBeanInstantiatorImpl.class$("com.sun.jmx.mbeanserver.MBeanInstantiatorImpl")) : class$com$sun$jmx$mbeanserver$MBeanInstantiatorImpl).getClassLoader();
            }
            theClass = loader != null ? loader.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The MBean class could not be loaded by the context classloader");
        }
        return theClass;
    }

    static Class[] loadSignatureClasses(String[] signature, ClassLoader loader) throws ReflectionException {
        if (signature == null) {
            return null;
        }
        ClassLoader aLoader = loader == null ? (class$com$sun$jmx$mbeanserver$MBeanInstantiatorImpl == null ? (class$com$sun$jmx$mbeanserver$MBeanInstantiatorImpl = MBeanInstantiatorImpl.class$("com.sun.jmx.mbeanserver.MBeanInstantiatorImpl")) : class$com$sun$jmx$mbeanserver$MBeanInstantiatorImpl).getClassLoader() : loader;
        int length = signature.length;
        Class[] tab = new Class[length];
        if (length == 0) {
            return tab;
        }
        try {
            for (int i = 0; i < length; ++i) {
                Class primCla = StandardMetaDataImpl.findClassForPrim(signature[i]);
                if (primCla != null) {
                    tab[i] = primCla;
                    continue;
                }
                Class<?> sclass = aLoader.loadClass(signature[i]);
                if (sclass == null) continue;
                tab[i] = sclass;
            }
        }
        catch (ClassNotFoundException e) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", e);
            throw new ReflectionException(e, "The parameter class could not be found");
        }
        catch (RuntimeException e) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", e);
            throw e;
        }
        return tab;
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static void trace(String func, String info) {
        MBeanInstantiatorImpl.trace(dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static void debug(String func, String info) {
        MBeanInstantiatorImpl.debug(dbgTag, func, info);
    }

    private static void debugX(String func, Throwable e) {
        if (MBeanInstantiatorImpl.isDebugOn()) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            String stack = s.toString();
            MBeanInstantiatorImpl.debug(dbgTag, func, "Exception caught in " + func + "(): " + e);
            MBeanInstantiatorImpl.debug(dbgTag, func, stack);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

