/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.interceptor.DefaultMBeanServerInterceptor;
import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.ClassLoaderRepositorySupport;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MBeanInstantiatorImpl;
import com.sun.jmx.mbeanserver.MBeanServerDelegateImpl;
import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.mbeanserver.MetaDataImpl;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.RepositorySupport;
import com.sun.jmx.mbeanserver.SecureClassLoaderRepository;
import com.sun.jmx.mbeanserver.SunJmxMBeanServer;
import com.sun.jmx.trace.Trace;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;

public final class JmxMBeanServer
implements SunJmxMBeanServer {
    private final String dbgTag = "MBeanServer";
    private final MBeanInstantiator instantiator;
    private final SecureClassLoaderRepository secureClr;
    private final MetaData meta;
    private final boolean interceptorsEnabled;
    private final transient MBeanServer outerShell;
    private transient MBeanServerInterceptor mbsInterceptor = null;
    private final transient MBeanServerDelegate mBeanServerDelegateObject;
    private transient ObjectName mBeanServerDelegateObjectName = null;
    static /* synthetic */ Class class$javax$management$Attribute;
    static /* synthetic */ Class class$javax$management$AttributeList;

    JmxMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate) {
        this(domain, outer, delegate, null, null, false);
    }

    JmxMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate, boolean interceptors) {
        this(domain, outer, delegate, null, null, false);
    }

    JmxMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate, MBeanInstantiator instantiator, MetaData metadata, boolean interceptors) {
        if (instantiator == null) {
            ClassLoaderRepositorySupport clr = new ClassLoaderRepositorySupport();
            instantiator = new MBeanInstantiatorImpl(clr);
        }
        this.secureClr = new SecureClassLoaderRepository(instantiator.getClassLoaderRepository());
        if (metadata == null) {
            metadata = new MetaDataImpl(instantiator);
        }
        if (delegate == null) {
            delegate = new MBeanServerDelegateImpl();
        }
        if (outer == null) {
            outer = this;
        }
        this.instantiator = instantiator;
        this.meta = metadata;
        this.mBeanServerDelegateObject = delegate;
        this.outerShell = outer;
        RepositorySupport repository = new RepositorySupport(domain);
        this.mbsInterceptor = new DefaultMBeanServerInterceptor(outer, delegate, instantiator, metadata, repository);
        this.interceptorsEnabled = interceptors;
        this.initialize();
    }

    public boolean interceptorsEnabled() {
        return this.interceptorsEnabled;
    }

    public MBeanInstantiator getMBeanInstantiator() {
        if (this.interceptorsEnabled) {
            return this.instantiator;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    public MetaData getMetaData() {
        return this.meta;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbsInterceptor.registerMBean(object, this.cloneObjectName(name));
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbsInterceptor.unregisterMBean(this.cloneObjectName(name));
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbsInterceptor.getObjectInstance(this.cloneObjectName(name));
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        return this.mbsInterceptor.queryMBeans(this.cloneObjectName(name), query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        return this.mbsInterceptor.queryNames(this.cloneObjectName(name), query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.mbsInterceptor.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.mbsInterceptor.getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttribute(this.cloneObjectName(name), attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttributes(this.cloneObjectName(name), attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbsInterceptor.setAttribute(this.cloneObjectName(name), this.cloneAttribute(attribute));
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.setAttributes(this.cloneObjectName(name), this.cloneAttributeList(attributes));
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbsInterceptor.invoke(this.cloneObjectName(name), operationName, params, signature);
    }

    public String getDefaultDomain() {
        return this.mbsInterceptor.getDefaultDomain();
    }

    public String[] getDomains() {
        return this.mbsInterceptor.getDomains();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbsInterceptor.getMBeanInfo(this.cloneObjectName(name));
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        return this.instantiator.instantiate(className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(className, loaderName, myLoader);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(className, params, signature, myLoader);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(className, loaderName, params, signature, myLoader);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbsInterceptor.isInstanceOf(this.cloneObjectName(name), className);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        ClassLoader loader = this.getClassLoaderFor(name);
        return this.instantiator.deserialize(loader, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        Class theClass;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        ClassLoaderRepository clr = this.getClassLoaderRepository();
        try {
            if (clr == null) {
                throw new ClassNotFoundException(className);
            }
            theClass = clr.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The given class could not be loaded by the default loader repository");
        }
        return this.instantiator.deserialize(theClass.getClassLoader(), data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        loaderName = this.cloneObjectName(loaderName);
        try {
            this.getClassLoader(loaderName);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.deserialize(className, loaderName, data, myLoader);
    }

    private void initialize() {
        if (this.instantiator == null) {
            throw new IllegalStateException("instantiator must not be null.");
        }
        try {
            this.mBeanServerDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JmxMBeanServer.this.mbsInterceptor.registerMBean(JmxMBeanServer.this.mBeanServerDelegateObject, JmxMBeanServer.this.mBeanServerDelegateObjectName);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            if (this.isDebugOn()) {
                this.debug("new", "Unexpected security exception occured: " + e);
            }
            this.mBeanServerDelegateObjectName = null;
            throw e;
        }
        catch (Exception e) {
            if (this.isDebugOn()) {
                this.debug("new", "Unexpected exception occured: " + e.getClass().getName());
            }
            this.mBeanServerDelegateObjectName = null;
            throw new IllegalStateException("Can't register delegate.");
        }
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        ModifiableClassLoaderRepository loaders = this.instantiator.getClassLoaderRepository();
        if (loaders != null) {
            loaders.addClassLoader(myLoader);
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            if (systemLoader != myLoader) {
                loaders.addClassLoader(systemLoader);
            }
        }
    }

    public synchronized MBeanServerInterceptor getMBeanServerInterceptor() {
        if (this.interceptorsEnabled) {
            return this.mbsInterceptor;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    public synchronized void setMBeanServerInterceptor(MBeanServerInterceptor interceptor) {
        if (!this.interceptorsEnabled) {
            throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
        }
        if (interceptor == null) {
            throw new IllegalArgumentException("MBeanServerInterceptor is null");
        }
        this.mbsInterceptor = interceptor;
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoaderFor(this.cloneObjectName(mbeanName));
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoader(this.cloneObjectName(loaderName));
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        JmxMBeanServer.checkMBeanPermission(null, null, null, "getClassLoaderRepository");
        return this.secureClr;
    }

    public MBeanServerDelegate getMBeanServerDelegate() {
        return this.mBeanServerDelegateObject;
    }

    public static MBeanServerDelegate newMBeanServerDelegate() {
        return new MBeanServerDelegateImpl();
    }

    public static MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate, boolean interceptors) {
        return new JmxMBeanServer(defaultDomain, outer, delegate, interceptors);
    }

    private ObjectName cloneObjectName(ObjectName name) {
        if (name != null) {
            return ObjectName.getInstance(name);
        }
        return name;
    }

    private Attribute cloneAttribute(Attribute attribute) {
        if (attribute != null && !attribute.getClass().equals(class$javax$management$Attribute == null ? (class$javax$management$Attribute = JmxMBeanServer.class$("javax.management.Attribute")) : class$javax$management$Attribute)) {
            return new Attribute(attribute.getName(), attribute.getValue());
        }
        return attribute;
    }

    private AttributeList cloneAttributeList(AttributeList list) {
        if (list != null) {
            if (!list.getClass().equals(class$javax$management$AttributeList == null ? (class$javax$management$AttributeList = JmxMBeanServer.class$("javax.management.AttributeList")) : class$javax$management$AttributeList)) {
                AttributeList newList = new AttributeList(list.size());
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Attribute attribute = (Attribute)i.next();
                    newList.add(this.cloneAttribute(attribute));
                }
                return newList;
            }
            for (int i = 0; i < list.size(); ++i) {
                Attribute attribute = (Attribute)list.get(i);
                if (attribute.getClass().equals(class$javax$management$Attribute == null ? JmxMBeanServer.class$("javax.management.Attribute") : class$javax$management$Attribute)) continue;
                list.set(i, this.cloneAttribute(attribute));
            }
            return list;
        }
        return list;
    }

    private static void checkMBeanPermission(String classname, String member, ObjectName objectName, String actions) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanPermission perm = new MBeanPermission(classname, member, objectName, actions);
            sm.checkPermission(perm);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private void trace(String func, String info) {
        this.trace("MBeanServer", func, info);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private void debug(String func, String info) {
        this.debug("MBeanServer", func, info);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

