/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.trace.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;

public class Introspector {
    private static Vector attributes;
    private static Vector operations;
    private static String className;
    private static Class baseClass;
    private static final String attributeDescription = "Attribute exposed for management";
    private static final String operationDescription = "Operation exposed for management";
    private static final String constructorDescription = "Public constructor of the MBean";
    private static final String mbeanInfoDescription = "Information on the management interface of the MBean";
    static /* synthetic */ Class class$javax$management$DynamicMBean;
    static /* synthetic */ Class class$java$lang$Boolean;

    private Introspector() {
    }

    public static final boolean isDynamic(Class c) {
        return (class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = Introspector.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(c);
    }

    public static void testCreation(Class c) throws NotCompliantMBeanException {
        int mods = c.getModifiers();
        if (Modifier.isAbstract(mods) || Modifier.isInterface(mods)) {
            throw new NotCompliantMBeanException("The MBean must have a concrete class in order to be created remotely.");
        }
        Constructor<?>[] consList = c.getConstructors();
        if (consList.length == 0) {
            throw new NotCompliantMBeanException("The MBean must have a public constructor in order to be created remotely");
        }
    }

    public static synchronized MBeanInfo testCompliance(Class c) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(c)) {
            return null;
        }
        return Introspector.testCompliance(c, null);
    }

    static synchronized MBeanInfo testCompliance(Class c, Class mbeanInterface) throws NotCompliantMBeanException {
        if (c.isInterface()) {
            throw new NotCompliantMBeanException(c.getName() + " must be a class.");
        }
        baseClass = c;
        className = c.getName();
        if (mbeanInterface == null) {
            mbeanInterface = Introspector.getStandardMBeanInterface(c);
        } else {
            if (!mbeanInterface.isAssignableFrom(c)) {
                throw new NotCompliantMBeanException(c.getName() + " does not implement the " + mbeanInterface.getName() + " interface");
            }
            if (!mbeanInterface.isInterface()) {
                throw new NotCompliantMBeanException(c.getName() + ": " + mbeanInterface.getName() + " is not an interface");
            }
        }
        if (mbeanInterface == null) {
            throw new NotCompliantMBeanException(c.getName() + " does not implement the " + c.getName() + "MBean interface " + "or the DynamicMBean interface");
        }
        int mods = mbeanInterface.getModifiers();
        if (!Modifier.isPublic(mods)) {
            throw new NotCompliantMBeanException(mbeanInterface.getName() + " implemented by " + c.getName() + " must be public.");
        }
        return Introspector.introspect(mbeanInterface);
    }

    public static synchronized Class getMBeanInterface(Class c) {
        if (Introspector.isDynamic(c)) {
            return null;
        }
        return Introspector.getStandardMBeanInterface(c);
    }

    static synchronized Class getStandardMBeanInterface(Class c) {
        Class mbeanInterface = null;
        for (Class current = c; current != null && (mbeanInterface = Introspector.findMBeanInterface(current, current.getName())) == null; current = current.getSuperclass()) {
        }
        return mbeanInterface;
    }

    private static final Class findMBeanInterface(Class aClass, String aName) {
        for (Class current = aClass; current != null; current = current.getSuperclass()) {
            Class<?>[] interfaces = current.getInterfaces();
            int len = interfaces.length;
            for (int i = 0; i < len; ++i) {
                Class inter = Introspector.implementsMBean(interfaces[i], aName);
                if (inter == null) continue;
                return inter;
            }
        }
        return null;
    }

    private static MBeanInfo introspect(Class beanClass) throws NotCompliantMBeanException {
        attributes = new Vector();
        operations = new Vector();
        Method[] methodList = null;
        methodList = beanClass.getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (method == null) continue;
            String name = method.getName();
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            MBeanAttributeInfo attr = null;
            MBeanOperationInfo oper = null;
            if (name.equals("get") || name.equals("is") || name.equals("set")) {
                try {
                    oper = new MBeanOperationInfo(operationDescription, method);
                }
                catch (Exception e) {
                    Introspector.error("introspect", e);
                }
                operations.addElement(oper);
                continue;
            }
            if (!(name.startsWith("get") || name.startsWith("set") || name.startsWith("is"))) {
                try {
                    oper = new MBeanOperationInfo(operationDescription, method);
                }
                catch (Exception e) {
                    Introspector.error("introspect", e);
                }
                operations.addElement(oper);
                continue;
            }
            if (argCount == 0) {
                if (name.startsWith("get")) {
                    if (resultType == Void.TYPE) {
                        try {
                            oper = new MBeanOperationInfo(operationDescription, method);
                        }
                        catch (Exception e) {
                            Introspector.error("introspect", e);
                        }
                        operations.addElement(oper);
                        continue;
                    }
                    try {
                        attr = new MBeanAttributeInfo(name.substring(3), attributeDescription, method, null);
                    }
                    catch (Exception e) {
                        Introspector.error("introspect", e);
                    }
                    if (!Introspector.testConsistency(attr)) continue;
                    attributes.addElement(attr);
                    continue;
                }
                if ((resultType == (class$java$lang$Boolean == null ? Introspector.class$("java.lang.Boolean") : class$java$lang$Boolean) || resultType == Boolean.TYPE) && name.startsWith("is")) {
                    try {
                        attr = new MBeanAttributeInfo(name.substring(2), attributeDescription, method, null);
                    }
                    catch (Exception e) {
                        Introspector.error("introspect", e);
                    }
                    if (!Introspector.testConsistency(attr)) continue;
                    attributes.addElement(attr);
                    continue;
                }
                if (name.startsWith("set")) {
                    try {
                        oper = new MBeanOperationInfo(operationDescription, method);
                    }
                    catch (Exception e) {
                        Introspector.error("introspect", e);
                    }
                    operations.addElement(oper);
                    continue;
                }
            }
            if (argCount == 1) {
                if (resultType == Void.TYPE && name.startsWith("set")) {
                    try {
                        attr = new MBeanAttributeInfo(name.substring(3), attributeDescription, null, method);
                    }
                    catch (Exception e) {
                        Introspector.error("introspect", e);
                    }
                    if (!Introspector.testConsistency(attr)) continue;
                    attributes.addElement(attr);
                    continue;
                }
                try {
                    oper = new MBeanOperationInfo(operationDescription, method);
                }
                catch (Exception e) {
                    Introspector.error("introspect", e);
                }
                operations.addElement(oper);
                continue;
            }
            if (argCount <= 1) continue;
            try {
                oper = new MBeanOperationInfo(operationDescription, method);
            }
            catch (Exception e) {
                Introspector.error("introspect", e);
            }
            operations.addElement(oper);
        }
        return Introspector.constructResult();
    }

    private static boolean testConsistency(MBeanAttributeInfo attr) throws NotCompliantMBeanException {
        Enumeration i = attributes.elements();
        while (i.hasMoreElements()) {
            MBeanAttributeInfo mb = (MBeanAttributeInfo)i.nextElement();
            if (mb.getName().compareTo(attr.getName()) != 0) continue;
            if (attr.isReadable() && mb.isReadable() && attr.isIs() != mb.isIs()) {
                throw new NotCompliantMBeanException("Getter is" + mb.getName() + " cannot co-exist with getter get" + attr.getName());
            }
            if (mb.getType().compareTo(attr.getType()) != 0) {
                if (mb.isWritable() && attr.isWritable()) {
                    throw new NotCompliantMBeanException("Type mismatch between parameters of set" + mb.getName() + " methods");
                }
                throw new NotCompliantMBeanException("Type mismatch between parameters of get or is" + mb.getName() + ", set" + mb.getName() + " methods");
            }
            if (attr.isReadable() && mb.isReadable()) {
                return false;
            }
            if (!attr.isWritable() || !mb.isWritable()) continue;
            return false;
        }
        return true;
    }

    static MBeanConstructorInfo[] getConstructors() {
        int i;
        Constructor<?>[] consList = baseClass.getConstructors();
        Vector<MBeanConstructorInfo> constructors = new Vector<MBeanConstructorInfo>();
        for (i = 0; i < consList.length; ++i) {
            Constructor<?> constructor = consList[i];
            MBeanConstructorInfo mc = null;
            try {
                mc = new MBeanConstructorInfo(constructorDescription, constructor);
            }
            catch (Exception ex) {
                mc = null;
            }
            if (mc == null) continue;
            constructors.addElement(mc);
        }
        MBeanConstructorInfo[] resultConstructors = new MBeanConstructorInfo[constructors.size()];
        for (i = 0; i < resultConstructors.length; ++i) {
            resultConstructors[i] = (MBeanConstructorInfo)constructors.elementAt(i);
        }
        return resultConstructors;
    }

    private static MBeanInfo constructResult() {
        int len = attributes.size();
        MBeanAttributeInfo[] attrlist = new MBeanAttributeInfo[len];
        attributes.toArray(attrlist);
        ArrayList<MBeanAttributeInfo> mergedAttributes = new ArrayList<MBeanAttributeInfo>();
        for (int i = 0; i < len; ++i) {
            MBeanAttributeInfo bi = attrlist[i];
            if (bi == null) continue;
            MBeanAttributeInfo att = bi;
            for (int j = i + 1; j < len; ++j) {
                MBeanAttributeInfo mi = attrlist[j];
                if (mi == null || mi.getName().compareTo(bi.getName()) != 0) continue;
                attrlist[j] = null;
                att = new MBeanAttributeInfo(bi.getName(), bi.getType(), attributeDescription, true, true, bi.isIs());
            }
            mergedAttributes.add(att);
        }
        MBeanAttributeInfo[] resultAttributes = new MBeanAttributeInfo[mergedAttributes.size()];
        mergedAttributes.toArray(resultAttributes);
        MBeanOperationInfo[] resultOperations = new MBeanOperationInfo[operations.size()];
        operations.toArray(resultOperations);
        MBeanConstructorInfo[] resultConstructors = Introspector.getConstructors();
        MBeanInfo resultMBeanInfo = new MBeanInfo(className, mbeanInfoDescription, resultAttributes, resultConstructors, resultOperations, null);
        return resultMBeanInfo;
    }

    static Class implementsMBean(Class c, String clName) {
        if (c.getName().compareTo(clName + "MBean") == 0) {
            return c;
        }
        Class current = c;
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                if (interfaces[i].getName().compareTo(clName + "MBean") != 0) continue;
                return interfaces[i];
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static void error(String method, Throwable t) {
        Trace.send(0, 1, "Introspector", method, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = null;
        baseClass = null;
    }
}

