/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.mbeanserver.MetaDataImpl;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.NamedObject;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.RepositorySupport;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class DefaultMBeanServerInterceptor
implements MBeanServerInterceptor {
    private static final ObjectName _MBSDelegateObjectName;
    private final transient MBeanInstantiator instantiator;
    private transient MBeanServer server = null;
    private final transient MBeanServerDelegate delegate;
    private final transient MetaData meta;
    private final transient Repository repository;
    private final transient WeakHashMap listenerWrappers = new WeakHashMap();
    private final String domain;
    private boolean queryByRepo;
    private static final String dbgTag = "DefaultMBeanServerInterceptor";
    static /* synthetic */ Class class$javax$management$NotificationListener;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;
    static /* synthetic */ Class class$javax$management$NotificationEmitter;

    public DefaultMBeanServerInterceptor(String domain, MBeanServer outer, MBeanServerDelegate delegate, MBeanInstantiator instantiator) {
        this(outer, delegate, instantiator, null, new RepositorySupport(domain == null ? "DefaultDomain" : domain));
    }

    public DefaultMBeanServerInterceptor(MBeanServer outer, MBeanServerDelegate delegate, MBeanInstantiator instantiator, MetaData metadata, Repository repository) {
        if (outer == null) {
            throw new IllegalArgumentException("outer MBeanServer cannot be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("MBeanServerDelegate cannot be null");
        }
        if (instantiator == null) {
            throw new IllegalArgumentException("MBeanInstantiator cannot be null");
        }
        if (metadata == null) {
            metadata = new MetaDataImpl(instantiator);
        }
        if (repository == null) {
            repository = new RepositorySupport("DefaultDomain");
        }
        this.server = outer;
        this.delegate = delegate;
        this.instantiator = instantiator;
        this.meta = metadata;
        this.repository = repository;
        this.domain = repository.getDefaultDomain();
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, name, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, name, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.createMBean(className, name, null, true, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("Unexpected exception: " + e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, name, loaderName, false, params, signature);
    }

    private ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, boolean withDefaultLoaderRepository, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        String infoClassName;
        Class theClass;
        ObjectName logicalName = name;
        if (className == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(wrapped, "Exception occured during MBean creation");
        }
        if (name != null) {
            if (name.isPattern()) {
                IllegalArgumentException wrapped = new IllegalArgumentException("Invalid name->" + name.toString());
                String msg = "Exception occurred during MBean creation";
                throw new RuntimeOperationsException(wrapped, "Exception occurred during MBean creation");
            }
            name = this.nonDefaultDomain(name);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(className, null, null, "instantiate");
        DefaultMBeanServerInterceptor.checkMBeanPermission(className, null, name, "registerMBean");
        if (withDefaultLoaderRepository) {
            if (DefaultMBeanServerInterceptor.isTraceOn()) {
                DefaultMBeanServerInterceptor.trace(dbgTag, "createMBean", "ClassName = " + className + ",ObjectName = " + name);
            }
            theClass = this.instantiator.findClassWithDefaultLoaderRepository(className);
        } else if (loaderName == null) {
            if (DefaultMBeanServerInterceptor.isTraceOn()) {
                DefaultMBeanServerInterceptor.trace(dbgTag, "createMBean", "ClassName = " + className + ",ObjectName = " + name + " Loader name = null");
            }
            theClass = this.instantiator.findClass(className, this.server.getClass().getClassLoader());
        } else {
            loaderName = this.nonDefaultDomain(loaderName);
            if (DefaultMBeanServerInterceptor.isTraceOn()) {
                DefaultMBeanServerInterceptor.trace(dbgTag, "createMBean", "ClassName = " + className + ",ObjectName = " + name + ",Loader name = " + loaderName.toString());
            }
            theClass = this.instantiator.findClass(className, loaderName);
        }
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(theClass);
        this.instantiator.testCreation(theClass);
        this.meta.testCompliance(theClass);
        Object moi = this.instantiator.instantiate(theClass, params, signature, this.server.getClass().getClassLoader());
        try {
            infoClassName = this.meta.getMBeanClassName(moi);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException(e.getMessage());
        }
        return this.registerCreatedObject(infoClassName, moi, name);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String infoClassName;
        Class<?> theClass = object.getClass();
        this.meta.testCompliance(theClass);
        try {
            infoClassName = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException(e.getMessage());
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(infoClassName, null, name, "registerMBean");
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(theClass);
        return this.registerObject(infoClassName, object, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        Object object;
        if (name == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Object name cannot be null");
            throw new RuntimeOperationsException(wrapped, "Exception occured trying to unregister the MBean");
        }
        name = this.nonDefaultDomain(name);
        Object instance = this.getMBean(name);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "unregisterMBean");
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            ModifiableClassLoaderRepository clr;
            object = this.repository.retrieve(name);
            if (object == null) {
                if (DefaultMBeanServerInterceptor.isTraceOn()) {
                    DefaultMBeanServerInterceptor.trace("unregisterMBean", name + ": Found no object");
                }
                throw new InstanceNotFoundException(name.toString());
            }
            if (object instanceof MBeanRegistration) {
                this.meta.preDeregisterInvoker(object);
            }
            this.repository.remove(name);
            if (object instanceof ClassLoader && object != this.server.getClass().getClassLoader() && (clr = this.instantiator.getClassLoaderRepository()) != null) {
                clr.removeClassLoader(name);
            }
        }
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("unregisterMBean", "Send delete notification of object " + name.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.unregistered", name);
        if (object instanceof MBeanRegistration) {
            this.meta.postDeregisterInvoker(object);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        String className;
        name = this.nonDefaultDomain(name);
        Object obj = this.getMBean(name);
        try {
            className = this.meta.getMBeanClassName(obj);
        }
        catch (IntrospectionException x) {
            DefaultMBeanServerInterceptor.debugX("getObjectInstance", x);
            throw new JMRuntimeException("Can't obtain class name for " + name + ": " + x);
        }
        catch (NotCompliantMBeanException x) {
            DefaultMBeanServerInterceptor.debugX("getObjectInstance", x);
            throw new JMRuntimeException("Can't obtain class name for " + name + ": " + x);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(className, null, name, "getObjectInstance");
        return new ObjectInstance(name, className);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "queryMBeans");
            Set list = this.queryMBeansImpl(name, null);
            HashSet<ObjectInstance> allowedList = new HashSet<ObjectInstance>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                try {
                    ObjectInstance oi = (ObjectInstance)i.next();
                    DefaultMBeanServerInterceptor.checkMBeanPermission(oi.getClassName(), null, oi.getObjectName(), "queryMBeans");
                    allowedList.add(oi);
                }
                catch (SecurityException e) {}
            }
            return this.filterListOfObjectInstances(allowedList, query);
        }
        return this.queryMBeansImpl(name, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set queryMBeansImpl(ObjectName name, QueryExp query) {
        Set list = null;
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            list = this.repository.query(name, query);
        }
        if (this.queryByRepo) {
            return list;
        }
        return this.filterListOfObjects(list, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "queryNames");
            Set list = this.queryMBeansImpl(name, null);
            HashSet<ObjectInstance> allowedList = new HashSet<ObjectInstance>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                try {
                    ObjectInstance oi = (ObjectInstance)i.next();
                    DefaultMBeanServerInterceptor.checkMBeanPermission(oi.getClassName(), null, oi.getObjectName(), "queryNames");
                    allowedList.add(oi);
                }
                catch (SecurityException e) {}
            }
            Set queryList = this.filterListOfObjectInstances(allowedList, query);
            HashSet<ObjectName> result = new HashSet<ObjectName>(queryList.size());
            Iterator i2 = queryList.iterator();
            while (i2.hasNext()) {
                ObjectInstance oi = (ObjectInstance)i2.next();
                result.add(oi.getObjectName());
            }
            return result;
        }
        Set queryList = this.queryMBeansImpl(name, query);
        HashSet<ObjectName> result = new HashSet<ObjectName>(queryList.size());
        Iterator i = queryList.iterator();
        while (i.hasNext()) {
            ObjectInstance oi = (ObjectInstance)i.next();
            result.add(oi.getObjectName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
        }
        name = this.nonDefaultDomain(name);
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            return this.repository.contains(name);
        }
    }

    public String[] getDomains() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "getDomains");
            String[] domains = this.repository.getDomains();
            ArrayList<String> result = new ArrayList<String>(domains.length);
            for (int i = 0; i < domains.length; ++i) {
                try {
                    ObjectName domain = new ObjectName(domains[i] + ":x=x");
                    DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, domain, "getDomains");
                    result.add(domains[i]);
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    DefaultMBeanServerInterceptor.error("getDomains", "Failed to check permission for domain=" + domains[i] + ". Error is: " + e);
                    DefaultMBeanServerInterceptor.debugX("getDomains", e);
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            return result.toArray(new String[result.size()]);
        }
        return this.repository.getDomains();
    }

    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("getAttribute", "Attribute= " + attribute + ", obj= " + name);
        }
        Object instance = this.getMBean(name);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, attribute, name, "getAttribute");
        return this.meta.getAttribute(instance, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("getAttributes", "Object= " + name);
        }
        Object instance = this.getMBean(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String classname = null;
            try {
                classname = this.meta.getMBeanClassName(instance);
            }
            catch (IntrospectionException e) {
                classname = null;
            }
            catch (NotCompliantMBeanException e) {
                classname = null;
            }
            DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "getAttribute");
            ArrayList<String> allowedList = new ArrayList<String>(attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(classname, attributes[i], name, "getAttribute");
                    allowedList.add(attributes[i]);
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            String[] allowedAttributes = allowedList.toArray(new String[0]);
            return this.meta.getAttributes(instance, allowedAttributes);
        }
        return this.meta.getAttributes(instance, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("setAttribute", "Object= " + name + ", attribute=" + attribute.getName());
        }
        Object instance = this.getMBean(name);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, attribute.getName(), name, "setAttribute");
        Object o = this.meta.setAttribute(instance, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        name = this.nonDefaultDomain(name);
        Object instance = this.getMBean(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String classname = null;
            try {
                classname = this.meta.getMBeanClassName(instance);
            }
            catch (IntrospectionException e) {
                classname = null;
            }
            catch (NotCompliantMBeanException e) {
                classname = null;
            }
            DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "setAttribute");
            AttributeList allowedAttributes = new AttributeList(attributes.size());
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                try {
                    Attribute attribute = (Attribute)i.next();
                    DefaultMBeanServerInterceptor.checkMBeanPermission(classname, attribute.getName(), name, "setAttribute");
                    allowedAttributes.add(attribute);
                }
                catch (SecurityException e) {}
            }
            return this.meta.setAttributes(instance, allowedAttributes);
        }
        return this.meta.setAttributes(instance, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        name = this.nonDefaultDomain(name);
        Object instance = this.getMBean(name);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, operationName, name, "invoke");
        return this.meta.invoke(instance, operationName, params, signature);
    }

    protected MetaData meta() {
        return this.meta;
    }

    protected ObjectInstance makeObjectInstance(String className, Object object, ObjectName name) throws NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            try {
                className = this.meta.getMBeanClassName(object);
            }
            catch (SecurityException x) {
                DefaultMBeanServerInterceptor.debugX("makeObjectInstance", x);
                throw x;
            }
            catch (IntrospectionException x) {
                DefaultMBeanServerInterceptor.debugX("makeObjectInstance", x);
                throw new NotCompliantMBeanException("Can't obtain class name for " + name + ": " + x);
            }
            catch (JMRuntimeException x) {
                DefaultMBeanServerInterceptor.debugX("makeObjectInstance", x);
                throw new NotCompliantMBeanException("Can't obtain class name for " + name + ": " + x);
            }
        }
        if (className == null) {
            throw new NotCompliantMBeanException("The class Name returned is null");
        }
        return new ObjectInstance(this.nonDefaultDomain(name), className);
    }

    protected ObjectInstance registerObject(String classname, Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException("Cannot add null object");
            throw new RuntimeOperationsException(wrapped, "Exception occured trying to register the MBean");
        }
        name = this.nonDefaultDomain(name);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace(dbgTag, "registerMBean", "ObjectName = " + name);
        }
        ObjectName logicalName = name;
        if (object instanceof MBeanRegistration && (logicalName = this.meta.preRegisterInvoker(object, name, this.server)) != name) {
            logicalName = this.nonDefaultDomain(logicalName);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, logicalName, "registerMBean");
        if (logicalName == null) {
            if (object instanceof MBeanRegistration) {
                this.meta.postRegisterInvoker(object, false);
            }
            IllegalArgumentException wrapped = new IllegalArgumentException("No object name specified");
            throw new RuntimeOperationsException(wrapped, "Exception occured trying to register the MBean");
        }
        ObjectInstance result = this.makeObjectInstance(classname, object, logicalName);
        this.internal_addObject(object, logicalName);
        if (object instanceof MBeanRegistration) {
            this.meta.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            ModifiableClassLoaderRepository clr = this.instantiator.getClassLoaderRepository();
            if (clr == null) {
                IllegalArgumentException wrapped = new IllegalArgumentException("Dynamic addition of class loaders is not supported");
                throw new RuntimeOperationsException(wrapped, "Exception occured trying to register the MBean as a class loader");
            }
            clr.addClassLoader(logicalName, (ClassLoader)object);
        }
        return result;
    }

    protected ObjectInstance registerCreatedObject(String classname, Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.registerObject(classname, object, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMBean(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to get an MBean");
        }
        Object obj = null;
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            obj = this.repository.retrieve(name);
            if (obj == null) {
                if (DefaultMBeanServerInterceptor.isTraceOn()) {
                    DefaultMBeanServerInterceptor.trace("getMBean", name + ": Found no object");
                }
                throw new InstanceNotFoundException(name.toString());
            }
        }
        return obj;
    }

    private ObjectName nonDefaultDomain(ObjectName name) {
        if (name == null || name.getDomain().length() > 0) {
            return name;
        }
        String completeName = this.domain + name;
        try {
            return new ObjectName(completeName);
        }
        catch (MalformedObjectNameException e) {
            String msg = "Unexpected default domain problem: " + completeName + ": " + e;
            throw new IllegalArgumentException(msg);
        }
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("addNotificationListener", "obj= " + name);
        }
        Object instance = this.getMBean(name);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "addNotificationListener");
        if (!(instance instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(name.getCanonicalName()), "The MBean " + name.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)instance;
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        NotificationListener listenerWrapper = this.getListenerWrapper(listener, name, instance, true);
        broadcaster.addNotificationListener(listenerWrapper, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Object instance = this.getMBean(listener);
        if (!(instance instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(listener.getCanonicalName()), "The MBean " + listener.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("addNotificationListener", "obj= " + name + " listener= " + listener);
        }
        this.server.addNotificationListener(name, (NotificationListener)instance, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, null, null, true);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(name, listener, filter, handback, false);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener instance = this.getListener(listener);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("removeNotificationListener", "obj= " + name + " listener= " + listener);
        }
        this.server.removeNotificationListener(name, instance);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener instance = this.getListener(listener);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("removeNotificationListener", "obj= " + name + " listener= " + listener);
        }
        this.server.removeNotificationListener(name, instance, filter, handback);
    }

    private NotificationListener getListener(ObjectName listener) throws ListenerNotFoundException {
        Object instance;
        try {
            instance = this.getMBean(listener);
        }
        catch (InstanceNotFoundException e) {
            throw new ListenerNotFoundException(e.getMessage());
        }
        if (!(instance instanceof NotificationListener)) {
            IllegalArgumentException exc = new IllegalArgumentException(listener.getCanonicalName());
            String msg = "MBean " + listener.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = DefaultMBeanServerInterceptor.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener).getName();
            throw new RuntimeOperationsException(exc, msg);
        }
        return (NotificationListener)instance;
    }

    private void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback, boolean removeAll) throws InstanceNotFoundException, ListenerNotFoundException {
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("removeNotificationListener", "obj= " + name);
        }
        Object instance = this.getMBean(name);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "removeNotificationListener");
        NotificationBroadcaster broadcaster = null;
        NotificationEmitter emitter = null;
        if (removeAll) {
            if (!(instance instanceof NotificationBroadcaster)) {
                IllegalArgumentException exc = new IllegalArgumentException(name.getCanonicalName());
                String msg = "MBean " + name.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = DefaultMBeanServerInterceptor.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName();
                throw new RuntimeOperationsException(exc, msg);
            }
            broadcaster = (NotificationBroadcaster)instance;
        } else {
            if (!(instance instanceof NotificationEmitter)) {
                IllegalArgumentException exc = new IllegalArgumentException(name.getCanonicalName());
                String msg = "MBean " + name.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = DefaultMBeanServerInterceptor.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter).getName();
                throw new RuntimeOperationsException(exc, msg);
            }
            emitter = (NotificationEmitter)instance;
        }
        NotificationListener listenerWrapper = this.getListenerWrapper(listener, name, instance, false);
        if (listenerWrapper == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        if (removeAll) {
            broadcaster.removeNotificationListener(listenerWrapper);
        } else {
            emitter.removeNotificationListener(listenerWrapper, filter, handback);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Object moi = this.getMBean(name);
        MBeanInfo mbi = this.meta.getMBeanInfo(moi);
        if (mbi == null) {
            throw new JMRuntimeException("MBean " + name + "has no MBeanInfo");
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(mbi.getClassName(), null, name, "getMBeanInfo");
        return mbi;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        Object instance = this.getMBean(name);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, name, "isInstanceOf");
        try {
            return this.meta.isInstanceOf(instance, className);
        }
        catch (ReflectionException e) {
            DefaultMBeanServerInterceptor.debugX("isInstanceOf", e);
            return false;
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        Object instance = this.getMBean(mbeanName);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, mbeanName, "getClassLoaderFor");
        return instance.getClass().getClassLoader();
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        if (loaderName == null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "getClassLoader");
            return this.server.getClass().getClassLoader();
        }
        Object instance = this.getMBean(loaderName);
        String classname = null;
        try {
            classname = this.meta.getMBeanClassName(instance);
        }
        catch (IntrospectionException e) {
            classname = null;
        }
        catch (NotCompliantMBeanException e) {
            classname = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(classname, null, loaderName, "getClassLoader");
        if (!(instance instanceof ClassLoader)) {
            throw new InstanceNotFoundException(loaderName.toString() + " is not a classloader");
        }
        return (ClassLoader)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internal_addObject(Object object, ObjectName logicalName) throws InstanceAlreadyExistsException {
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            try {
                this.repository.addMBean(object, logicalName);
            }
            catch (InstanceAlreadyExistsException e) {
                if (object instanceof MBeanRegistration) {
                    this.meta.postRegisterInvoker(object, false);
                }
                throw e;
            }
        }
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("addObject", "Send create notification of object " + logicalName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", logicalName);
    }

    private void sendNotification(String NotifType, ObjectName name) {
        MBeanServerNotification notif = new MBeanServerNotification(NotifType, (Object)_MBSDelegateObjectName, 0L, name);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("sendNotification", NotifType + " " + name);
        }
        this.delegate.sendNotification(notif);
    }

    private void initialize(String domain, MBeanServer outer, MBeanServerDelegate delegate, MBeanInstantiator inst, MetaData meta, Repository repos) {
        if (!this.domain.equals(this.repository.getDefaultDomain())) {
            throw new IllegalArgumentException("Domain Name Mismatch");
        }
        try {
            this.queryByRepo = this.repository.isFiltering();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            this.queryByRepo = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set filterListOfObjects(Set list, QueryExp query) {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        if (query == null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String className;
                NamedObject no;
                block13: {
                    no = (NamedObject)i.next();
                    Object obj = no.getObject();
                    className = null;
                    try {
                        className = this.meta.getMBeanClassName(obj);
                    }
                    catch (JMException x) {
                        if (!DefaultMBeanServerInterceptor.isDebugOn()) break block13;
                        DefaultMBeanServerInterceptor.debug("filterListOfObjects", "Can't obtain class name for " + no.getName() + ": " + x);
                    }
                }
                result.add(new ObjectInstance(no.getName(), className));
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String className;
                NamedObject no;
                block15: {
                    no = (NamedObject)i.next();
                    Object obj = no.getObject();
                    boolean res = false;
                    MBeanServer oldServer = QueryEval.getMBeanServer();
                    query.setMBeanServer(this.server);
                    try {
                        res = query.apply(no.getName());
                    }
                    catch (Exception e) {
                        res = false;
                    }
                    finally {
                        query.setMBeanServer(oldServer);
                    }
                    if (!res) continue;
                    className = null;
                    try {
                        className = this.meta.getMBeanClassName(obj);
                    }
                    catch (JMException x) {
                        if (!DefaultMBeanServerInterceptor.isDebugOn()) break block15;
                        DefaultMBeanServerInterceptor.debug("filterListOfObjects", "Can't obtain class name for " + no.getName() + ": " + x);
                    }
                }
                result.add(new ObjectInstance(no.getName(), className));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set filterListOfObjectInstances(Set list, QueryExp query) {
        if (query == null) {
            return list;
        }
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ObjectInstance oi = (ObjectInstance)i.next();
            boolean res = false;
            MBeanServer oldServer = QueryEval.getMBeanServer();
            query.setMBeanServer(this.server);
            try {
                res = query.apply(oi.getObjectName());
            }
            catch (Exception e) {
                res = false;
            }
            finally {
                query.setMBeanServer(oldServer);
            }
            if (!res) continue;
            result.add(oi);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationListener getListenerWrapper(NotificationListener l, ObjectName name, Object mbean, boolean create) {
        ListenerWrapper wrapper = new ListenerWrapper(l, name, mbean);
        WeakHashMap weakHashMap = this.listenerWrappers;
        synchronized (weakHashMap) {
            NotificationListener existing;
            WeakReference ref = (WeakReference)this.listenerWrappers.get(wrapper);
            if (ref != null && (existing = (NotificationListener)ref.get()) != null) {
                return existing;
            }
            if (create) {
                this.listenerWrappers.put(wrapper, new WeakReference<ListenerWrapper>(wrapper));
                return wrapper;
            }
            return null;
        }
    }

    private static void checkMBeanPermission(String classname, String member, ObjectName objectName, String actions) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanPermission perm = new MBeanPermission(classname, member, objectName, actions);
            sm.checkPermission(perm);
        }
    }

    private static void checkMBeanTrustPermission(final Class theClass) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanTrustPermission perm = new MBeanTrustPermission("register");
            ProtectionDomain pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return theClass.getProtectionDomain();
                }
            });
            if (!pd.implies(perm)) {
                throw new SecurityException("access denied (" + perm.getClass().getName() + " " + perm.getName() + ")");
            }
        }
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String clz, String func, String info) {
        Trace.send(1, 1, clz, func, info);
    }

    private static void trace(String func, String info) {
        DefaultMBeanServerInterceptor.trace(dbgTag, func, info);
    }

    private static void error(String func, String info) {
        Trace.send(0, 1, dbgTag, func, info);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String clz, String func, String info) {
        Trace.send(2, 1, clz, func, info);
    }

    private static void debug(String func, String info) {
        DefaultMBeanServerInterceptor.debug(dbgTag, func, info);
    }

    private static void debugX(String func, Throwable e) {
        if (DefaultMBeanServerInterceptor.isDebugOn()) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            String stack = s.toString();
            DefaultMBeanServerInterceptor.debug(dbgTag, func, "Exception caught in " + func + "(): " + e);
            DefaultMBeanServerInterceptor.debug(dbgTag, func, stack);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            _MBSDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private NotificationListener listener;
        private ObjectName name;
        private Object mbean;

        ListenerWrapper(NotificationListener l, ObjectName name, Object mbean) {
            this.listener = l;
            this.name = name;
            this.mbean = mbean;
        }

        public void handleNotification(Notification notification, Object handback) {
            if (notification != null && notification.getSource() == this.mbean) {
                notification.setSource(this.name);
            }
            this.listener.handleNotification(notification, handback);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ListenerWrapper)) {
                return false;
            }
            ListenerWrapper w = (ListenerWrapper)o;
            return w.listener == this.listener && w.mbean == this.mbean && w.name.equals(this.name);
        }

        public int hashCode() {
            return System.identityHashCode(this.listener) ^ System.identityHashCode(this.mbean);
        }
    }
}

