/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import [Ljava.lang.String;;
import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.ptr.ByReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Function
extends Pointer {
    public static final int MAX_NARGS = 32;
    public static final int C_CONVENTION = 0;
    public static final int ALT_CONVENTION = 1;
    private NativeLibrary library;
    private String functionName;
    private int callingConvention;

    public Function(String libraryName, String functionName) {
        this(libraryName, functionName, 0);
    }

    public Function(String libraryName, String functionName, int callingConvention) {
        this(NativeLibrary.getInstance(libraryName), functionName, callingConvention);
    }

    Function(NativeLibrary library, String functionName, int callingConvention) {
        this.checkCallingConvention(callingConvention);
        this.library = library;
        this.functionName = functionName;
        this.callingConvention = callingConvention;
        this.peer = library.getFunctionAddress(functionName);
    }

    private void checkCallingConvention(int convention) throws IllegalArgumentException {
        switch (convention) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized calling convention: " + convention);
            }
        }
    }

    public NativeLibrary getLibrary() {
        return this.library;
    }

    public String getLibraryName() {
        return this.library.getName();
    }

    public String getName() {
        return this.functionName;
    }

    public int getCallingConvention() {
        return this.callingConvention;
    }

    public Object invoke(Class returnType, Object[] inArgs) {
        return this.invoke(returnType, inArgs, Collections.EMPTY_MAP);
    }

    public Object invoke(Class returnType, Object[] inArgs, Map options) {
        inArgs = this.concatenateVarArgs(inArgs);
        Object[] args = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 32) {
                throw new UnsupportedOperationException("Maximum argument count is 32");
            }
            args = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args, 0, args.length);
        }
        TypeMapper mapper = (TypeMapper)options.get("type-mapper");
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.convertArgument(args[i], mapper);
        }
        Class nativeType = returnType;
        FromNativeConverter resultConverter = null;
        if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType)) != null) {
            nativeType = resultConverter.nativeType();
        }
        Object result = this.invoke(args, nativeType);
        if (resultConverter != null) {
            FunctionResultContext context = new FunctionResultContext(returnType, this, inArgs);
            result = resultConverter.fromNative(result, context);
        }
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                Object arg = inArgs[i];
                if (arg == null) continue;
                if (arg instanceof Structure) {
                    ((Structure)arg).read();
                    continue;
                }
                if ((array$Ljava$lang$String == null ? Function.class$("[Ljava.lang.String;") : array$Ljava$lang$String) == arg.getClass()) {
                    StringArray buf = (StringArray)args[i];
                    String[] array = (String[])arg;
                    for (int si = 0; si < array.length; ++si) {
                        array[si] = buf.getPointer(si * Pointer.SIZE).getString(0);
                    }
                    continue;
                }
                if (!this.isStructureArray(arg.getClass())) continue;
                Structure[] ss = (Structure[])arg;
                for (int si = 0; si < ss.length; ++si) {
                    ss[si].read();
                }
            }
        }
        return result;
    }

    private Object[] concatenateVarArgs(Object[] inArgs) {
        if (inArgs != null && inArgs.length > 0) {
            Class<?> argType;
            Object lastArg = inArgs[inArgs.length - 1];
            Class<?> clazz = argType = lastArg != null ? lastArg.getClass() : null;
            if (argType != null && argType.isArray() && !this.isPrimitiveArray(argType) && !this.isStructureArray(argType) && argType != String;.class) {
                Object[] varArgs = (Object[])lastArg;
                Object[] fullArgs = new Object[inArgs.length + varArgs.length];
                System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
                System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, varArgs.length);
                fullArgs[fullArgs.length - 1] = null;
                inArgs = fullArgs;
            }
        }
        return inArgs;
    }

    private Object invoke(Object[] args, Class returnType) {
        if (returnType == null || returnType == Void.TYPE || returnType == Void.class) {
            this.invokeVoid(this.callingConvention, args);
            return null;
        }
        if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            return new Boolean(this.invokeInt(this.callingConvention, args) != 0);
        }
        if (returnType == Byte.TYPE || returnType == Byte.class) {
            return new Byte((byte)this.invokeInt(this.callingConvention, args));
        }
        if (returnType == Short.TYPE || returnType == Short.class) {
            return new Short((short)this.invokeInt(this.callingConvention, args));
        }
        if (returnType == Character.TYPE || returnType == Character.class) {
            return new Character((char)this.invokeInt(this.callingConvention, args));
        }
        if (returnType == Integer.TYPE || returnType == Integer.class) {
            return new Integer(this.invokeInt(this.callingConvention, args));
        }
        if (returnType == Long.TYPE || returnType == Long.class) {
            return new Long(this.invokeLong(this.callingConvention, args));
        }
        if (returnType == NativeLong.class) {
            return new NativeLong(NativeLong.SIZE == 8 ? this.invokeLong(this.callingConvention, args) : (long)this.invokeInt(this.callingConvention, args));
        }
        if (returnType == Float.TYPE || returnType == Float.class) {
            return new Float(this.invokeFloat(this.callingConvention, args));
        }
        if (returnType == Double.TYPE || returnType == Double.class) {
            return new Double(this.invokeDouble(this.callingConvention, args));
        }
        if (returnType == String.class) {
            return this.invokeString(this.callingConvention, args, false);
        }
        if (returnType == WString.class) {
            return new WString(this.invokeString(this.callingConvention, args, true));
        }
        if (Pointer.class.isAssignableFrom(returnType)) {
            return this.invokePointer(this.callingConvention, args);
        }
        if (Structure.class.isAssignableFrom(returnType)) {
            Object result = this.invokePointer(this.callingConvention, args);
            if (result != null) {
                try {
                    Structure s = (Structure)returnType.newInstance();
                    s.useMemory((Pointer)result);
                    s.read();
                    result = s;
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Instantiation of " + returnType + " failed: " + e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Not allowed to instantiate " + returnType + ": " + e);
                }
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported return type " + returnType);
    }

    private Object convertArgument(Object arg, TypeMapper mapper) {
        ToNativeConverter converter;
        if (arg != null && mapper != null && (converter = mapper.getToNativeConverter(arg.getClass())) != null) {
            arg = converter.toNative(arg);
        }
        if (arg == null || this.isPrimitiveArray(arg.getClass())) {
            return arg;
        }
        Class<?> argClass = arg.getClass();
        if (arg instanceof Structure) {
            Structure struct = (Structure)arg;
            struct.write();
            return struct.getPointer();
        }
        if (arg instanceof ByReference) {
            return ((ByReference)arg).getPointer();
        }
        if (arg instanceof Callback) {
            CallbackReference cbref = CallbackReference.getInstance((Callback)arg);
            return cbref.getTrampoline();
        }
        if (arg instanceof String) {
            return new NativeString((String)arg, false).getPointer();
        }
        if (arg instanceof WString) {
            return new NativeString(arg.toString(), true).getPointer();
        }
        if (arg instanceof NativeLong) {
            return ((NativeLong)arg).asNativeValue();
        }
        if (arg instanceof Boolean) {
            return new Integer(Boolean.TRUE.equals(arg) ? -1 : 0);
        }
        if (String;.class == argClass) {
            return new StringArray((String[])arg);
        }
        if (this.isStructureArray(argClass)) {
            Structure[] ss = (Structure[])arg;
            if (ss.length == 0) {
                return null;
            }
            if (ss[0] == null) {
                Class<?> type = argClass.getComponentType();
                try {
                    Structure struct = (Structure)type.newInstance();
                    int size = struct.size();
                    Memory m = new Memory(size * ss.length);
                    struct.useMemory(m);
                    Structure[] tmp = struct.toArray(ss.length);
                    for (int si = 0; si < ss.length; ++si) {
                        ss[si] = tmp[si];
                    }
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Instantiation of " + type + " failed: " + e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Not allowed to instantiate " + type + ": " + e);
                }
                return ss[0].getPointer();
            }
            Pointer base = ss[0].getPointer();
            int size = ss[0].size();
            ss[0].write();
            for (int si = 1; si < ss.length; ++si) {
                try {
                    Pointer p = base.share(size * si, size);
                    if (ss[si].getPointer().peer != p.peer) {
                        throw new RuntimeException();
                    }
                    ss[si].write();
                    continue;
                }
                catch (RuntimeException e) {
                    String msg = "Structure array elements must use contiguous memory: " + si;
                    throw new IllegalArgumentException(msg);
                }
            }
            return base;
        }
        if (arg instanceof ByteBuffer && !((ByteBuffer)arg).isDirect()) {
            ByteBuffer buf = (ByteBuffer)arg;
            if (buf.hasArray()) {
                return buf.array();
            }
            throw new IllegalArgumentException("Unsupported non-direct ByteBuffer with no array");
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException("Unsupported array argument type: " + argClass.getComponentType());
        }
        return arg;
    }

    private boolean isStructureArray(Class argClass) {
        return argClass.isArray() && Structure.class.isAssignableFrom(argClass.getComponentType());
    }

    private boolean isPrimitiveArray(Class argClass) {
        return argClass.isArray() && argClass.getComponentType().isPrimitive();
    }

    private native int invokeInt(int var1, Object[] var2);

    private native long invokeLong(int var1, Object[] var2);

    public void invoke(Object[] args) {
        this.invoke(Void.class, args);
    }

    private native void invokeVoid(int var1, Object[] var2);

    private native float invokeFloat(int var1, Object[] var2);

    private native double invokeDouble(int var1, Object[] var2);

    private String invokeString(int callingConvention, Object[] args, boolean wide) {
        Pointer ptr = this.invokePointer(callingConvention, args);
        String s = null;
        if (ptr != null) {
            s = wide ? ptr.getString(0, wide) : ptr.getString(0);
        }
        return s;
    }

    private native Pointer invokePointer(int var1, Object[] var2);

    public String toString() {
        return "native function " + this.functionName + "(" + this.library.getName() + ")@0x" + Long.toHexString(this.peer);
    }

    public Pointer invokePointer(Object[] args) {
        return (Pointer)this.invoke(Pointer.class, args);
    }

    public String invokeString(Object[] args, boolean wide) {
        Class clazz = wide ? WString.class : String.class;
        Object o = this.invoke(clazz, args);
        return o != null ? o.toString() : null;
    }

    public int invokeInt(Object[] args) {
        return (Integer)this.invoke(Integer.class, args);
    }

    public long invokeLong(Object[] args) {
        return (Long)this.invoke(Long.class, args);
    }

    public float invokeFloat(Object[] args) {
        return ((Float)this.invoke(Float.class, args)).floatValue();
    }

    public double invokeDouble(Object[] args) {
        return (Double)this.invoke(Double.class, args);
    }

    public void invokeVoid(Object[] args) {
        this.invoke(Void.class, args);
    }

    private class StringArray
    extends Memory {
        private List natives;

        public StringArray(String[] strings) {
            super((strings.length + 1) * Pointer.SIZE);
            this.natives = new ArrayList();
            for (int i = 0; i < strings.length; ++i) {
                NativeString ns = new NativeString(strings[i]);
                this.natives.add(ns);
                this.setPointer(Pointer.SIZE * i, ns.getPointer());
            }
            this.setPointer(Pointer.SIZE * strings.length, null);
        }
    }
}

