/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import [Ljava.lang.Object;;
import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackInvocationContext;
import com.sun.jna.CallbackProxy;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;

class CallbackReference
extends WeakReference {
    static final Map callbackMap = new WeakHashMap();
    static final Map altCallbackMap = new WeakHashMap();
    Pointer cbstruct;
    CallbackProxy proxy;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$NativeLong;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jna$WString;

    public static CallbackReference getInstance(Callback callback) {
        int callingConvention = callback instanceof AltCallingConvention ? 1 : 0;
        return CallbackReference.getInstance(callback, callingConvention);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallbackReference getInstance(Callback callback, int callingConvention) {
        Map map;
        Map map2 = map = callingConvention == 1 ? altCallbackMap : callbackMap;
        synchronized (map2) {
            CallbackReference cbref = (CallbackReference)map.get(callback);
            if (cbref == null) {
                cbref = new CallbackReference(callback, callingConvention);
                map.put(callback, cbref);
            }
            return cbref;
        }
    }

    private CallbackReference(Callback callback, int callingConvention) {
        super(callback);
        int i;
        Class<?> type = callback.getClass();
        Class<?>[] ifaces = type.getInterfaces();
        for (int i2 = 0; i2 < ifaces.length; ++i2) {
            if (!(class$com$sun$jna$Callback == null ? CallbackReference.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(ifaces[i2])) continue;
            type = ifaces[i2];
            break;
        }
        TypeMapper mapper = null;
        Class<?> declaring = type.getDeclaringClass();
        if (declaring != null) {
            mapper = Native.getTypeMapper(declaring);
        }
        Method m = this.getCallbackMethod(callback);
        this.proxy = new DefaultCallbackProxy(m, mapper);
        Class[] nativeParamTypes = this.proxy.getParameterTypes();
        if (mapper != null) {
            for (i = 0; i < nativeParamTypes.length; ++i) {
                FromNativeConverter rc = mapper.getFromNativeConverter(nativeParamTypes[i]);
                if (rc == null) continue;
                nativeParamTypes[i] = rc.nativeType();
            }
        }
        for (i = 0; i < nativeParamTypes.length; ++i) {
            Class cls;
            if ((class$com$sun$jna$Structure == null ? CallbackReference.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(cls = nativeParamTypes[i])) {
                try {
                    cls.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Can't instantiate " + cls + ": " + e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Instantiation of " + cls + " not allowed (is it public?): " + e);
                }
                nativeParamTypes[i] = class$com$sun$jna$Pointer == null ? CallbackReference.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer;
                continue;
            }
            if ((class$com$sun$jna$NativeLong == null ? CallbackReference.class$("com.sun.jna.NativeLong") : class$com$sun$jna$NativeLong).isAssignableFrom(cls)) {
                nativeParamTypes[i] = NativeLong.SIZE == 4 ? (class$java$lang$Integer == null ? CallbackReference.class$("java.lang.Integer") : class$java$lang$Integer) : (class$java$lang$Long == null ? CallbackReference.class$("java.lang.Long") : class$java$lang$Long);
                continue;
            }
            if (cls == (class$java$lang$String == null ? CallbackReference.class$("java.lang.String") : class$java$lang$String) || cls == (class$com$sun$jna$WString == null ? CallbackReference.class$("com.sun.jna.WString") : class$com$sun$jna$WString)) {
                nativeParamTypes[i] = class$com$sun$jna$Pointer == null ? CallbackReference.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer;
                continue;
            }
            if (CallbackReference.isAllowableNativeType(cls)) continue;
            throw new IllegalArgumentException("Callback argument " + cls + " requires custom type conversion");
        }
        try {
            Method proxyMethod = CallbackProxy.class.getMethod("callback", Object;.class);
            this.cbstruct = CallbackReference.createCallback(this.proxy, proxyMethod, nativeParamTypes, callingConvention);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Unexpectedly missing CallbackProxy.callback(Object[])");
        }
    }

    private Method getCallbackMethod(Callback callback) {
        Method[] mlist = callback.getClass().getMethods();
        for (int mi = 0; mi < mlist.length; ++mi) {
            Method m = mlist[mi];
            if (!"callback".equals(m.getName())) continue;
            if (m.getParameterTypes().length > 32) {
                String msg = "Method signature exceeds the maximum parameter count: " + m;
                throw new IllegalArgumentException(msg);
            }
            return m;
        }
        String msg = "Callback must implement method named 'callback'";
        throw new IllegalArgumentException(msg);
    }

    public Pointer getTrampoline() {
        return this.cbstruct.getPointer(0);
    }

    protected void finalize() {
        CallbackReference.freeCallback(this.cbstruct.peer);
        this.cbstruct.peer = 0L;
    }

    private Callback getCallback() {
        return (Callback)this.get();
    }

    static boolean isAllowableNativeType(Class cls) {
        return cls == Boolean.TYPE || cls == Boolean.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Character.TYPE || cls == Character.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == Float.TYPE || cls == Float.class || cls == Double.TYPE || cls == Double.class || Pointer.class.isAssignableFrom(cls);
    }

    private static native Pointer createCallback(CallbackProxy var0, Method var1, Class[] var2, int var3);

    private static native void freeCallback(long var0);

    private class DefaultCallbackProxy
    implements CallbackProxy {
        private Method callbackMethod;
        private ToNativeConverter toNative;
        private FromNativeConverter[] fromNative;

        public DefaultCallbackProxy(Method callbackMethod, TypeMapper mapper) {
            this.callbackMethod = callbackMethod;
            Class<?>[] argTypes = callbackMethod.getParameterTypes();
            this.fromNative = new FromNativeConverter[argTypes.length];
            if (mapper != null) {
                this.toNative = mapper.getToNativeConverter(callbackMethod.getReturnType());
                for (int i = 0; i < this.fromNative.length; ++i) {
                    this.fromNative[i] = mapper.getFromNativeConverter(argTypes[i]);
                }
            }
            if (!callbackMethod.isAccessible()) {
                try {
                    callbackMethod.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("Callback method is inaccessible, make sure the interface is public: " + callbackMethod);
                }
            }
        }

        public Object callback(Object[] args) {
            Class<?>[] paramTypes = this.callbackMethod.getParameterTypes();
            Object[] callbackArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (this.fromNative[i] != null) {
                    CallbackInvocationContext context = new CallbackInvocationContext(paramTypes[i], this.callbackMethod, args);
                    args[i] = this.fromNative[i].fromNative(args[i], context);
                }
                callbackArgs[i] = this.convertArgument(args[i], paramTypes[i]);
            }
            Object result = null;
            Callback cb = CallbackReference.this.getCallback();
            if (cb != null) {
                try {
                    result = this.convertResult(this.callbackMethod.invoke((Object)cb, callbackArgs));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        private Object convertArgument(Object value, Class dstType) {
            if (value instanceof Pointer) {
                if (dstType == (class$java$lang$String == null ? (class$java$lang$String = CallbackReference.class$("java.lang.String")) : class$java$lang$String)) {
                    value = ((Pointer)value).getString(0);
                } else if (dstType == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
                    value = new WString(((Pointer)value).getString(0, true));
                } else if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(dstType)) {
                    Pointer p = (Pointer)value;
                    try {
                        Structure s = (Structure)dstType.newInstance();
                        s.useMemory(p);
                        s.read();
                        value = s;
                    }
                    catch (InstantiationException e) {
                    }
                    catch (IllegalAccessException e) {}
                }
            } else if ((class$com$sun$jna$NativeLong == null ? (class$com$sun$jna$NativeLong = CallbackReference.class$("com.sun.jna.NativeLong")) : class$com$sun$jna$NativeLong).isAssignableFrom(dstType) && (value instanceof Integer || value instanceof Long)) {
                value = new NativeLong(NativeLong.SIZE == 4 ? (long)((Integer)value).intValue() : (Long)value);
            } else if ((Boolean.TYPE == dstType || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CallbackReference.class$("java.lang.Boolean")) : class$java$lang$Boolean) == dstType) && value instanceof Number) {
                value = ((Number)value).intValue() != 0;
            }
            return value;
        }

        private Object convertResult(Object value) {
            Class<?> cls;
            if (this.toNative != null) {
                value = this.toNative.toNative(value);
            }
            if (value == null) {
                return null;
            }
            if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls = value.getClass())) {
                return ((Structure)value).getPointer();
            }
            if ((class$com$sun$jna$NativeLong == null ? (class$com$sun$jna$NativeLong = CallbackReference.class$("com.sun.jna.NativeLong")) : class$com$sun$jna$NativeLong).isAssignableFrom(cls)) {
                return ((NativeLong)value).asNativeValue();
            }
            if (cls == Boolean.TYPE || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CallbackReference.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return new Integer(Boolean.TRUE.equals(value) ? -1 : 0);
            }
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = CallbackReference.class$("java.lang.String")) : class$java$lang$String)) {
                return new NativeString(value.toString()).getPointer();
            }
            if (cls == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
                return new NativeString(value.toString(), true).getPointer();
            }
            if (!CallbackReference.isAllowableNativeType(cls)) {
                throw new IllegalArgumentException("Return type " + cls + " will be ignored");
            }
            return value;
        }

        public Class[] getParameterTypes() {
            return this.callbackMethod.getParameterTypes();
        }

        public Class getReturnType() {
            return this.callbackMethod.getReturnType();
        }
    }
}

