/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.EncodingInfo;
import org.apache.xml.serialize.IndentPrinter;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Printer;
import org.apache.xml.serialize.Serializer;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class BaseMarkupSerializer
implements ContentHandler,
DocumentHandler,
LexicalHandler,
DTDHandler,
DeclHandler,
DOMSerializer,
Serializer {
    protected Hashtable fFeatures;
    protected DOMErrorHandler fDOMErrorHandler;
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    private EncodingInfo _encodingInfo;
    private ElementState[] _elementStates;
    private int _elementStateCount;
    private Vector _preRoot;
    protected boolean _started;
    private boolean _prepared;
    protected Hashtable _prefixes;
    protected String _docTypePublicId;
    protected String _docTypeSystemId;
    protected OutputFormat _format;
    protected Printer _printer;
    protected boolean _indenting;
    protected final StringBuffer fStrBuffer = new StringBuffer(40);
    private Writer _writer;
    private OutputStream _output;
    private Node fCurrentNode = null;
    static /* synthetic */ Class class$java$lang$String;

    protected BaseMarkupSerializer(OutputFormat format) {
        this._elementStates = new ElementState[10];
        int i = 0;
        while (i < this._elementStates.length) {
            this._elementStates[i] = new ElementState();
            ++i;
        }
        this._format = format;
    }

    public DocumentHandler asDocumentHandler() throws IOException {
        this.prepare();
        return this;
    }

    public ContentHandler asContentHandler() throws IOException {
        this.prepare();
        return this;
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        this.prepare();
        return this;
    }

    public void setOutputByteStream(OutputStream output) {
        if (output == null) {
            throw new NullPointerException("SER001 Argument 'output' is null.");
        }
        this._output = output;
        this._writer = null;
        this.reset();
    }

    public void setOutputCharStream(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("SER001 Argument 'writer' is null.");
        }
        this._writer = writer;
        this._output = null;
        this.reset();
    }

    public void setOutputFormat(OutputFormat format) {
        if (format == null) {
            throw new NullPointerException("SER001 Argument 'format' is null.");
        }
        this._format = format;
        this.reset();
    }

    public boolean reset() {
        if (this._elementStateCount > 1) {
            throw new IllegalStateException("Serializer reset in the middle of serialization");
        }
        this._prepared = false;
        this.fCurrentNode = null;
        this.fStrBuffer.setLength(0);
        return true;
    }

    protected void prepare() throws IOException {
        if (this._prepared) {
            return;
        }
        if (this._writer == null && this._output == null) {
            throw new IOException("SER002 No writer supplied for serializer");
        }
        this._encodingInfo = this._format.getEncodingInfo();
        if (this._output != null) {
            this._writer = this._encodingInfo.getWriter(this._output);
        }
        if (this._format.getIndenting()) {
            this._indenting = true;
            this._printer = new IndentPrinter(this._writer, this._format);
        } else {
            this._indenting = false;
            this._printer = new Printer(this._writer, this._format);
        }
        this._elementStateCount = 0;
        ElementState state = this._elementStates[0];
        state.namespaceURI = null;
        state.localName = null;
        state.rawName = null;
        state.preserveSpace = this._format.getPreserveSpace();
        state.empty = true;
        state.afterElement = false;
        state.afterComment = false;
        state.inCData = false;
        state.doCData = false;
        state.prefixes = null;
        this._docTypePublicId = this._format.getDoctypePublic();
        this._docTypeSystemId = this._format.getDoctypeSystem();
        this._started = false;
        this._prepared = true;
    }

    public void serialize(Element elem) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(elem);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    public void serialize(DocumentFragment frag) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(frag);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    public void serialize(Document doc) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(doc);
        this.serializePreRoot();
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.prepare();
        }
        catch (IOException except) {
            throw new SAXException(except.toString());
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            ElementState state = this.content();
            if (state.inCData || state.doCData) {
                if (!state.inCData) {
                    this._printer.printText("<![CDATA[");
                    state.inCData = true;
                }
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                int index = 0;
                while (index < length) {
                    if (index + 2 < length && chars[index] == ']' && chars[index + 1] == ']' && chars[index + 2] == '>') {
                        this.printText(chars, start, index + 2, true, true);
                        this._printer.printText("]]><![CDATA[");
                        start += index + 2;
                        length -= index + 2;
                        index = 0;
                    }
                    ++index;
                }
                if (length > 0) {
                    this.printText(chars, start, length, true, true);
                }
                this._printer.setNextIndent(saveIndent);
            } else if (state.preserveSpace) {
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(chars, start, length, true, state.unescaped);
                this._printer.setNextIndent(saveIndent);
            } else {
                this.printText(chars, start, length, false, state.unescaped);
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        try {
            this.content();
            if (this._indenting) {
                this._printer.setThisIndent(0);
                int i = start;
                while (length-- > 0) {
                    this._printer.printText(chars[i]);
                    ++i;
                }
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public final void processingInstruction(String target, String code) throws SAXException {
        try {
            this.processingInstructionIO(target, code);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void processingInstructionIO(String target, String code) throws IOException {
        ElementState state = this.content();
        int index = target.indexOf("?>");
        if (index >= 0) {
            this.fStrBuffer.append("<?").append(target.substring(0, index));
        } else {
            this.fStrBuffer.append("<?").append(target);
        }
        if (code != null) {
            this.fStrBuffer.append(' ');
            index = code.indexOf("?>");
            if (index >= 0) {
                this.fStrBuffer.append(code.substring(0, index));
            } else {
                this.fStrBuffer.append(code);
            }
        }
        this.fStrBuffer.append("?>");
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                state.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
    }

    public void comment(char[] chars, int start, int length) throws SAXException {
        try {
            this.comment(new String(chars, start, length));
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void comment(String text) throws IOException {
        if (this._format.getOmitComments()) {
            return;
        }
        ElementState state = this.content();
        int index = text.indexOf("-->");
        if (index >= 0) {
            this.fStrBuffer.append("<!--").append(text.substring(0, index)).append("-->");
        } else {
            this.fStrBuffer.append("<!--").append(text).append("-->");
        }
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            if (this._indenting && !state.preserveSpace) {
                this._printer.breakLine();
            }
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                state.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
        state.afterComment = true;
        state.afterElement = false;
    }

    public void startCDATA() {
        ElementState state = this.getElementState();
        state.doCData = true;
    }

    public void endCDATA() {
        ElementState state = this.getElementState();
        state.doCData = false;
    }

    public void startNonEscaping() {
        ElementState state = this.getElementState();
        state.unescaped = true;
    }

    public void endNonEscaping() {
        ElementState state = this.getElementState();
        state.unescaped = false;
    }

    public void startPreserving() {
        ElementState state = this.getElementState();
        state.preserveSpace = true;
    }

    public void endPreserving() {
        ElementState state = this.getElementState();
        state.preserveSpace = false;
    }

    public void endDocument() throws SAXException {
        try {
            this.serializePreRoot();
            this._printer.flush();
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
        try {
            this.endCDATA();
            this.content();
            this._printer.printText('&');
            this._printer.printText(name);
            this._printer.printText(';');
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._prefixes == null) {
            this._prefixes = new Hashtable();
        }
        this._prefixes.put(uri, prefix == null ? "" : prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            this._printer.enterDTD();
            this._docTypePublicId = publicId;
            this._docTypeSystemId = systemId;
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endDTD() {
    }

    public void elementDecl(String name, String model) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ELEMENT ");
            this._printer.printText(name);
            this._printer.printText(' ');
            this._printer.printText(model);
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ATTLIST ");
            this._printer.printText(eName);
            this._printer.printText(' ');
            this._printer.printText(aName);
            this._printer.printText(' ');
            this._printer.printText(type);
            if (valueDefault != null) {
                this._printer.printText(' ');
                this._printer.printText(valueDefault);
            }
            if (value != null) {
                this._printer.printText(" \"");
                this.printEscaped(value);
                this._printer.printText('\"');
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ENTITY ");
            this._printer.printText(name);
            this._printer.printText(" \"");
            this.printEscaped(value);
            this._printer.printText("\">");
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        try {
            this._printer.enterDTD();
            this.unparsedEntityDecl(name, publicId, systemId, null);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        try {
            this._printer.enterDTD();
            if (publicId == null) {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(name);
                this._printer.printText(" SYSTEM ");
                this.printDoctypeURL(systemId);
            } else {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(name);
                this._printer.printText(" PUBLIC ");
                this.printDoctypeURL(publicId);
                this._printer.printText(' ');
                this.printDoctypeURL(systemId);
            }
            if (notationName != null) {
                this._printer.printText(" NDATA ");
                this._printer.printText(notationName);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        try {
            this._printer.enterDTD();
            if (publicId != null) {
                this._printer.printText("<!NOTATION ");
                this._printer.printText(name);
                this._printer.printText(" PUBLIC ");
                this.printDoctypeURL(publicId);
                if (systemId != null) {
                    this._printer.printText(' ');
                    this.printDoctypeURL(systemId);
                }
            } else {
                this._printer.printText("<!NOTATION ");
                this._printer.printText(name);
                this._printer.printText(" SYSTEM ");
                this.printDoctypeURL(systemId);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serializeNode(Node node) throws IOException {
        this.fCurrentNode = node;
        switch (node.getNodeType()) {
            case 3: {
                String text = node.getNodeValue();
                if (text == null) return;
                if (this._indenting && !this.getElementState().preserveSpace) {
                    if (text.replace('\n', ' ').trim().length() == 0) return;
                }
                this.characters(text);
                return;
            }
            case 4: {
                String text = node.getNodeValue();
                if (text == null) return;
                this.startCDATA();
                this.characters(text);
                this.endCDATA();
                return;
            }
            case 8: {
                if (this._format.getOmitComments()) return;
                String text = node.getNodeValue();
                if (text == null) return;
                this.comment(text);
                return;
            }
            case 5: {
                this.endCDATA();
                this.content();
                Node child = node.getFirstChild();
                if (child == null || this.fFeatures != null && !((Boolean)this.fFeatures.get("expand-entity-references")).booleanValue()) {
                    this._printer.printText("&");
                    this._printer.printText(node.getNodeName());
                    this._printer.printText(";");
                    return;
                }
                while (true) {
                    if (child == null) {
                        return;
                    }
                    this.serializeNode(child);
                    child = child.getNextSibling();
                }
            }
            case 7: {
                this.processingInstructionIO(node.getNodeName(), node.getNodeValue());
                return;
            }
            case 1: {
                this.serializeElement((Element)node);
                return;
            }
            case 9: {
                DocumentType docType = ((Document)node).getDoctype();
                if (docType != null) {
                    DOMImplementation domImpl = ((Document)node).getImplementation();
                    try {
                        this._printer.enterDTD();
                        this._docTypePublicId = docType.getPublicId();
                        this._docTypeSystemId = docType.getSystemId();
                        String internal = docType.getInternalSubset();
                        if (internal != null && internal.length() > 0) {
                            this._printer.printText(internal);
                        }
                        this.endDTD();
                    }
                    catch (NoSuchMethodError nsme) {
                        Class<?> docTypeClass = docType.getClass();
                        String docTypePublicId = null;
                        String docTypeSystemId = null;
                        try {
                            Method getPublicId = docTypeClass.getMethod("getPublicId", null);
                            if (getPublicId.getReturnType().equals(class$java$lang$String == null ? (class$java$lang$String = BaseMarkupSerializer.class$("java.lang.String")) : class$java$lang$String)) {
                                docTypePublicId = (String)getPublicId.invoke((Object)docType, null);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Method getSystemId = docTypeClass.getMethod("getSystemId", null);
                            if (getSystemId.getReturnType().equals(class$java$lang$String == null ? (class$java$lang$String = BaseMarkupSerializer.class$("java.lang.String")) : class$java$lang$String)) {
                                docTypeSystemId = (String)getSystemId.invoke((Object)docType, null);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this._printer.enterDTD();
                        this._docTypePublicId = docTypePublicId;
                        this._docTypeSystemId = docTypeSystemId;
                        this.endDTD();
                    }
                }
            }
            case 11: {
                Node child = node.getFirstChild();
                while (child != null) {
                    this.serializeNode(child);
                    child = child.getNextSibling();
                }
                return;
            }
        }
    }

    protected ElementState content() throws IOException {
        ElementState state = this.getElementState();
        if (!this.isDocumentState()) {
            if (state.inCData && !state.doCData) {
                this._printer.printText("]]>");
                state.inCData = false;
            }
            if (state.empty) {
                this._printer.printText('>');
                state.empty = false;
            }
            state.afterElement = false;
            state.afterComment = false;
        }
        return state;
    }

    protected void characters(String text) throws IOException {
        ElementState state = this.content();
        if (state.inCData || state.doCData) {
            int index;
            if (!state.inCData) {
                this.fStrBuffer.append("<![CDATA[");
                state.inCData = true;
            }
            if ((index = text.indexOf("]]>")) >= 0 && this.fFeatures != null && !((Boolean)this.fFeatures.get("split-cdata-sections")).booleanValue()) {
                if (this.fDOMErrorHandler != null) {
                    this.modifyDOMError("The character sequence \"]]>\" must not appear in content unless used to mark the end of a CDATA section.", (short)2);
                    boolean continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                    if (!continueProcess) {
                        throw new IOException();
                    }
                }
            } else if (index >= 0 && this.fFeatures != null && ((Boolean)this.fFeatures.get("split-cdata-sections")).booleanValue() && this.fDOMErrorHandler != null) {
                this.modifyDOMError("Spliting a CDATA section containing the CDATA section termination marker ']]>' ", (short)0);
                this.fDOMErrorHandler.handleError(this.fDOMError);
            }
            while (index >= 0) {
                this.fStrBuffer.append(text.substring(0, index + 2)).append("]]><![CDATA[");
                text = text.substring(index + 2);
                index = text.indexOf("]]>");
            }
            this.fStrBuffer.append(text);
            int saveIndent = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printText(this.fStrBuffer.toString(), true, true);
            this.fStrBuffer.setLength(0);
            this._printer.setNextIndent(saveIndent);
        } else if (state.preserveSpace) {
            int saveIndent = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printText(text, true, state.unescaped);
            this._printer.setNextIndent(saveIndent);
        } else {
            this.printText(text, false, state.unescaped);
        }
    }

    protected abstract String getEntityRef(int var1);

    protected abstract void serializeElement(Element var1) throws IOException;

    protected void serializePreRoot() throws IOException {
        if (this._preRoot != null) {
            int i = 0;
            while (i < this._preRoot.size()) {
                this.printText((String)this._preRoot.elementAt(i), true, true);
                if (this._indenting) {
                    this._printer.breakLine();
                }
                ++i;
            }
            this._preRoot.removeAllElements();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        block5: {
            if (!preserveSpace) ** GOTO lbl20
            while (length-- > 0) {
                ch = chars[start];
                ++start;
                if (ch == '\n' || ch == '\r' || unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ch = chars[start];
                ++start;
                if (ch == ' ' || ch == '\f' || ch == '\t' || ch == '\n' || ch == '\r') {
                    this._printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
lbl20:
                // 4 sources

                ** while (length-- > 0)
            }
        }
    }

    protected final void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            int index = 0;
            while (index < text.length()) {
                char ch = text.charAt(index);
                if (ch == '\n' || ch == '\r' || unescaped) {
                    this._printer.printText(ch);
                } else {
                    this.printEscaped(ch);
                }
                ++index;
            }
        } else {
            int index = 0;
            while (index < text.length()) {
                char ch = text.charAt(index);
                if (ch == ' ' || ch == '\f' || ch == '\t' || ch == '\n' || ch == '\r') {
                    this._printer.printSpace();
                } else if (unescaped) {
                    this._printer.printText(ch);
                } else {
                    this.printEscaped(ch);
                }
                ++index;
            }
        }
    }

    protected void printDoctypeURL(String url) throws IOException {
        this._printer.printText('\"');
        int i = 0;
        while (i < url.length()) {
            if (url.charAt(i) == '\"' || url.charAt(i) < ' ' || url.charAt(i) > '\u007f') {
                this._printer.printText('%');
                this._printer.printText(Integer.toHexString(url.charAt(i)));
            } else {
                this._printer.printText(url.charAt(i));
            }
            ++i;
        }
        this._printer.printText('\"');
    }

    protected void printEscaped(int ch) throws IOException {
        String charRef = this.getEntityRef(ch);
        if (charRef != null) {
            this._printer.printText('&');
            this._printer.printText(charRef);
            this._printer.printText(';');
        } else if (ch >= 32 && this._encodingInfo.isPrintable(ch) && ch != 247 || ch == 10 || ch == 13 || ch == 9) {
            if (ch < 65536) {
                this._printer.printText((char)ch);
            } else {
                this._printer.printText((char)((ch - 65536 >> 10) + 55296));
                this._printer.printText((char)((ch - 65536 & 0x3FF) + 56320));
            }
        } else {
            this._printer.printText("&#x");
            this._printer.printText(Integer.toHexString(ch));
            this._printer.printText(';');
        }
    }

    protected void printEscaped(String source) throws IOException {
        int i = 0;
        while (i < source.length()) {
            char lowch;
            int ch = source.charAt(i);
            if ((ch & 0xFC00) == 55296 && i + 1 < source.length() && ((lowch = source.charAt(i + 1)) & 0xFC00) == 56320) {
                ch = 65536 + (ch - 55296 << 10) + lowch - 56320;
                ++i;
            }
            this.printEscaped(ch);
            ++i;
        }
    }

    protected ElementState getElementState() {
        return this._elementStates[this._elementStateCount];
    }

    protected ElementState enterElementState(String namespaceURI, String localName, String rawName, boolean preserveSpace) {
        if (this._elementStateCount + 1 == this._elementStates.length) {
            ElementState[] newStates = new ElementState[this._elementStates.length + 10];
            int i = 0;
            while (i < this._elementStates.length) {
                newStates[i] = this._elementStates[i];
                ++i;
            }
            int i2 = this._elementStates.length;
            while (i2 < newStates.length) {
                newStates[i2] = new ElementState();
                ++i2;
            }
            this._elementStates = newStates;
        }
        ++this._elementStateCount;
        ElementState state = this._elementStates[this._elementStateCount];
        state.namespaceURI = namespaceURI;
        state.localName = localName;
        state.rawName = rawName;
        state.preserveSpace = preserveSpace;
        state.empty = true;
        state.afterElement = false;
        state.afterComment = false;
        state.inCData = false;
        state.doCData = false;
        state.unescaped = false;
        state.prefixes = this._prefixes;
        this._prefixes = null;
        return state;
    }

    protected ElementState leaveElementState() {
        if (this._elementStateCount > 0) {
            this._prefixes = null;
            --this._elementStateCount;
            return this._elementStates[this._elementStateCount];
        }
        throw new IllegalStateException("Internal error: element state is zero");
    }

    protected boolean isDocumentState() {
        return this._elementStateCount == 0;
    }

    protected String getPrefix(String namespaceURI) {
        String prefix;
        if (this._prefixes != null && (prefix = (String)this._prefixes.get(namespaceURI)) != null) {
            return prefix;
        }
        if (this._elementStateCount == 0) {
            return null;
        }
        int i = this._elementStateCount;
        while (i > 0) {
            if (this._elementStates[i].prefixes != null && (prefix = (String)this._elementStates[i].prefixes.get(namespaceURI)) != null) {
                return prefix;
            }
            --i;
        }
        return null;
    }

    protected DOMError modifyDOMError(String message, short severity) {
        this.fDOMError.reset();
        this.fDOMError.setMessage(message);
        this.fDOMError.setSeverity(severity);
        this.fDOMError.setLocator(new DOMLocatorImpl(-1, -1, -1, this.fCurrentNode, null));
        return this.fDOMError;
    }

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void endElement(String var1) throws SAXException;

    public abstract void startElement(String var1, AttributeList var2) throws SAXException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

