/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class DOMImplementationImpl
extends CoreDOMImplementationImpl
implements DOMImplementation {
    static DOMImplementationImpl singleton = new DOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String feature, String version) {
        boolean anyVersion = version == null || version.length() == 0;
        return feature.equalsIgnoreCase("Core") && (anyVersion || version.equals("1.0") || version.equals("2.0")) || feature.equalsIgnoreCase("XML") && (anyVersion || version.equals("1.0") || version.equals("2.0")) || feature.equalsIgnoreCase("Events") && (anyVersion || version.equals("2.0")) || feature.equalsIgnoreCase("MutationEvents") && (anyVersion || version.equals("2.0")) || feature.equalsIgnoreCase("Traversal") && (anyVersion || version.equals("2.0")) || feature.equalsIgnoreCase("Range") && (anyVersion || version.equals("2.0"));
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) {
        if (!CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        int index = qualifiedName.indexOf(58);
        int lastIndex = qualifiedName.lastIndexOf(58);
        if (index == 0 || index == qualifiedName.length() - 1 || lastIndex != index) {
            throw new DOMException(14, "DOM003 Namespace error");
        }
        return new DocumentTypeImpl(null, qualifiedName, publicID, systemID);
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && doctype.getOwnerDocument() != null) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        DocumentImpl doc = new DocumentImpl(doctype);
        Element e = doc.createElementNS(namespaceURI, qualifiedName);
        doc.appendChild(e);
        return doc;
    }
}

