/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.opt.security.TLSServerHandler;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.TLSMessage;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TLSClientHandler
implements ProfileClient {
    protected SSLSocket ts = null;
    private boolean completed = false;
    private Map env = null;
    private MessageConnection mc = null;
    private String profile = null;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "TLSClientHandler");

    public TLSClientHandler(String profile, Map env) {
        this.profile = profile;
        this.env = env;
    }

    public void initialize(MessageConnection mc) throws IOException {
        String enabledCipherSuites;
        int i;
        int tokens;
        StringTokenizer st;
        this.mc = mc;
        Socket socket = null;
        if (!(mc instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        socket = ((SocketConnectionIf)((Object)mc)).getSocket();
        SSLSocketFactory ssf = (SSLSocketFactory)this.env.get("jmx.remote.tls.socket.factory");
        if (ssf == null) {
            ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        String hostname = ((SocketConnectionIf)((Object)mc)).getHost();
        int port = ((SocketConnectionIf)((Object)mc)).getPort();
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Hostname = " + hostname);
            logger.trace("initialize", "TLS: Port = " + port);
        }
        this.ts = (SSLSocket)ssf.createSocket(socket, hostname, port, true);
        this.ts.setUseClientMode(true);
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Client Mode = " + this.ts.getUseClientMode());
        }
        if (TLSServerHandler.bundledJSSE) {
            String enabledProtocols = (String)this.env.get("jmx.remote.tls.enabled.protocols");
            if (enabledProtocols != null) {
                st = new StringTokenizer(enabledProtocols, " ");
                tokens = st.countTokens();
                String[] enabledProtocolsList = new String[tokens];
                for (i = 0; i < tokens; ++i) {
                    enabledProtocolsList[i] = st.nextToken();
                }
                TLSServerHandler.setEnabledProtocols(this.ts, enabledProtocolsList);
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: Enabled Protocols");
                String[] enabled_p = TLSServerHandler.getEnabledProtocols(this.ts);
                if (enabled_p != null) {
                    StringBuffer str_buffer = new StringBuffer();
                    for (int i2 = 0; i2 < enabled_p.length; ++i2) {
                        str_buffer.append(enabled_p[i2]);
                        if (i2 + 1 >= enabled_p.length) continue;
                        str_buffer.append(", ");
                    }
                    logger.trace("initialize", "TLS: [" + str_buffer + "]");
                } else {
                    logger.trace("initialize", "TLS: []");
                }
            }
        }
        if ((enabledCipherSuites = (String)this.env.get("jmx.remote.tls.enabled.cipher.suites")) != null) {
            st = new StringTokenizer(enabledCipherSuites, " ");
            tokens = st.countTokens();
            String[] enabledCipherSuitesList = new String[tokens];
            for (i = 0; i < tokens; ++i) {
                enabledCipherSuitesList[i] = st.nextToken();
            }
            this.ts.setEnabledCipherSuites(enabledCipherSuitesList);
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Enabled Cipher Suites");
            String[] enabled_cs = this.ts.getEnabledCipherSuites();
            if (enabled_cs != null) {
                StringBuffer str_buffer = new StringBuffer();
                for (int i3 = 0; i3 < enabled_cs.length; ++i3) {
                    str_buffer.append(enabled_cs[i3]);
                    if (i3 + 1 >= enabled_cs.length) continue;
                    str_buffer.append(", ");
                }
                logger.trace("initialize", "TLS: [" + str_buffer + "]");
            } else {
                logger.trace("initialize", "TLS: []");
            }
        }
    }

    public ProfileMessage produceMessage() throws IOException {
        TLSMessage tlspm = new TLSMessage(1);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> TLS client message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + tlspm.getProfileName());
            logger.trace("produceMessage", "Status : " + tlspm.getStatus());
        }
        return tlspm;
    }

    public void consumeMessage(ProfileMessage pm) throws IOException {
        if (!(pm instanceof TLSMessage)) {
            throw new IOException("Unexpected profile message type: " + pm.getClass().getName());
        }
        TLSMessage tlspm = (TLSMessage)pm;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> TLS server message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + tlspm.getProfileName());
            logger.trace("consumeMessage", "Status : " + tlspm.getStatus());
        }
        if (tlspm.getStatus() != 2) {
            throw new IOException("Unexpected TLS status [" + tlspm.getStatus() + "]");
        }
        this.completed = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public void activate() throws IOException {
        if (logger.traceOn()) {
            logger.trace("activate", ">>>>> TLS handshake <<<<<");
            logger.trace("activate", "TLS: Start TLS Handshake");
        }
        this.ts.startHandshake();
        if (logger.traceOn()) {
            SSLSession session = this.ts.getSession();
            if (session != null) {
                logger.trace("activate", "TLS: getCipherSuite = " + session.getCipherSuite());
                logger.trace("activate", "TLS: getPeerHost = " + session.getPeerHost());
                if (TLSServerHandler.bundledJSSE) {
                    logger.trace("activate", "TLS: getProtocol = " + TLSServerHandler.getProtocol(session));
                }
            }
            logger.trace("activate", "TLS: Finish TLS Handshake");
        }
        ((SocketConnectionIf)((Object)this.mc)).setSocket(this.ts);
    }

    public void terminate() throws IOException {
    }

    public String getName() {
        return this.profile;
    }
}

