package sample.form;

import jaxcent.*;
import java.util.*;

/**
  * Jaxcent sample.
  *
  * The step where normally one would run a credit card or other processing.
  */

public class Results extends jaxcent.JaxcentPage {

    // Page items.

    HtmlPara message = new HtmlPara( this, "message" );
    Map dataMap;

    String cardNumber;

    // Constructor initializes a message and starts data processing...

    public Results()
    {
        try {

            dataMap = getAllSessionData( false );

            // Here we would retrieve all data from session, start processing with
            // card gateway, etc.

            cardNumber = (String) dataMap.get( "cardNumber" );

            processorThread.start();
            message.setInnerHTML( "Please wait, processing... (well, actually, just in a Thread.sleep!)" );
        } catch (Jaxception jax) {
            jax.printStackTrace();
        }
    }

    Thread processorThread = new Thread()
    {
        public void run() {
            boolean allZeros = true;
            // Check if cardNumber is all zeros.
            for ( int i = 0; i < cardNumber.length(); i++ ) {
                char ch = cardNumber.charAt( i );
                if ( Character.isDigit( ch ) && ch != '0' ) {
                    allZeros = false;
                    break;
                }
            }

            try {
                Thread.sleep( 2000 );
            } catch (Exception ex) {}

            try {
                if ( allZeros ) {
                    message.setInnerHTML( "<FONT COLOR=\"red\">Transaction failed, please try again!</FONT>" );
                    // Transaction failed!
                } else {
                    // All numbers are good!
                    message.setInnerHTML( "Your order has been successfully processed, etc, etc!  Thank you!  All data you entered has been removed from the session." );
                    // Reset all data.
                    dataMap.clear();
                }
            } catch (Jaxception jax) {
                jax.printStackTrace();
            }
        }
    };
}
