/*
 * Decompiled with CFR 0.152.
 */
package jaxcentFramework;

import java.io.File;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jaxcentFramework.JaxcentUrlInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JaxcentConfig
extends DefaultHandler {
    static SAXParserFactory factory = SAXParserFactory.newInstance();
    String currentElement = null;
    String pageUrl = null;
    String pageClass = null;
    boolean pageSession = false;
    boolean inPage = false;
    boolean autoSessionData = false;
    String error;
    Hashtable urlMap = new Hashtable();
    ClassLoader loader;

    void parseConfigFile(File file) {
        this.error = null;
        this.loader = this.loader;
        this.urlMap.clear();
        if (!file.exists()) {
            this.error = "Jaxcent configuration file \"" + file.getAbsolutePath() + "\" not found on server";
            return;
        }
        if (!file.canRead()) {
            this.error = "Jaxcent configuration file \"" + file.getAbsolutePath() + "\" is not readable";
            return;
        }
        try {
            SAXParser sAXParser = factory.newSAXParser();
            sAXParser.parse(file, (DefaultHandler)this);
        }
        catch (Exception exception) {
            this.error = "Error in Jaxcent configuration file \"" + file.getAbsolutePath() + "\": " + exception.toString();
        }
    }

    String getConfigError() {
        return this.error;
    }

    Hashtable getUrlmap() {
        return this.urlMap;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0 || this.currentElement == null) {
            return;
        }
        String string = new String(cArray, n, n2).trim();
        if (string.equals("")) {
            return;
        }
        if (this.currentElement.equalsIgnoreCase("PagePath")) {
            this.pageUrl = string;
        } else if (this.currentElement.equalsIgnoreCase("PageClass")) {
            this.pageClass = string;
        } else if (this.currentElement.equalsIgnoreCase("AutoSessionData")) {
            if (string.equalsIgnoreCase("true")) {
                this.autoSessionData = true;
            } else if (string.equalsIgnoreCase("false")) {
                this.autoSessionData = false;
            } else if (this.error == null) {
                this.error = "Error in Jaxcent Configuration file: AutoSessionData must be true or false, found \"" + string + "\"";
            }
        } else if (this.currentElement.equalsIgnoreCase("UseSession")) {
            if (string.equalsIgnoreCase("true")) {
                this.pageSession = true;
            } else if (string.equalsIgnoreCase("false")) {
                this.pageSession = false;
            } else if (this.error == null) {
                this.error = "Error in Jaxcent Configuration file: UseSession must be true or false, found \"" + string + "\"";
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentElement = string3 = string3.trim();
        if (string3.equalsIgnoreCase("Page")) {
            this.pageUrl = null;
            this.pageClass = null;
            this.inPage = true;
            this.pageSession = false;
            this.autoSessionData = false;
        } else if (!string3.equalsIgnoreCase("JaxcentConfiguration")) {
            if (string3.equalsIgnoreCase("PagePath") || string3.equalsIgnoreCase("PageClass") || string3.equalsIgnoreCase("AutoSessionData") || string3.equalsIgnoreCase("UseSession")) {
                if (!this.inPage && this.error == null) {
                    this.error = "Error in Jaxcent Configuration file: Tag \"" + string3 + "\" must occur inside a Page tag";
                }
            } else if (this.error == null) {
                this.error = "Error in Jaxcent Configuration file: Unknown tag \"" + string3 + "\"";
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentElement = null;
        if (string3.equalsIgnoreCase("page")) {
            if (this.pageUrl == null || this.pageClass == null) {
                if (this.error == null) {
                    this.error = "Error in Jaxcent Configuration file: PagePath and PageClass must both be specified in PAGE elements";
                }
                return;
            }
            JaxcentUrlInfo jaxcentUrlInfo = new JaxcentUrlInfo();
            jaxcentUrlInfo.path = this.pageUrl;
            jaxcentUrlInfo.className = this.pageClass;
            jaxcentUrlInfo.useSession = this.pageSession;
            jaxcentUrlInfo.autoSessionData = this.autoSessionData;
            jaxcentUrlInfo.cls = null;
            jaxcentUrlInfo.cinfo = null;
            jaxcentUrlInfo.err = null;
            this.urlMap.put(this.pageUrl.trim().toLowerCase(), jaxcentUrlInfo);
            this.inPage = false;
        }
    }
}

