/*
 * Decompiled with CFR 0.152.
 */
package jaxcentConnector;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import jaxcentConnector.JaxcentAppContext;
import jaxcentConnector.JaxcentSession;
import jaxcentFramework.JaxcentContext;
import jaxcentFramework.JaxcentFramework;
import jaxcentFramework.JaxcentHttpMain;

public class JaxcentHttpConnector
implements JaxcentHttpMain {
    JaxcentFramework framework = new JaxcentFramework((JaxcentHttpMain)this);
    JaxcentAppContext appctx;
    boolean runSessionThread;
    Thread sessionThread = null;
    String[] initParams;
    String[] initValues;
    static int cookieId = 1;
    static final int SESSION_CHECK_INTERVAL = 60000;

    public JaxcentHttpConnector(String[] stringArray, String[] stringArray2) {
        this.initParams = stringArray;
        this.initValues = stringArray2;
        this.appctx = new JaxcentAppContext(stringArray, stringArray2);
    }

    public void init() {
        this.framework.init();
    }

    public void terminate() {
        this.stopSessionThread();
    }

    public static String setLogfile(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string, true));
            System.setErr(printStream);
            System.setOut(printStream);
            return null;
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            StringBuffer stringBuffer = new StringBuffer(exception.toString());
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("\r\n");
                stringBuffer.append(stackTraceElementArray[i]);
            }
            return stringBuffer.toString();
        }
    }

    Locale[] getLocales(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Locale[] localeArray = new Locale[stringTokenizer.countTokens()];
        float[] fArray = new float[localeArray.length];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            int n2;
            String string2 = stringTokenizer.nextToken().trim();
            int n3 = string2.indexOf(59);
            float f = 1.0f;
            if (n3 > 0) {
                f = Float.parseFloat(string2.substring(n3 + 1).trim());
                string2 = string2.substring(0, n3).trim();
            }
            for (n2 = n; n2 > 0 && fArray[n2 - 1] < f; --n2) {
            }
            for (int i = n; i > n2; --i) {
                localeArray[i] = localeArray[i - 1];
            }
            localeArray[n2] = new Locale(string2);
            fArray[n2] = f;
        }
        return localeArray;
    }

    public void process(Object[] objectArray, String string, String string2) {
        try {
            String string3 = (String)objectArray[0];
            String string4 = (String)objectArray[1];
            if (string4 != null) {
                this.appctx.setSessionAccessed(string4);
            }
            objectArray[0] = this.parseArgs((String)objectArray[0]);
            objectArray[0] = this.framework.process((Object)objectArray, string, string2);
            if (string4 != null && objectArray[1] == string4) {
                objectArray[1] = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            StringBuffer stringBuffer = new StringBuffer(exception.toString());
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("\r\n");
                stringBuffer.append(stackTraceElementArray[i]);
            }
            objectArray[0] = stringBuffer.toString();
            objectArray[1] = null;
        }
    }

    String[] parseArgs(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n + n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.indexOf("=");
            try {
                if (n3 < 0) {
                    stringArray[n2++] = URLDecoder.decode(string2, "UTF-8");
                    stringArray[n2++] = "";
                    continue;
                }
                stringArray[n2++] = URLDecoder.decode(string2.substring(0, n3), "UTF-8");
                stringArray[n2++] = URLDecoder.decode(string2.substring(n3 + 1), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return stringArray;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Object getAppContext() {
        return this.appctx;
    }

    synchronized void startSessionThread() {
        if (this.sessionThread != null) {
            return;
        }
        this.sessionThread = new Thread(){

            public void run() {
                JaxcentHttpConnector.this.checkSessions();
            }
        };
        this.runSessionThread = true;
        this.sessionThread.start();
    }

    void checkSessions() {
        while (this.runSessionThread) {
            this.appctx.checkSessions();
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {}
        }
    }

    synchronized void stopSessionThread() {
        if (this.sessionThread != null) {
            this.runSessionThread = false;
            this.sessionThread.interrupt();
        }
    }

    public Object getSession(Object object, boolean bl) {
        Object[] objectArray = (Object[])object;
        String string = (String)objectArray[1];
        JaxcentSession jaxcentSession = this.appctx.getSession(string);
        if (jaxcentSession == null && bl) {
            string = Long.toHexString(System.currentTimeMillis()) + "_" + Integer.toHexString(cookieId++);
            jaxcentSession = this.appctx.createSession(string);
            objectArray[1] = string;
            this.startSessionThread();
        }
        return jaxcentSession;
    }

    public synchronized Hashtable getJaxcentHashtable(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        JaxcentSession jaxcentSession = (JaxcentSession)object;
        Hashtable hashtable = (Hashtable)jaxcentSession.getAttribute("jaxcent.SessionData");
        if (hashtable == null && bl) {
            hashtable = new Hashtable();
            jaxcentSession.setAttribute("jaxcent.SessionData", hashtable);
        }
        return hashtable;
    }

    public JaxcentContext getJaxcentContext() {
        return (JaxcentContext)this.appctx.getAttribute("jaxcent.context");
    }

    public void setJaxcentContext(JaxcentContext jaxcentContext) {
        this.appctx.setAttribute("jaxcent.context", jaxcentContext);
    }

    public String getConfigItem(String string) {
        if (this.initParams != null) {
            for (int i = 0; i < this.initParams.length; ++i) {
                if (!string.equalsIgnoreCase(this.initParams[i])) continue;
                return this.initValues[i];
            }
        }
        return null;
    }

    public String getRequestParameter(Object object, String string) {
        if (object == null) {
            return null;
        }
        String[] stringArray = (String[])((Object[])object)[0];
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public String[] getRequestParameterValues(Object object, String string) {
        if (object == null) {
            return null;
        }
        String[] stringArray = (String[])((Object[])object)[0];
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            stringArray2[n2++] = stringArray[i + 1];
        }
        return stringArray2;
    }
}

