/*
 * $Id:InputAdapterExtensionRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.swing.handler.extension;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

import net.sf.jame.core.extension.ExtensionConfig;
import net.sf.jame.core.extension.ExtensionRuntime;
import net.sf.jame.twister.InputAdapterContext;
import net.sf.jame.twister.renderer.RenderContext;

/**
 * @author Andrea Medeghini
 */
public abstract class InputAdapterExtensionRuntime extends ExtensionRuntime {
	/**
	 * @return the renderContext
	 */
	public abstract RenderContext getRenderContext();

	/**
	 * @return the inputAdapterContext
	 */
	public abstract InputAdapterContext getInputAdapterContext();

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processMousePressed(MouseEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processMouseReleased(MouseEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processMouseClicked(MouseEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processMouseEntered(MouseEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processMouseExited(MouseEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processMouseMoved(MouseEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processMouseDragged(MouseEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processKeyPressed(KeyEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processKeyReleased(KeyEvent e);

	/**
	 * @param handler
	 * @param e
	 */
	public abstract void processKeyTyped(KeyEvent e);

	/**
	 * 
	 */
	public abstract void runInputHandler();

	/**
	 * @see net.sf.jame.core.extension.ExtensionRuntime#dispose()
	 */
	@Override
	public void dispose() {
	}

	/**
	 * @param renderContext
	 * @param config
	 */
	public void init(final RenderContext renderContext, final ExtensionConfig config) {
	}
}
