/*
 * $Id:ConfigFrame.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.WindowConstants;

import net.sf.jame.core.swing.util.Buttons;
import net.sf.jame.core.tree.NodeSession;
import net.sf.jame.twister.TwisterConfig;
import net.sf.jame.twister.TwisterTree;
import net.sf.jame.twister.renderer.RenderContext;

/**
 * @author Andrea Medeghini
 */
public class ConfigFrame extends JFrame {
	private static final long serialVersionUID = 1L;
	private static final String CONFIG_FRAME_TITLE = "configFrame.title";
	private static final String CONFIG_FRAME_WIDTH = "configFrame.width";
	private static final String CONFIG_FRAME_MIN_HEIGHT = "configFrame.minHeight";
	private static final String CONFIG_FRAME_MAX_HEIGHT = "configFrame.maxHeight";
	private static final String CONFIG_FRAME_ICON = "configFrame.icon";
	private final NavigationPanel navigationPanel;
	private final TwisterTree twisterTree;
	private final TwisterConfig config;
	private final RenderContext context;
	private final NodeSession session;
	private JFrame configFrame;
	private TwisterConfigPanel configPanel;
	private final NavigationModel model;

	/**
	 * @param config
	 * @param context
	 * @param session
	 * @throws HeadlessException
	 */
	public ConfigFrame(final TwisterConfig config, final TwisterTree twisterTree, final RenderContext context, final NodeSession session) throws HeadlessException {
		this.config = config;
		this.context = context;
		this.session = session;
		this.twisterTree = twisterTree;
		setResizable(false);
		final DefaultNavigationContainer container = new DefaultNavigationContainer();
		model = new NavigationModel(container);
		container.setOpaque(false);
		container.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
		navigationPanel = new NavigationPanel(model);
		final List<JButton> buttons = Buttons.createSegmentedButtons(1, null);
		buttons.get(0).setAction(new AdvancedConfigAction());
		buttons.get(0).setToolTipText(TwisterSwingResources.getInstance().getString("tooltip.advancedConfig"));
		navigationPanel.addButton(buttons.get(0));
		// navigationPanel.setPreferredSize(new Dimension(600, 60));
		// navigationPanel.setMinimumSize(new Dimension(600, 60));
		// navigationPanel.setMaximumSize(new Dimension(600, 60));
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(navigationPanel, BorderLayout.NORTH);
		getContentPane().add(container, BorderLayout.CENTER);
		setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		setTitle(TwisterSwingResources.getInstance().getString(ConfigFrame.CONFIG_FRAME_TITLE));
		final URL resource = ConfigFrame.class.getClassLoader().getResource(TwisterSwingResources.getInstance().getString(ConfigFrame.CONFIG_FRAME_ICON));
		if (resource != null) {
			setIconImage(getToolkit().createImage(resource));
		}
		pack();
	}

	@Override
	public void setVisible(final boolean b) {
		Point p = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
		p.x -= getWidth() / 2;
		p.y -= getHeight() / 2;
		setLocation(p);
		super.setVisible(b);
		if (b) {
			if (configPanel == null) {
				configPanel = new TwisterConfigPanel(config, new DefaultViewContext(model), context, session);
				configPanel.setName(TwisterSwingResources.getInstance().getString("name.config"));
				model.setComponent(configPanel);
				p = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
				p.x -= getWidth() / 2;
				p.y -= getHeight() / 2;
				setLocation(p);
			}
		}
	}

	private class DefaultNavigationContainer extends JScrollPane implements NavigationContainer {
		private static final long serialVersionUID = 1L;

		/**
		 * 
		 */
		public DefaultNavigationContainer() {
			setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
			setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		}

		/**
		 * @see net.sf.jame.twister.swing.NavigationContainer#loadComponent(java.awt.Component, int)
		 */
		public void loadComponent(final Component c, final int amount) {
			final int defaultWidth = Integer.parseInt(TwisterSwingResources.getInstance().getString(ConfigFrame.CONFIG_FRAME_WIDTH));
			final int defaultMinHeight = Integer.parseInt(TwisterSwingResources.getInstance().getString(ConfigFrame.CONFIG_FRAME_MIN_HEIGHT));
			final int defaultMaxHeight = Integer.parseInt(TwisterSwingResources.getInstance().getString(ConfigFrame.CONFIG_FRAME_MAX_HEIGHT));
			final int width = Integer.getInteger(ConfigFrame.CONFIG_FRAME_WIDTH, defaultWidth);
			final int minHeight = Integer.getInteger(ConfigFrame.CONFIG_FRAME_MIN_HEIGHT, defaultMinHeight);
			final int maxHeight = Integer.getInteger(ConfigFrame.CONFIG_FRAME_MAX_HEIGHT, defaultMaxHeight);
			final Dimension newSize = c.getPreferredSize();
			final Dimension size = new Dimension(width, 20 + Math.min(Math.max(navigationPanel.getHeight() + newSize.height + getInsets().top + getInsets().bottom + ConfigFrame.this.getInsets().top + ConfigFrame.this.getInsets().bottom + amount, minHeight), maxHeight));
			// ConfigFrame.this.setPreferredSize(size);
			// ConfigFrame.this.setMinimumSize(size);
			// ConfigFrame.this.setMaximumSize(size);
			ConfigFrame.this.setSize(size);
			if (c != null) {
				getViewport().setView(c);
			}
			// ConfigFrame.this.validate();
			// ConfigFrame.this.repaint();
			ConfigFrame.this.setSize(size);
			// final Point p = ConfigFrame.this.getLocation();
			// int w = ConfigFrame.this.getWidth();
			// int h = ConfigFrame.this.getHeight();
			// ConfigFrame.this.pack();
			// Point q = new Point(p.x - (ConfigFrame.this.getWidth() - w) / 2, p.y - (ConfigFrame.this.getHeight() - h) / 2);
			// ConfigFrame.this.setLocation(q);
		}
	}

	private class DefaultViewContext implements ViewContext {
		private final NavigationModel model;

		/**
		 * @param model
		 */
		public DefaultViewContext(final NavigationModel model) {
			this.model = model;
		}

		/**
		 * @see net.sf.jame.twister.swing.ViewContext#setComponent(java.awt.Component)
		 */
		public void setComponent(final Component c) {
			model.setComponent(c);
		}

		/**
		 * @see net.sf.jame.twister.swing.ViewContext#removeComponent(java.awt.Component)
		 */
		public void removeComponent(final Component c) {
			model.removeComponent(c);
		}

		/**
		 * @see net.sf.jame.twister.swing.ViewContext#resize()
		 */
		public void resize() {
			model.resize(0);
		}

		/**
		 * @see net.sf.jame.twister.swing.ViewContext#resize(int)
		 */
		public void resize(final int amount) {
			model.resize(amount + 20);
		}
	}

	private class AdvancedConfigAction extends AbstractAction {
		private static final long serialVersionUID = 1L;

		/**
		 * 
		 */
		public AdvancedConfigAction() {
			super(TwisterSwingResources.getInstance().getString("action.advancedConfig"));
		}

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(final ActionEvent e) {
			if (configFrame == null) {
				configFrame = new NavigatorFrame(twisterTree, context, session);
			}
			configFrame.setVisible(true);
			configFrame.toFront();
		}
	}
}
