/*
 * $Id:AbstractLayerConfigElementXMLImporter.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.twister.frame.layer;

import java.util.List;

import net.sf.jame.core.xml.XMLImportException;
import net.sf.jame.core.xml.XMLImporter;
import net.sf.jame.twister.common.BooleanElement;
import net.sf.jame.twister.common.BooleanElementXMLImporter;
import net.sf.jame.twister.common.PercentageElement;
import net.sf.jame.twister.common.PercentageElementXMLImporter;

import org.w3c.dom.Element;

/**
 * @author Andrea Medeghini
 */
public abstract class AbstractLayerConfigElementXMLImporter<T extends LayerConfigElement> extends XMLImporter<T> {
	/**
	 * @return
	 */
	protected abstract String getConfigElementId();

	/**
	 * @return
	 */
	protected abstract T createConfigElement();

	/**
	 * @param configElement
	 * @param propertyElements
	 * @throws XMLImportException
	 */
	protected void importProperties(final T configElement, final List<Element> propertyElements) throws XMLImportException {
		this.importLocked(configElement, propertyElements.get(0));
		this.importVisible(configElement, propertyElements.get(1));
		this.importOpacity(configElement, propertyElements.get(2));
	}

	/**
	 * @return
	 */
	protected int getPropertiesSize() {
		return 3;
	}

	/**
	 * @param configElement
	 * @param element
	 * @throws XMLImportException
	 */
	protected void importLocked(final T configElement, final Element element) throws XMLImportException {
		final List<Element> elements = this.getElements(element, BooleanElement.CLASS_ID);
		if (elements.size() == 1) {
			configElement.setLocked(new BooleanElementXMLImporter().importFromElement(elements.get(0)).getValue());
		}
	}

	/**
	 * @param configElement
	 * @param element
	 * @throws XMLImportException
	 */
	protected void importVisible(final T configElement, final Element element) throws XMLImportException {
		final List<Element> elements = this.getElements(element, BooleanElement.CLASS_ID);
		if (elements.size() == 1) {
			configElement.setVisible(new BooleanElementXMLImporter().importFromElement(elements.get(0)).getValue());
		}
	}

	/**
	 * @param configElement
	 * @param element
	 * @throws XMLImportException
	 */
	protected void importOpacity(final T configElement, final Element element) throws XMLImportException {
		final List<Element> elements = this.getElements(element, PercentageElement.CLASS_ID);
		if (elements.size() == 1) {
			configElement.setOpacity(new PercentageElementXMLImporter().importFromElement(elements.get(0)).getValue());
		}
	}
}
