/*
 * $Id:TestRenderJobFileCache.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.test;

import java.io.File;

import net.sf.jame.service.ConnectionFactory;
import net.sf.jame.service.DefaultConnectionFactory;
import net.sf.jame.service.Session;
import net.sf.jame.service.job.RenderJob;
import net.sf.jame.service.job.RenderJobDataRow;
import net.sf.jame.service.job.RenderJobFileCache;

import org.junit.Assert;
import org.junit.Test;

public class TestRenderJobFileCache {
	private int lastId = 1;

	@Test
	public void testCreate() {
		try {
			final RenderJobFileCache fileCache = new RenderJobFileCache(new File("workdir/job"));
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			fileCache.deleteAll();
			fileCache.create(createJob().getJobId());
			fileCache.create(createJob().getJobId());
			fileCache.create(createJob().getJobId());
			fileCache.create(createJob().getJobId());
			final File[] jobs = fileCache.list();
			printClips(jobs);
			Assert.assertEquals(4, jobs.length);
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	@Test
	public void testDelete() {
		try {
			final RenderJobFileCache fileCache = new RenderJobFileCache(new File("workdir/job"));
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			fileCache.deleteAll();
			final RenderJobDataRow job = createJob();
			fileCache.create(job.getJobId());
			fileCache.delete(job.getJobId());
			final File[] jobs = fileCache.list();
			Assert.assertEquals(0, jobs.length);
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	private RenderJobDataRow createJob() {
		final RenderJobDataRow job = new RenderJobDataRow(new RenderJob());
		job.setJobId(lastId);
		job.setProfileName("Test Name");
		lastId += 1;
		return job;
	}

	private void printClips(final File[] jobs) {
		for (final File job : jobs) {
			System.out.println(job);
		}
	}
}
