/*
 * $Id:DistributedJobEncoder.java 491 2008-01-28 21:59:31Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.spool.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

import net.sf.jame.core.xml.XML;
import net.sf.jame.core.xml.XMLNodeBuilder;
import net.sf.jame.service.job.RenderJob;
import net.sf.jame.twister.TwisterClip;
import net.sf.jame.twister.TwisterClipXMLExporter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Andrea Medeghini
 */
public class DistributedJobEncoder {
	private final TwisterClip clip;
	private final RenderJob job;
	private final byte[] jobData;

	/**
	 * @param clip
	 * @param job
	 * @param jobData
	 */
	public DistributedJobEncoder(final TwisterClip clip, final RenderJob job, final byte[] jobData) {
		this.clip = clip;
		this.job = job;
		this.jobData = jobData;
	}

	/**
	 * @return the clip
	 */
	public TwisterClip getClip() {
		return clip;
	}

	/**
	 * @return the job
	 */
	public RenderJob getJob() {
		return job;
	}

	private void writeClip(final OutputStream os, final TwisterClip clip) throws IOException {
		try {
			final TwisterClipXMLExporter exporter = new TwisterClipXMLExporter();
			final Document doc = XML.createDocument();
			final XMLNodeBuilder builder = XML.createDefaultXMLNodeBuilder(doc);
			final Element element = exporter.exportToElement(clip, builder);
			doc.appendChild(element);
			XML.saveDocument(os, "twister-clip.xml", doc);
			os.close();
		}
		catch (final Exception e) {
			throw new IOException(e.getMessage());
		}
	}

	/**
	 * @return
	 * @throws IOException
	 */
	public byte[] getBytes() throws IOException {
		try {
			final ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
			writeClip(baos2, clip);
			baos2.close();
			final ByteArrayOutputStream baos = new ByteArrayOutputStream();
			final ObjectOutputStream oos = new ObjectOutputStream(baos);
			byte[] clipData = baos2.toByteArray(); 
			oos.writeObject(clipData);
			oos.writeObject(job);
			oos.writeObject(jobData);
			oos.close();
			baos.close();
			final byte[] data = baos.toByteArray();
			return data;
		}
		catch (final Exception e) {
			throw new IOException("An error has happened marshalling the data: " + e.getMessage());
		}
	}
}
