/*
 * $Id:ServiceRegistry.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service;

import net.sf.jame.core.extension.ConfigurableExtension;
import net.sf.jame.core.extension.ConfigurableExtensionRegistry;
import net.sf.jame.core.extension.ExtensionNotFoundException;
import net.sf.jame.service.encoder.extension.EncoderExtensionConfig;
import net.sf.jame.service.encoder.extension.EncoderExtensionRegistry;
import net.sf.jame.service.encoder.extension.EncoderExtensionRuntime;
import net.sf.jame.service.spool.extension.SpoolExtensionConfig;
import net.sf.jame.service.spool.extension.SpoolExtensionRegistry;
import net.sf.jame.service.spool.extension.SpoolExtensionRuntime;

/**
 * The service registry.
 * 
 * @author Andrea Medeghini
 */
public class ServiceRegistry {
	private ConfigurableExtensionRegistry<EncoderExtensionRuntime<?>, EncoderExtensionConfig> encoderRegistry;
	private ConfigurableExtensionRegistry<SpoolExtensionRuntime<?>, SpoolExtensionConfig> spoolRegistry;

	private static class RegistryHolder {
		private static final ServiceRegistry instance = new ServiceRegistry();
	}

	private ServiceRegistry() {
		setEncoderRegistry(new EncoderExtensionRegistry());
		setSpoolRegistry(new SpoolExtensionRegistry());
	}

	/**
	 * @return
	 */
	public static ServiceRegistry getInstance() {
		return RegistryHolder.instance;
	}

	/**
	 * Returns an encoder extension.
	 * 
	 * @param extensionId the extensionId.
	 * @return the extension.
	 * @throws ExtensionNotFoundException
	 */
	public ConfigurableExtension<EncoderExtensionRuntime<?>, EncoderExtensionConfig> getEncoderExtension(final String extensionId) throws ExtensionNotFoundException {
		return encoderRegistry.getConfigurableExtension(extensionId);
	}

	/**
	 * Returns a spool extension.
	 * 
	 * @param extensionId the extensionId.
	 * @return the extension.
	 * @throws ExtensionNotFoundException
	 */
	public ConfigurableExtension<SpoolExtensionRuntime<?>, SpoolExtensionConfig> getSpoolExtension(final String extensionId) throws ExtensionNotFoundException {
		return spoolRegistry.getConfigurableExtension(extensionId);
	}

	private void setEncoderRegistry(final ConfigurableExtensionRegistry<EncoderExtensionRuntime<?>, EncoderExtensionConfig> encoderRegistry) {
		this.encoderRegistry = encoderRegistry;
	}

	private void setSpoolRegistry(final ConfigurableExtensionRegistry<SpoolExtensionRuntime<?>, SpoolExtensionConfig> spoolRegistry) {
		this.spoolRegistry = spoolRegistry;
	}

	/**
	 * @return the encoderRegistry
	 */
	public ConfigurableExtensionRegistry<EncoderExtensionRuntime<?>, EncoderExtensionConfig> getEncoderRegistry() {
		return encoderRegistry;
	}

	/**
	 * @return the encoderRegistry
	 */
	public ConfigurableExtensionRegistry<SpoolExtensionRuntime<?>, SpoolExtensionConfig> getSpoolRegistry() {
		return spoolRegistry;
	}
}
