/*
 * $Id:JXTASpoolRuntime.java 474 2008-01-13 18:30:34Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.jxta.extensions.spool;

import java.io.File;

import net.sf.jame.core.util.Files;
import net.sf.jame.networking.jxta.JXTADiscoveryService;
import net.sf.jame.networking.jxta.JXTANetworkService;
import net.sf.jame.networking.jxta.JXTASpoolJobService;
import net.sf.jame.networking.spool.DistributedServiceProcessor;
import net.sf.jame.networking.spool.LocalServiceProcessor;
import net.sf.jame.service.Service;
import net.sf.jame.service.extensions.spool.AbstractSpoolExtensionRuntime;
import net.sf.jame.service.spool.DefaultJobService;
import net.sf.jame.service.spool.JobService;
import net.sf.jame.service.spool.SpoolJobInterface;
import net.sf.jame.service.spool.impl.DistributedJob;
import net.sf.jame.service.spool.impl.DistributedJobFactory;
import net.sf.jame.service.spool.impl.DistributedSpoolJobFactory;
import net.sf.jame.service.spool.impl.LocalSpoolJob;
import net.sf.jame.service.spool.impl.LocalSpoolJobFactory;

/**
 * @author Andrea Medeghini
 */
public class JXTASpoolRuntime extends AbstractSpoolExtensionRuntime<JXTASpoolConfig> {
	/**
	 * @see net.sf.jame.service.spool.extension.SpoolExtensionRuntime#getJobService(net.sf.jame.service.Service)
	 */
	@Override
	public JobService<? extends SpoolJobInterface> getJobService(final Service service) {
		final File tmpDir = new File(service.getWorkspace(), "JXTASpool");
		tmpDir.mkdirs();
		Files.deleteFiles(tmpDir);
		final DistributedServiceProcessor processor1 = new DistributedServiceProcessor(new DefaultJobService<DistributedJob>(new DistributedJobFactory(tmpDir)), 10);
		final LocalServiceProcessor processor2 = new LocalServiceProcessor(service, new DefaultJobService<LocalSpoolJob>(new LocalSpoolJobFactory(service)), 10);
		final JXTASpoolJobService jobService = new JXTASpoolJobService(new JXTADiscoveryService(new JXTANetworkService(tmpDir, "http://jame.sf.net", "JAME-Service", "Andrea Medeghini", "1.0", processor1), processor2), new DistributedSpoolJobFactory(service));
		return jobService;
	}
}
