/*
 * $Id:Assembly.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is based on code from idx3dIII
 * Copyright (C) 1999, 2000 Peter Walser, pwalser@idx3d.ch
 * http://www.idx3d.ch/idx3d/idx3d.html
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media.g3d;

import java.util.Enumeration;
import java.util.Hashtable;

public class Assembly extends Solid {
	private final Hashtable solids;

	public Assembly(final String name) {
		super(name);
		solids = new Hashtable();
	}

	public final void removePart(final Part solid) {
		solids.remove(solid.getName());
	}

	public final void addPart(final Part solid) {
		if (solid.getName() != null) {
			solids.put(solid.getName(), solid);
		}
	}

	public final void removeAssembly(final Assembly solid) {
		solids.remove(solid.getName());
	}

	public final void addAssembly(final Assembly solid) {
		if (solid.getName() != null) {
			solids.put(solid.getName(), solid);
		}
	}

	public final Solid getSolid(final String name) {
		return ((Solid) solids.get(name));
	}

	public final Enumeration getSolids() {
		return (solids.elements());
	}

	@Override
	final void project(Matrix ml, Matrix mt, final float vx, final float vy, final float vz) {
		Solid solid = null;
		mt = Matrix.multiply(mt, mp);
		ml = Matrix.multiply(ml, mr);
		final Enumeration solids = getSolids();
		while (solids.hasMoreElements()) {
			solid = (Solid) solids.nextElement();
			solid.project(ml, mt, vx, vy, vz);
		}
	}

	@Override
	final void rebuild() {
		Solid solid = null;
		final Enumeration solids = getSolids();
		while (solids.hasMoreElements()) {
			solid = (Solid) solids.nextElement();
			solid.parent = this;
			solid.rebuild();
		}
	}

	@Override
	public final void transform(final Matrix mt) {
		Solid solid = null;
		final Enumeration solids = getSolids();
		while (solids.hasMoreElements()) {
			solid = (Solid) solids.nextElement();
			solid.transform(mt);
		}
	}

	@Override
	public String toString() {
		final StringBuffer s = new StringBuffer("assembly: " + name + "\r\n");
		s.append("parent: " + ((parent != null) ? parent.name : "unknow") + "\r\n");
		Solid solid = null;
		final Enumeration solids = getSolids();
		while (solids.hasMoreElements()) {
			solid = (Solid) solids.nextElement();
			s.append(solid.toString());
		}
		return (s.toString());
	}
}
