/*
 * $Id:List.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

final class List extends LinkedList {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public List() {
	}

	public List(final Collection c) {
		try {
			final Iterator i = c.iterator();
			while (i.hasNext()) {
				final Object o = i.next();
				if (o instanceof Layer) {
					this.add(((Layer) o).clone());
				}
				else if (o instanceof Sequence) {
					this.add(((Sequence) o).clone());
				}
			}
		}
		catch (final CloneNotSupportedException e) {
			e.printStackTrace();
		}
	}

	@Override
	public Object clone() {
		return new List(this);
	}
}
