/*
 * $Id:AudioPlayer.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media;

import java.util.LinkedList;

import javax.sound.sampled.SourceDataLine;

public final class AudioPlayer extends Thread {
	private byte[] data;
	private final LinkedList queue;
	private final SourceDataLine line;

	public AudioPlayer(final String name, final SourceDataLine line) {
		super(name);
		this.line = line;
		queue = new LinkedList();
		setPriority(Thread.MAX_PRIORITY - 1);
		start();
	}

	@Override
	public void run() {
		// System.out.println("player started");
		try {
			while (true) {
				synchronized (queue) {
					if (queue.size() == 0) {
						queue.wait();
					}
					data = (byte[]) queue.removeFirst();
				}
				line.write(data, 0, data.length);
			}
		}
		catch (final InterruptedException e) {
		}
		// System.out.println("player stopped");
	}

	public void play(final byte[] data) {
		synchronized (queue) {
			// System.out.println("data enqueued");
			queue.addLast(data);
			queue.notify();
		}
	}

	public void clear() {
		synchronized (queue) {
			queue.clear();
		}
	}

	public void kill() {
		synchronized (this) {
			interrupt();
			try {
				this.join();
			}
			catch (final InterruptedException e) {
			}
		}
	}
}
