/*
 * $Id:AbstractGraphics.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

abstract class AbstractGraphics extends AbstractObject {
	public final void setTransform(final AffineTransform transform) {
		if (transform != null) {
			getTransform().setTransform(transform);
		}
	}

	public abstract Point2D getCenter();

	public abstract AffineTransform getTransform();

	public final void translate(final float x, final float y) {
		getTransform().translate(x, y);
	}

	public final void shear(final float x, final float y) {
		getTransform().shear(x, y);
	}

	public final void scale(final float x, final float y) {
		getTransform().scale(x, y);
	}

	public final void rotate(final float a) {
		getTransform().rotate(a, getCenter().getX(), getCenter().getY());
	}
}
