/*
 * $Id:RenderedPoint.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.renderer;

/**
 * @author Andrea Medeghini
 */
public class RenderedPoint {
	/**
	 * 
	 */
	public double xr;
	/**
	 * 
	 */
	public double xi;
	/**
	 * 
	 */
	public double zr;
	/**
	 * 
	 */
	public double zi;
	/**
	 * 
	 */
	public double wr;
	/**
	 * 
	 */
	public double wi;
	/**
	 * 
	 */
	public double tr;
	/**
	 * 
	 */
	public double ti;
	/**
	 * 
	 */
	public int time;

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder point = new StringBuilder();
		point.append("<xr = ");
		point.append(xr);
		point.append(", xi = ");
		point.append(xi);
		point.append(", zr = ");
		point.append(zr);
		point.append(", zi = ");
		point.append(zi);
		point.append(", wr = ");
		point.append(wr);
		point.append(", wi = ");
		point.append(wi);
		point.append(", tr = ");
		point.append(tr);
		point.append(", ti = ");
		point.append(ti);
		point.append(", time = ");
		point.append(time);
		point.append(">");
		return point.toString();
	}
}
